## Neural Payoff Machines: Predicting Fair and Stable Payoff Allocations Among Team Members

---

### Setup

In order to run the code, first install and then activate the conda environment in `payoff_env.yml`. We outline the procedure for reproducing our main results for both experimental settings: weighted voting games (WVGs) (full details in section 3.1) and Feature importance games (full details in section 3.2). Moreover, we provide a code-based introduction to the used cooperative game theory solution concepts in `CooperativeGameTheoryIntro.ipynb`.

### 1 Weighted Voting Games

#### A. Generate Data

To generate training data for the _fixed-size_ models, go to the `gen_fixed_data_train.py` file in `WeightedVotingGames/DataGeneration/`. Before running, make sure to set the desired parameters. For example, to generate a training dataset with 5000 games for `N \in { 4, 5, ... , 10 }` players, we use the following settings:

```Python
for player in range(4, 11):

    PARAMS = {
        'n_games'     : 5000,
        'n_players'   : player, 
        'prob_q'      : 'gauss',
        'alpha'       : 1,
        'beta'        : 1,
        'loc'         : 1,
        'path'        : '',
        'filename'    : 'players_train.pickle', 
        'least_core'  : True,
        'shapley'     : True,
        'banzhaf'     : True,  
        'approximate' : True,
        'n_samples'   : 1000,
        'n_resamples' : 10,
    }
```

To generate test datasets, navigate to `WeightedVotingGames/DataGeneration/gen_fixed_data_test.py`. In both cases, make sure to specify the `path` in the `PARAMS` dictionary so that the data is stored at the desired place. To generate train and test data for the _variable-size_ models, navigate to `gen_var_data_train.py` and `gen_var_data_test.py` and specify the range of players to include in `players_list`. Note that `n_games_play` indicates the number of games to generate per $N$ player game, and `max_len` specifies the column length. Set this to the maximum number of players you would like to predict games for at test time. In our experiments, we generated the training dataset for the variable-size models with this configuration:

```Python
PARAMS = {
    'player_list'   : np.arange(4, 11),
    'n_games_play'  : 5000, # Number of games to generate per player
    'max_len'       : 20,   # Sequence length
    'prob_q'        : 'gauss',
    'alpha'         : 1,
    'beta'          : 1,
    'loc'           : 1,
    'log'           : False,
    'path'          : '',
    'filename'      : '4to10play_train.pickle', 
    'least_core'    : True,
    'shapley'       : True,
    'banzhaf'       : True,  
    'n_samples'     : 1000,
    'n_resamples'   : 10,
}
```

#### B. Training Models

For training models on datasets of weighted voting games, navigate to `WeightedVotingGames/TrainModels/`. We run hyperparameter sweeps for each fixed-size model -- `FixedLeastcore_SweepAgent.ipynb`, `FixedPowerIndex_SweepAgent.ipynb` -- and sweeps for the variable-size models -- `VarLeastcore_SweepAgent.ipynb`, `VarPowerIndex_SweepAgent.ipynb`  (see paper appendix D.1). When `CHECKPOINT` is set to `True`, models are automatically stored as `.pt` files in the designated folders afer every run.  We use [Weights & Biased](https://wandb.ai/site) for logging. To log data with W&B it is easiest to setup a personal account, then set `LOG : True` in the `ARGS` dictionary. 

For example, to run sweeps with a fixed-size model on the Least-Core solutions with 8 players we specify parameters in `FixedLeastcore_SweepAgent.ipynb` as follows:
```Python
n_players = 8 

ARGS = {
    'train_set_path'  : 'DATA_PATH',
    'checkpoint_path' : 'CHECKPOINT_PATH',
    'filename'        : f'{n_players}players_train.pickle',
    'sol_concept'     : 'Core', 
    'n_players'       : n_players,
    'epochs'          : 4000, 
    'train_split'     : 0.7,
    'n_sweeps'        : 50,
    'base_epochs'     : 500,
    'patience'        : 50,
    'device'          : torch.device('cuda' if torch.cuda.is_available() else 'cpu'),
    'LOG'             : True,
    'CHECKPOINT'      : True,
}
```

#### C. Evaluate And Compare Models

Navigate to `WeightedVotingGames/EvaluateModels`. After finishing the sweeps, we selected the best models trained on the Least-Core solution concept in the folder `LeastcoreSelected` and the best models trained on Shapley and Banzhaf in the folder `PowerIndexSelected` (full details in appendix D.1). To reproduce main figures the results sections in the papaer, run the notebooks `MakeLeastcoreFigures.ipynb` and `MakePowerIndexFigures.ipynb` with the correct path specifications.

Specifically, make sure to specify the path to the fixed test datasets and variable dataset in the `PARAMS` dictionary:
```Python
PARAMS = {
    'test_path_fixed' : '...',
    'test_path_var'   : '...',
    'checkpoint_path' : '.../EvaluateModels/LeastcoreSelected/',
}
```

### 2 Feature Importance Games

#### A. Preprocess A Dataset

We take two well-known datasets: the UCI Banking dataset and the Melbourne Housing dataset (full details in Appendix D.2 and F) and perform minimal preprocessing. First,  make sure to specify the path to the datasets in the folder `csvdata` (see below). Then, run the cells in `Preprocess.ipynb` to perform the preprocessing steps. The resulting feature matrix and Shapley value matrices are stored as `.pt` files.

```Python
df_melbourne = pd.read_csv('< specify path >')
df_bank = pd.read_csv('< specify path >')
```

#### B. Run The Experiments

Completing the steps in A. yields a feature and Shapley value matrix for both datasets. To reproduce Figure 7 in the main paper, specify the file paths in `FEATURE_PATH` and `SHAPLEY_PATH` in the file `run_experiment.py`. Once these are defined correctly, run the script to train an MLP for each train/test split and plot the RMSEs as a function of the training fraction.