#!/bin/bash

# * laptop

# * DAGCN
python ./train.py --model_name DAGCN --dataset laptop --seed 1000 --num_epoch 50 --vocab_dir ./dataset/Laptops_corenlp --cuda 0 --alpha 0.7 --beta 0.9 --gama 0.3
# * DAGCN with Bert
python ./train.py --model_name DAGCNBERT --dataset laptop --seed 1000  --bert_lr 2e-5 --num_epoch 15 --hidden_dim 768 --max_length 100 --cuda 0 --alpha 0.5 --beta 0.8 --gama 0.1


# * restaurant

# * DAGCN
CUDA_VISIBLE_DEVICES=0 python ./train.py --model_name DAGCN --dataset restaurant --seed 1000 --num_epoch 50 --vocab_dir ./dataset/Restaurants_corenlp --cuda 0 --alpha 0.7 --beta 0.3 --gama 0.8
# * DAGCN with Bert
CUDA_VISIBLE_DEVICES=0 python ./train.py --model_name DAGCNBERT --dataset restaurant --seed 1000 --bert_lr 2e-5 --num_epoch 15 --hidden_dim 768 --max_length 100 --cuda 0 --alpha 1.4 --beta 0.2 --gama 1.2


# * twitter

# * DAGCN
CUDA_VISIBLE_DEVICES=0 python ./train.py --model_name DAGCN --dataset twitter --seed 1000 --num_epoch 50 --vocab_dir ./dataset/Tweets_corenlp --cuda 0 --alpha 0.2 --beta 0.6 --gama 0.2
# * DualGCN with Bert
CUDA_VISIBLE_DEVICES=0 python ./train.py --model_name DAGCNBERT --dataset twitter --seed 1000 --bert_lr 2e-5 --num_epoch 15 --hidden_dim 768 --max_length 100 --cuda 0 --alpha 0.5 --beta 1.7 --gama 1.4