import argparse
from sub_main import *

def boolean_string(s):
    if s not in {'False', 'True'}:
        raise ValueError('Not a valid boolean string')
    return s == 'True'


parser  = argparse.ArgumentParser(description = 'Run Compression Scheme')
parser.add_argument('-a', '--architecture' , type=str, metavar='' , required='True', help='Architecture of DNN')
parser.add_argument('-d', '--dataset' , type=str, metavar='' , required='True', help='Dataset')
parser.add_argument('-m', '--method' , type=str, metavar='', required='True' , help='Compression Method')
parser.add_argument('-r', '--retrain' , type=boolean_string, metavar='', required='True' , help='Retrain or Not?')
parser.add_argument('-c', '--category' , type=str, metavar='', required='True' , help='Compress FC Biases/All Biases/Whole Network without FC Layers')

args = parser.parse_args()

def main(args):
    CompressionMain(args)

if __name__== "__main__":
    main(args)
