import logging
import os
import time


class logger(object):
    """
    Processing log class
    """

    def __init__(self):
        # Configure output format
        self.LOG_FORMAT = (
            "%(asctime)s %(name)s %(levelname)s %(pathname)s %(message)s %(funcName)s"
        )
        # Configure the output time format
        self.DATE_FORMAT = "%Y-%m-%d  %H:%M:%S %a "
        # Configure log output location
        self.path = (
            os.path.split(os.path.realpath(__file__))[0]
            + r"/logfile/"
            + time.strftime("%Y-%m-%d-%H-%M-%S", time.gmtime())
        )
        self.setting()
        self.log = logging.getLogger()
        self.log.setLevel(logging.INFO)

    def setting(self):
        # With the filename parameter, the output will not be directly displayed to the console, but written directly to the file
        logging.basicConfig(
            level=logging.INFO,
            format=self.LOG_FORMAT,
            datefmt=self.DATE_FORMAT,
            filename=self.path,
            filemode="w",
        )

    def debug(self, msg):
        self.log.debug(msg)

    def info(self, msg):
        self.log.info(msg)

    def warning(self, msg):
        self.log.warning(msg)

    def error(self, msg):
        self.log.error(msg)

    def critical(self, msg):
        self.log.critical(msg)


if __name__ == "__main__":
    logger = logger()
    logger.setLevel(logging.INFO)
