from moviepy.editor import VideoFileClip, TextClip, CompositeVideoClip, clips_array

file = 'heat'

# Load the two MP4 videos
video1 = VideoFileClip(f"./data/generated/{file}/real_res.mp4")
video2 = VideoFileClip(f"./data/generated/{file}/gen_res.mp4")

# Ensure both videos have the same duration
min_duration = min(video1.duration, video2.duration)
video1 = video1.subclip(0, min_duration)
video2 = video2.subclip(0, min_duration)

# Combine videos side-by-side
side_by_side_clip = clips_array([[video1, video2]])

# Add a title
title_text = "Real solution (L) vs. Generated solution (R)"
title = TextClip(title_text, fontsize=18, color='black', font='Arial-Bold')
title = title.set_duration(min_duration).set_position(("center", "top"))

# Create the final composite clip
final_clip = CompositeVideoClip([side_by_side_clip, title])

# Save the result as an MP4 file
final_clip.write_videofile(f"./data/generated/{file}_combined.mp4", codec="libx264", fps=video1.fps)
