import time

config = {
    # 'seed': 1747127322,   # set seed for PRNG
    'seed': int(time.time()),   # set seed for PRNG
    # 'op_seed': 873282266,
    'op_seed': 42,
    'law': 'norm',  # Type of noise
    'history_length': 18,  # Input history length for token map training
    'res_history_length': 7,  # (Total) history length for the resolution model. Needs to be an odd number
    'epochs': 500000,  # No. of loops of the training data
    # 'batch_size': 216,  # No. of samples to train on at once
    'batch_size': 768,  # No. of samples to train on at once
    'lr': 0.00001,  # Learning rate for Adam optimiser
    'LD': 128,  # set grid dimensions
    'c': 4,  # length dimension of each filter
    # set shape parameter
    # strength of noise aka variance depends linearly on lambda
    'lambda': 10,
    'init_lambda': 10,
    # set Matern class params
    'm': .1,  # inverse correlation length scale in lattice step units
    'nu': 1,  # smoothness of Matern function (higher is smoother)
    'init_nu': 1,
    # set equation simulation parameters
    'T': 2000,  # timesteps to generate (for dataset). Need (L/c)^2 x h + h (input size) for determined system (for heat equation. Factor of 2 for wave)
    'keep_every': 1,  # how many frames to skip, has the effect of speeding up time, without losing convergence. 1 to disable
    'T_a': 1000,  # timesteps to animate
    'speed_up': 1,  # keep only every nth frame when saving the animation, only applies to saving animations
    'time_factor': 0.4,  # Needs to be 1 or less for numerical stability in the heat equation, much less for wave equation
    'alpha': 1,  # alpha parameter for heat/wave equations
    'delta_x': 1,  # spatial dimension step
    'sample_size': 100,  # for generating multiple datasets
    'domain_mult': 8,  # domain size for KSE
    'epsilon': 0.1,  # tolerance parameter in a few places e.g. observability checks and adversarial learning
    'data_dir': 'data/kse/test', # directory to save/load data
    'save': False,  # Do I want to save lots of plots?
}

# Auto-set total frames for resolution model. Comment to disable.
# config['T'] = config['res_history_length'] * (config['LD'] // config['c']) ** 2 + config['res_history_length']
# config['T'] = config['history_length'] * (config['LD'] // config['c']) ** 2 + config['history_length']
