# About this dataset

## Parameters

| Parameter | Heat | Wave | KSE |
|  :----------------  |  ------:  |  ----:  | ----:|
| Resolution | 128 x 128 | 128 x 128 | 256 x 256 
| Timesteps | 2000 | 2000 | 2000
| Folder structure | `/heat/{operator}/{init_cond}` | `/wave/{operator}/{init_cond}` | `/kse/{init_cond}`
| File structure | Pytorch Pickletensor | Pytorch Pickletensor | Pytorch Pickletensor
| Numerical method | Explicit Euler | Explicit Euler | ETDRK4 (Modified)[^1]
| Time factor | 0.4 | 0.05 | 0.01
| No. simulations | 4 x 100 | 2 x 100 | 28 |

## Further Details

All datasets are 2D. A 500 frame burn-in time was discarded from the KSE simulations, to give the 2000 frame datasets shared here. The heat and wave equations use a modified Laplacian, namely $\tilde{\nabla}^2 \rightarrow \nabla^T A \nabla$ for some positive definite, stochastically generated, diagonal matrix $A$. This modified operator is provided as `op.pt` in the relevant folder. Each run with a given operator simulates 100 stochastically generated initial conditions for 2000 frames, hence the folder structure. Data available upon request, since it is too large to upload as supplementary material.

[^1]: [Kassam et. al. (2005)](https://people.maths.ox.ac.uk/trefethen/publication/PDF/2005_111.pdf)
