#!/usr/bin/env bash

set -eux;

CURRENT_DIR=`pwd`
HOME_DIR=`realpath ../`;

langs=java,python,en_XX

SOURCE=$1
TARGET=$2

PATH_2_DATA=${HOME_DIR}/data/codenet-plbart-inference/${SOURCE}-${TARGET}

echo "Source: $SOURCE Target: $TARGET"

MODEL_DIR=${HOME_DIR}/scripts/codenet-models/${SOURCE}_${TARGET}
SAVE_DIR=${CURRENT_DIR}/codenet-models-inference/${SOURCE}_${TARGET}
mkdir -p ${SAVE_DIR}
USER_DIR=${HOME_DIR}/source


function generate () {

model=${MODEL_DIR}/checkpoint_best.pt
FILE_PREF=${SAVE_DIR}/output.test
GOUND_TRUTH_PATH=$PATH_2_DATA/test.java-cs.txt.${TARGET}

fairseq-generate $PATH_2_DATA/data-bin \
    --user-dir $USER_DIR \
    --path $model \
    --truncate-source \
    --task translation_without_lang_token \
    --gen-subset test \
    -t $TARGET -s $SOURCE \
    --remove-bpe 'sentencepiece' \
    --max-len-b 512 \
    --beam 5 \
    --nbest 5 \
    --batch-size 4 \
    --langs $langs > $FILE_PREF

cat $FILE_PREF | grep -P "^H" |sort -V |cut -f 3- | sed 's/\[${TARGET}\]//g' > $FILE_PREF.hyp

}

generate
