#ifndef CUFFTDX_FFT_25_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_25_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<704, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .f64 fd<601>;
.reg .b64 rd<2>;
add.f64 fd101, %63, %103;
add.f64 fd102, %50, fd101;
add.f64 fd103, %76, %90;
add.f64 fd104, fd103, fd102;
add.f64 fd105, %65, %105;
add.f64 fd106, %51, fd105;
add.f64 fd107, %78, %91;
add.f64 fd108, fd107, fd106;
fma.rn.f64 fd109, fd101, 0d3FD3C6EF372FE950, %50;
mul.f64 fd110, fd103, 0d3FE9E3779B97F4A8;
sub.f64 fd111, fd109, fd110;
sub.f64 fd112, %65, %105;
mul.f64 fd113, fd112, 0d3FEE6F0E134454FF;
sub.f64 fd114, %78, %91;
fma.rn.f64 fd115, fd114, 0d3FE2CF2304755A5E, fd113;
sub.f64 fd116, fd111, fd115;
add.f64 fd117, fd115, fd111;
mul.f64 fd118, fd101, 0d3FE9E3779B97F4A8;
sub.f64 fd119, %50, fd118;
fma.rn.f64 fd120, fd103, 0d3FD3C6EF372FE950, fd119;
mul.f64 fd121, fd112, 0d3FE2CF2304755A5E;
mul.f64 fd122, fd114, 0d3FEE6F0E134454FF;
sub.f64 fd123, fd121, fd122;
sub.f64 fd124, fd120, fd123;
add.f64 fd125, fd123, fd120;
fma.rn.f64 fd126, fd105, 0d3FD3C6EF372FE950, %51;
mul.f64 fd127, fd107, 0d3FE9E3779B97F4A8;
sub.f64 fd128, fd126, fd127;
sub.f64 fd129, %63, %103;
mul.f64 fd130, fd129, 0d3FEE6F0E134454FF;
sub.f64 fd131, %76, %90;
fma.rn.f64 fd132, fd131, 0d3FE2CF2304755A5E, fd130;
add.f64 fd133, fd132, fd128;
sub.f64 fd134, fd128, fd132;
mul.f64 fd135, fd105, 0d3FE9E3779B97F4A8;
sub.f64 fd136, %51, fd135;
fma.rn.f64 fd137, fd107, 0d3FD3C6EF372FE950, fd136;
mul.f64 fd138, fd129, 0d3FE2CF2304755A5E;
mul.f64 fd139, fd131, 0d3FEE6F0E134454FF;
sub.f64 fd140, fd138, fd139;
add.f64 fd141, fd140, fd137;
sub.f64 fd142, fd137, fd140;
add.f64 fd143, %66, %106;
add.f64 fd144, %52, fd143;
add.f64 fd145, %79, %92;
add.f64 fd146, fd145, fd144;
add.f64 fd147, %67, %107;
add.f64 fd148, %54, fd147;
add.f64 fd149, %81, %94;
add.f64 fd150, fd149, fd148;
fma.rn.f64 fd151, fd143, 0d3FD3C6EF372FE950, %52;
mul.f64 fd152, fd145, 0d3FE9E3779B97F4A8;
sub.f64 fd153, fd151, fd152;
sub.f64 fd154, %67, %107;
mul.f64 fd155, fd154, 0d3FEE6F0E134454FF;
sub.f64 fd156, %81, %94;
fma.rn.f64 fd157, fd156, 0d3FE2CF2304755A5E, fd155;
sub.f64 fd158, fd153, fd157;
add.f64 fd159, fd157, fd153;
mul.f64 fd160, fd143, 0d3FE9E3779B97F4A8;
sub.f64 fd161, %52, fd160;
fma.rn.f64 fd162, fd145, 0d3FD3C6EF372FE950, fd161;
mul.f64 fd163, fd154, 0d3FE2CF2304755A5E;
mul.f64 fd164, fd156, 0d3FEE6F0E134454FF;
sub.f64 fd165, fd163, fd164;
sub.f64 fd166, fd162, fd165;
add.f64 fd167, fd165, fd162;
fma.rn.f64 fd168, fd147, 0d3FD3C6EF372FE950, %54;
mul.f64 fd169, fd149, 0d3FE9E3779B97F4A8;
sub.f64 fd170, fd168, fd169;
sub.f64 fd171, %66, %106;
mul.f64 fd172, fd171, 0d3FEE6F0E134454FF;
sub.f64 fd173, %79, %92;
fma.rn.f64 fd174, fd173, 0d3FE2CF2304755A5E, fd172;
add.f64 fd175, fd174, fd170;
sub.f64 fd176, fd170, fd174;
mul.f64 fd177, fd147, 0d3FE9E3779B97F4A8;
sub.f64 fd178, %54, fd177;
fma.rn.f64 fd179, fd149, 0d3FD3C6EF372FE950, fd178;
mul.f64 fd180, fd171, 0d3FE2CF2304755A5E;
mul.f64 fd181, fd173, 0d3FEE6F0E134454FF;
sub.f64 fd182, fd180, fd181;
add.f64 fd183, fd182, fd179;
sub.f64 fd184, fd179, fd182;
add.f64 fd185, %68, %108;
add.f64 fd186, %55, fd185;
add.f64 fd187, %82, %95;
add.f64 fd188, fd187, fd186;
add.f64 fd189, %70, %110;
add.f64 fd190, %57, fd189;
add.f64 fd191, %83, %97;
add.f64 fd192, fd191, fd190;
fma.rn.f64 fd193, fd185, 0d3FD3C6EF372FE950, %55;
mul.f64 fd194, fd187, 0d3FE9E3779B97F4A8;
sub.f64 fd195, fd193, fd194;
sub.f64 fd196, %70, %110;
mul.f64 fd197, fd196, 0d3FEE6F0E134454FF;
sub.f64 fd198, %83, %97;
fma.rn.f64 fd199, fd198, 0d3FE2CF2304755A5E, fd197;
sub.f64 fd200, fd195, fd199;
add.f64 fd201, fd199, fd195;
mul.f64 fd202, fd185, 0d3FE9E3779B97F4A8;
sub.f64 fd203, %55, fd202;
fma.rn.f64 fd204, fd187, 0d3FD3C6EF372FE950, fd203;
mul.f64 fd205, fd196, 0d3FE2CF2304755A5E;
mul.f64 fd206, fd198, 0d3FEE6F0E134454FF;
sub.f64 fd207, fd205, fd206;
sub.f64 fd208, fd204, fd207;
add.f64 fd209, fd207, fd204;
fma.rn.f64 fd210, fd189, 0d3FD3C6EF372FE950, %57;
mul.f64 fd211, fd191, 0d3FE9E3779B97F4A8;
sub.f64 fd212, fd210, fd211;
sub.f64 fd213, %68, %108;
mul.f64 fd214, fd213, 0d3FEE6F0E134454FF;
sub.f64 fd215, %82, %95;
fma.rn.f64 fd216, fd215, 0d3FE2CF2304755A5E, fd214;
add.f64 fd217, fd216, fd212;
sub.f64 fd218, fd212, fd216;
mul.f64 fd219, fd189, 0d3FE9E3779B97F4A8;
sub.f64 fd220, %57, fd219;
fma.rn.f64 fd221, fd191, 0d3FD3C6EF372FE950, fd220;
mul.f64 fd222, fd213, 0d3FE2CF2304755A5E;
mul.f64 fd223, fd215, 0d3FEE6F0E134454FF;
sub.f64 fd224, fd222, fd223;
add.f64 fd225, fd224, fd221;
sub.f64 fd226, fd221, fd224;
add.f64 fd227, %71, %111;
add.f64 fd228, %58, fd227;
add.f64 fd229, %84, %98;
add.f64 fd230, fd229, fd228;
add.f64 fd231, %73, %113;
add.f64 fd232, %59, fd231;
add.f64 fd233, %86, %99;
add.f64 fd234, fd233, fd232;
fma.rn.f64 fd235, fd227, 0d3FD3C6EF372FE950, %58;
mul.f64 fd236, fd229, 0d3FE9E3779B97F4A8;
sub.f64 fd237, fd235, fd236;
sub.f64 fd238, %73, %113;
mul.f64 fd239, fd238, 0d3FEE6F0E134454FF;
sub.f64 fd240, %86, %99;
fma.rn.f64 fd241, fd240, 0d3FE2CF2304755A5E, fd239;
sub.f64 fd242, fd237, fd241;
add.f64 fd243, fd241, fd237;
mul.f64 fd244, fd227, 0d3FE9E3779B97F4A8;
sub.f64 fd245, %58, fd244;
fma.rn.f64 fd246, fd229, 0d3FD3C6EF372FE950, fd245;
mul.f64 fd247, fd238, 0d3FE2CF2304755A5E;
mul.f64 fd248, fd240, 0d3FEE6F0E134454FF;
sub.f64 fd249, fd247, fd248;
sub.f64 fd250, fd246, fd249;
add.f64 fd251, fd249, fd246;
fma.rn.f64 fd252, fd231, 0d3FD3C6EF372FE950, %59;
mul.f64 fd253, fd233, 0d3FE9E3779B97F4A8;
sub.f64 fd254, fd252, fd253;
sub.f64 fd255, %71, %111;
mul.f64 fd256, fd255, 0d3FEE6F0E134454FF;
sub.f64 fd257, %84, %98;
fma.rn.f64 fd258, fd257, 0d3FE2CF2304755A5E, fd256;
add.f64 fd259, fd258, fd254;
sub.f64 fd260, fd254, fd258;
mul.f64 fd261, fd231, 0d3FE9E3779B97F4A8;
sub.f64 fd262, %59, fd261;
fma.rn.f64 fd263, fd233, 0d3FD3C6EF372FE950, fd262;
mul.f64 fd264, fd255, 0d3FE2CF2304755A5E;
mul.f64 fd265, fd257, 0d3FEE6F0E134454FF;
sub.f64 fd266, fd264, fd265;
add.f64 fd267, fd266, fd263;
sub.f64 fd268, fd263, fd266;
add.f64 fd269, %74, %114;
add.f64 fd270, %60, fd269;
add.f64 fd271, %87, %100;
add.f64 fd272, fd271, fd270;
add.f64 fd273, %75, %115;
add.f64 fd274, %62, fd273;
add.f64 fd275, %89, %102;
add.f64 fd276, fd275, fd274;
fma.rn.f64 fd277, fd269, 0d3FD3C6EF372FE950, %60;
mul.f64 fd278, fd271, 0d3FE9E3779B97F4A8;
sub.f64 fd279, fd277, fd278;
sub.f64 fd280, %75, %115;
mul.f64 fd281, fd280, 0d3FEE6F0E134454FF;
sub.f64 fd282, %89, %102;
fma.rn.f64 fd283, fd282, 0d3FE2CF2304755A5E, fd281;
sub.f64 fd284, fd279, fd283;
add.f64 fd285, fd283, fd279;
mul.f64 fd286, fd269, 0d3FE9E3779B97F4A8;
sub.f64 fd287, %60, fd286;
fma.rn.f64 fd288, fd271, 0d3FD3C6EF372FE950, fd287;
mul.f64 fd289, fd280, 0d3FE2CF2304755A5E;
mul.f64 fd290, fd282, 0d3FEE6F0E134454FF;
sub.f64 fd291, fd289, fd290;
sub.f64 fd292, fd288, fd291;
add.f64 fd293, fd291, fd288;
fma.rn.f64 fd294, fd273, 0d3FD3C6EF372FE950, %62;
mul.f64 fd295, fd275, 0d3FE9E3779B97F4A8;
sub.f64 fd296, fd294, fd295;
sub.f64 fd297, %74, %114;
mul.f64 fd298, fd297, 0d3FEE6F0E134454FF;
sub.f64 fd299, %87, %100;
fma.rn.f64 fd300, fd299, 0d3FE2CF2304755A5E, fd298;
add.f64 fd301, fd300, fd296;
sub.f64 fd302, fd296, fd300;
mul.f64 fd303, fd273, 0d3FE9E3779B97F4A8;
sub.f64 fd304, %62, fd303;
fma.rn.f64 fd305, fd275, 0d3FD3C6EF372FE950, fd304;
mul.f64 fd306, fd297, 0d3FE2CF2304755A5E;
mul.f64 fd307, fd299, 0d3FEE6F0E134454FF;
sub.f64 fd308, fd306, fd307;
add.f64 fd309, fd308, fd305;
sub.f64 fd310, fd305, fd308;
mul.f64 fd311, fd158, 0d3FEEFEA21D101EE0;
mul.f64 fd312, fd175, 0d3FCFD511FA1C0796;
sub.f64 fd313, fd311, fd312;
mul.f64 fd314, fd175, 0d3FEEFEA21D101EE0;
fma.rn.f64 fd315, fd158, 0d3FCFD511FA1C0796, fd314;
mul.f64 fd316, fd200, 0d3FEC0AB44E81C059;
mul.f64 fd317, fd217, 0d3FDED50D5CBFA951;
sub.f64 fd318, fd316, fd317;
mul.f64 fd319, fd217, 0d3FEC0AB44E81C059;
fma.rn.f64 fd320, fd200, 0d3FDED50D5CBFA951, fd319;
mul.f64 fd321, fd242, 0d3FE753B603D2B816;
mul.f64 fd322, fd259, 0d3FE5E7CF55112014;
sub.f64 fd323, fd321, fd322;
mul.f64 fd324, fd259, 0d3FE753B603D2B816;
fma.rn.f64 fd325, fd242, 0d3FE5E7CF55112014, fd324;
mul.f64 fd326, fd284, 0d3FE1257E3C182B51;
mul.f64 fd327, fd301, 0d3FEB04BBFF642E86;
sub.f64 fd328, fd326, fd327;
mul.f64 fd329, fd301, 0d3FE1257E3C182B51;
fma.rn.f64 fd330, fd284, 0d3FEB04BBFF642E86, fd329;
mul.f64 fd331, fd166, 0d3FEC0AB44E81C059;
mul.f64 fd332, fd183, 0d3FDED50D5CBFA951;
sub.f64 fd333, fd331, fd332;
mul.f64 fd334, fd183, 0d3FEC0AB44E81C059;
fma.rn.f64 fd335, fd166, 0d3FDED50D5CBFA951, fd334;
mul.f64 fd336, fd208, 0d3FE1257E3C182B51;
mul.f64 fd337, fd225, 0d3FEB04BBFF642E86;
sub.f64 fd338, fd336, fd337;
mul.f64 fd339, fd225, 0d3FE1257E3C182B51;
fma.rn.f64 fd340, fd208, 0d3FEB04BBFF642E86, fd339;
mul.f64 fd341, fd250, 0d3FB0130A1BE09379;
mul.f64 fd342, fd267, 0d3FEFEFD5BFE443FE;
sub.f64 fd343, fd341, fd342;
mul.f64 fd344, fd267, 0d3FB0130A1BE09379;
fma.rn.f64 fd345, fd250, 0d3FEFEFD5BFE443FE, fd344;
mul.f64 fd346, fd292, 0dBFDB3FF7C925819C;
mul.f64 fd347, fd309, 0d3FECF457DCDC158C;
sub.f64 fd348, fd346, fd347;
mul.f64 fd349, fd309, 0dBFDB3FF7C925819C;
fma.rn.f64 fd350, fd292, 0d3FECF457DCDC158C, fd349;
mul.f64 fd351, fd167, 0d3FE753B603D2B816;
mul.f64 fd352, fd184, 0d3FE5E7CF55112014;
sub.f64 fd353, fd351, fd352;
mul.f64 fd354, fd184, 0d3FE753B603D2B816;
fma.rn.f64 fd355, fd167, 0d3FE5E7CF55112014, fd354;
mul.f64 fd356, fd209, 0d3FB0130A1BE09379;
mul.f64 fd357, fd226, 0d3FEFEFD5BFE443FE;
sub.f64 fd358, fd356, fd357;
mul.f64 fd359, fd226, 0d3FB0130A1BE09379;
fma.rn.f64 fd360, fd209, 0d3FEFEFD5BFE443FE, fd359;
mul.f64 fd361, fd251, 0dBFE465C6FEB501BC;
mul.f64 fd362, fd268, 0d3FE8A80B635B6BEA;
sub.f64 fd363, fd361, fd362;
mul.f64 fd364, fd268, 0dBFE465C6FEB501BC;
fma.rn.f64 fd365, fd251, 0d3FE8A80B635B6BEA, fd364;
mul.f64 fd366, fd293, 0dBFEFBF675480D903;
mul.f64 fd367, fd310, 0d3FC00AEB5DA15BE0;
sub.f64 fd368, fd366, fd367;
mul.f64 fd369, fd310, 0dBFEFBF675480D903;
fma.rn.f64 fd370, fd293, 0d3FC00AEB5DA15BE0, fd369;
mul.f64 fd371, fd159, 0d3FE1257E3C182B51;
mul.f64 fd372, fd176, 0d3FEB04BBFF642E86;
sub.f64 fd373, fd371, fd372;
mul.f64 fd374, fd176, 0d3FE1257E3C182B51;
fma.rn.f64 fd375, fd159, 0d3FEB04BBFF642E86, fd374;
mul.f64 fd376, fd201, 0dBFDB3FF7C925819C;
mul.f64 fd377, fd218, 0d3FECF457DCDC158C;
sub.f64 fd378, fd376, fd377;
mul.f64 fd379, fd218, 0dBFDB3FF7C925819C;
fma.rn.f64 fd380, fd201, 0d3FECF457DCDC158C, fd379;
mul.f64 fd381, fd243, 0dBFEFBF675480D903;
mul.f64 fd382, fd260, 0d3FC00AEB5DA15BE0;
sub.f64 fd383, fd381, fd382;
mul.f64 fd384, fd260, 0dBFEFBF675480D903;
fma.rn.f64 fd385, fd243, 0d3FC00AEB5DA15BE0, fd384;
mul.f64 fd386, fd285, 0dBFE465C6FEB501BC;
mul.f64 fd387, fd302, 0dBFE8A80B635B6BEA;
sub.f64 fd388, fd386, fd387;
mul.f64 fd389, fd302, 0dBFE465C6FEB501BC;
fma.rn.f64 fd390, fd285, 0dBFE8A80B635B6BEA, fd389;
add.f64 fd391, fd146, fd272;
add.f64 fd392, fd104, fd391;
add.f64 fd393, fd188, fd230;
add.f64 fd394, fd150, fd276;
add.f64 fd395, fd108, fd394;
add.f64 fd396, fd192, fd234;
fma.rn.f64 fd397, fd391, 0d3FD3C6EF372FE950, fd104;
mul.f64 fd398, fd393, 0d3FE9E3779B97F4A8;
sub.f64 fd399, fd397, fd398;
sub.f64 fd400, fd150, fd276;
mul.f64 fd401, fd400, 0d3FEE6F0E134454FF;
sub.f64 fd402, fd192, fd234;
fma.rn.f64 fd403, fd402, 0d3FE2CF2304755A5E, fd401;
mul.f64 fd404, fd391, 0d3FE9E3779B97F4A8;
sub.f64 fd405, fd104, fd404;
fma.rn.f64 fd406, fd393, 0d3FD3C6EF372FE950, fd405;
mul.f64 fd407, fd400, 0d3FE2CF2304755A5E;
mul.f64 fd408, fd402, 0d3FEE6F0E134454FF;
sub.f64 fd409, fd407, fd408;
fma.rn.f64 fd410, fd394, 0d3FD3C6EF372FE950, fd108;
mul.f64 fd411, fd396, 0d3FE9E3779B97F4A8;
sub.f64 fd412, fd410, fd411;
sub.f64 fd413, fd146, fd272;
mul.f64 fd414, fd413, 0d3FEE6F0E134454FF;
sub.f64 fd415, fd188, fd230;
fma.rn.f64 fd416, fd415, 0d3FE2CF2304755A5E, fd414;
mul.f64 fd417, fd394, 0d3FE9E3779B97F4A8;
sub.f64 fd418, fd108, fd417;
fma.rn.f64 fd419, fd396, 0d3FD3C6EF372FE950, fd418;
mul.f64 fd420, fd413, 0d3FE2CF2304755A5E;
mul.f64 fd421, fd415, 0d3FEE6F0E134454FF;
sub.f64 fd422, fd420, fd421;
add.f64 fd423, fd313, fd328;
add.f64 fd424, fd116, fd423;
add.f64 fd425, fd318, fd323;
add.f64 fd426, fd315, fd330;
add.f64 fd427, fd133, fd426;
add.f64 fd428, fd320, fd325;
fma.rn.f64 fd429, fd423, 0d3FD3C6EF372FE950, fd116;
mul.f64 fd430, fd425, 0d3FE9E3779B97F4A8;
sub.f64 fd431, fd429, fd430;
sub.f64 fd432, fd315, fd330;
mul.f64 fd433, fd432, 0d3FEE6F0E134454FF;
sub.f64 fd434, fd320, fd325;
fma.rn.f64 fd435, fd434, 0d3FE2CF2304755A5E, fd433;
mul.f64 fd436, fd423, 0d3FE9E3779B97F4A8;
sub.f64 fd437, fd116, fd436;
fma.rn.f64 fd438, fd425, 0d3FD3C6EF372FE950, fd437;
mul.f64 fd439, fd432, 0d3FE2CF2304755A5E;
mul.f64 fd440, fd434, 0d3FEE6F0E134454FF;
sub.f64 fd441, fd439, fd440;
fma.rn.f64 fd442, fd426, 0d3FD3C6EF372FE950, fd133;
mul.f64 fd443, fd428, 0d3FE9E3779B97F4A8;
sub.f64 fd444, fd442, fd443;
sub.f64 fd445, fd313, fd328;
mul.f64 fd446, fd445, 0d3FEE6F0E134454FF;
sub.f64 fd447, fd318, fd323;
fma.rn.f64 fd448, fd447, 0d3FE2CF2304755A5E, fd446;
mul.f64 fd449, fd426, 0d3FE9E3779B97F4A8;
sub.f64 fd450, fd133, fd449;
fma.rn.f64 fd451, fd428, 0d3FD3C6EF372FE950, fd450;
mul.f64 fd452, fd445, 0d3FE2CF2304755A5E;
mul.f64 fd453, fd447, 0d3FEE6F0E134454FF;
sub.f64 fd454, fd452, fd453;
add.f64 fd455, fd333, fd348;
add.f64 fd456, fd124, fd455;
add.f64 fd457, fd338, fd343;
add.f64 fd458, fd335, fd350;
add.f64 fd459, fd141, fd458;
add.f64 fd460, fd340, fd345;
fma.rn.f64 fd461, fd455, 0d3FD3C6EF372FE950, fd124;
mul.f64 fd462, fd457, 0d3FE9E3779B97F4A8;
sub.f64 fd463, fd461, fd462;
sub.f64 fd464, fd335, fd350;
mul.f64 fd465, fd464, 0d3FEE6F0E134454FF;
sub.f64 fd466, fd340, fd345;
fma.rn.f64 fd467, fd466, 0d3FE2CF2304755A5E, fd465;
mul.f64 fd468, fd455, 0d3FE9E3779B97F4A8;
sub.f64 fd469, fd124, fd468;
fma.rn.f64 fd470, fd457, 0d3FD3C6EF372FE950, fd469;
mul.f64 fd471, fd464, 0d3FE2CF2304755A5E;
mul.f64 fd472, fd466, 0d3FEE6F0E134454FF;
sub.f64 fd473, fd471, fd472;
fma.rn.f64 fd474, fd458, 0d3FD3C6EF372FE950, fd141;
mul.f64 fd475, fd460, 0d3FE9E3779B97F4A8;
sub.f64 fd476, fd474, fd475;
sub.f64 fd477, fd333, fd348;
mul.f64 fd478, fd477, 0d3FEE6F0E134454FF;
sub.f64 fd479, fd338, fd343;
fma.rn.f64 fd480, fd479, 0d3FE2CF2304755A5E, fd478;
mul.f64 fd481, fd458, 0d3FE9E3779B97F4A8;
sub.f64 fd482, fd141, fd481;
fma.rn.f64 fd483, fd460, 0d3FD3C6EF372FE950, fd482;
mul.f64 fd484, fd477, 0d3FE2CF2304755A5E;
mul.f64 fd485, fd479, 0d3FEE6F0E134454FF;
sub.f64 fd486, fd484, fd485;
add.f64 fd487, fd353, fd368;
add.f64 fd488, fd125, fd487;
add.f64 fd489, fd358, fd363;
add.f64 fd490, fd355, fd370;
add.f64 fd491, fd142, fd490;
add.f64 fd492, fd360, fd365;
fma.rn.f64 fd493, fd487, 0d3FD3C6EF372FE950, fd125;
mul.f64 fd494, fd489, 0d3FE9E3779B97F4A8;
sub.f64 fd495, fd493, fd494;
sub.f64 fd496, fd355, fd370;
mul.f64 fd497, fd496, 0d3FEE6F0E134454FF;
sub.f64 fd498, fd360, fd365;
fma.rn.f64 fd499, fd498, 0d3FE2CF2304755A5E, fd497;
mul.f64 fd500, fd487, 0d3FE9E3779B97F4A8;
sub.f64 fd501, fd125, fd500;
fma.rn.f64 fd502, fd489, 0d3FD3C6EF372FE950, fd501;
mul.f64 fd503, fd496, 0d3FE2CF2304755A5E;
mul.f64 fd504, fd498, 0d3FEE6F0E134454FF;
sub.f64 fd505, fd503, fd504;
fma.rn.f64 fd506, fd490, 0d3FD3C6EF372FE950, fd142;
mul.f64 fd507, fd492, 0d3FE9E3779B97F4A8;
sub.f64 fd508, fd506, fd507;
sub.f64 fd509, fd353, fd368;
mul.f64 fd510, fd509, 0d3FEE6F0E134454FF;
sub.f64 fd511, fd358, fd363;
fma.rn.f64 fd512, fd511, 0d3FE2CF2304755A5E, fd510;
mul.f64 fd513, fd490, 0d3FE9E3779B97F4A8;
sub.f64 fd514, fd142, fd513;
fma.rn.f64 fd515, fd492, 0d3FD3C6EF372FE950, fd514;
mul.f64 fd516, fd509, 0d3FE2CF2304755A5E;
mul.f64 fd517, fd511, 0d3FEE6F0E134454FF;
sub.f64 fd518, fd516, fd517;
add.f64 fd519, fd373, fd388;
add.f64 fd520, fd117, fd519;
add.f64 fd521, fd378, fd383;
add.f64 fd522, fd375, fd390;
add.f64 fd523, fd134, fd522;
add.f64 fd524, fd380, fd385;
fma.rn.f64 fd525, fd519, 0d3FD3C6EF372FE950, fd117;
mul.f64 fd526, fd521, 0d3FE9E3779B97F4A8;
sub.f64 fd527, fd525, fd526;
sub.f64 fd528, fd375, fd390;
mul.f64 fd529, fd528, 0d3FEE6F0E134454FF;
sub.f64 fd530, fd380, fd385;
fma.rn.f64 fd531, fd530, 0d3FE2CF2304755A5E, fd529;
mul.f64 fd532, fd519, 0d3FE9E3779B97F4A8;
sub.f64 fd533, fd117, fd532;
fma.rn.f64 fd534, fd521, 0d3FD3C6EF372FE950, fd533;
mul.f64 fd535, fd528, 0d3FE2CF2304755A5E;
mul.f64 fd536, fd530, 0d3FEE6F0E134454FF;
sub.f64 fd537, fd535, fd536;
fma.rn.f64 fd538, fd522, 0d3FD3C6EF372FE950, fd134;
mul.f64 fd539, fd524, 0d3FE9E3779B97F4A8;
sub.f64 fd540, fd538, fd539;
sub.f64 fd541, fd373, fd388;
mul.f64 fd542, fd541, 0d3FEE6F0E134454FF;
sub.f64 fd543, fd378, fd383;
fma.rn.f64 fd544, fd543, 0d3FE2CF2304755A5E, fd542;
mul.f64 fd545, fd522, 0d3FE9E3779B97F4A8;
sub.f64 fd546, fd134, fd545;
fma.rn.f64 fd547, fd524, 0d3FD3C6EF372FE950, fd546;
mul.f64 fd548, fd541, 0d3FE2CF2304755A5E;
mul.f64 fd549, fd543, 0d3FEE6F0E134454FF;
sub.f64 fd550, fd548, fd549;
add.f64 %1, fd396, fd395;
add.f64 %0, fd393, fd392;
add.f64 %3, fd428, fd427;
add.f64 %2, fd425, fd424;
add.f64 %5, fd460, fd459;
add.f64 %4, fd457, fd456;
add.f64 %7, fd492, fd491;
add.f64 %6, fd489, fd488;
add.f64 %9, fd524, fd523;
add.f64 %8, fd521, fd520;
add.f64 %11, fd416, fd412;
sub.f64 %10, fd399, fd403;
add.f64 %13, fd448, fd444;
sub.f64 %12, fd431, fd435;
add.f64 %15, fd480, fd476;
sub.f64 %14, fd463, fd467;
add.f64 %17, fd512, fd508;
sub.f64 %16, fd495, fd499;
add.f64 %19, fd544, fd540;
sub.f64 %18, fd527, fd531;
add.f64 %21, fd422, fd419;
sub.f64 %20, fd406, fd409;
add.f64 %23, fd454, fd451;
sub.f64 %22, fd438, fd441;
add.f64 %25, fd486, fd483;
sub.f64 %24, fd470, fd473;
add.f64 %27, fd518, fd515;
sub.f64 %26, fd502, fd505;
add.f64 %29, fd550, fd547;
sub.f64 %28, fd534, fd537;
sub.f64 %31, fd419, fd422;
add.f64 %30, fd409, fd406;
sub.f64 %33, fd451, fd454;
add.f64 %32, fd441, fd438;
sub.f64 %35, fd483, fd486;
add.f64 %34, fd473, fd470;
sub.f64 %37, fd515, fd518;
add.f64 %36, fd505, fd502;
sub.f64 %39, fd547, fd550;
add.f64 %38, fd537, fd534;
sub.f64 %41, fd412, fd416;
add.f64 %40, fd403, fd399;
sub.f64 %43, fd444, fd448;
add.f64 %42, fd435, fd431;
sub.f64 %45, fd476, fd480;
add.f64 %44, fd467, fd463;
sub.f64 %47, fd508, fd512;
add.f64 %46, fd499, fd495;
sub.f64 %49, fd540, fd544;
add.f64 %48, fd531, fd527;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y), "=d"(rmem[16].x), "=d"(rmem[16].y), "=d"(rmem[17].x), "=d"(rmem[17].y), "=d"(rmem[18].x), "=d"(rmem[18].y), "=d"(rmem[19].x), "=d"(rmem[19].y), "=d"(rmem[20].x), "=d"(rmem[20].y), "=d"(rmem[21].x), "=d"(rmem[21].y), "=d"(rmem[22].x), "=d"(rmem[22].y), "=d"(rmem[23].x), "=d"(rmem[23].y), "=d"(rmem[24].x), "=d"(rmem[24].y): "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[16].x), "d"(rmem[16].y), "d"(rmem[16].y), "d"(rmem[17].x), "d"(rmem[17].y), "d"(rmem[17].y), "d"(rmem[18].x), "d"(rmem[18].y), "d"(rmem[19].x), "d"(rmem[19].y), "d"(rmem[19].y), "d"(rmem[20].x), "d"(rmem[20].y), "d"(rmem[20].y), "d"(rmem[21].x), "d"(rmem[21].y), "d"(rmem[22].x), "d"(rmem[22].y), "d"(rmem[22].y), "d"(rmem[23].x), "d"(rmem[23].y), "d"(rmem[23].y), "d"(rmem[24].x), "d"(rmem[24].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<705, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<12>;
.reg .f64 fd<163>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 400, r2;
mov.u32 r4, %tid.x;
add.f64 fd21, %14, %22;
add.f64 fd22, %12, fd21;
add.f64 fd23, %17, %20;
add.f64 fd24, %16, %23;
add.f64 fd25, %13, fd24;
add.f64 fd26, %19, %21;
fma.rn.f64 fd27, fd21, 0d3FD3C6EF372FE950, %12;
mul.f64 fd28, fd23, 0d3FE9E3779B97F4A8;
sub.f64 fd29, fd27, fd28;
sub.f64 fd30, %16, %23;
mul.f64 fd31, fd30, 0d3FEE6F0E134454FF;
sub.f64 fd32, %19, %21;
fma.rn.f64 fd33, fd32, 0d3FE2CF2304755A5E, fd31;
sub.f64 fd34, fd29, fd33;
add.f64 fd35, fd33, fd29;
mul.f64 fd36, fd21, 0d3FE9E3779B97F4A8;
sub.f64 fd37, %12, fd36;
fma.rn.f64 fd38, fd23, 0d3FD3C6EF372FE950, fd37;
mul.f64 fd39, fd30, 0d3FE2CF2304755A5E;
mul.f64 fd40, fd32, 0d3FEE6F0E134454FF;
sub.f64 fd41, fd39, fd40;
sub.f64 fd42, fd38, fd41;
add.f64 fd43, fd41, fd38;
fma.rn.f64 fd44, fd24, 0d3FD3C6EF372FE950, %13;
mul.f64 fd45, fd26, 0d3FE9E3779B97F4A8;
sub.f64 fd46, fd44, fd45;
sub.f64 fd47, %14, %22;
mul.f64 fd48, fd47, 0d3FEE6F0E134454FF;
sub.f64 fd49, %17, %20;
fma.rn.f64 fd50, fd49, 0d3FE2CF2304755A5E, fd48;
add.f64 fd51, fd50, fd46;
sub.f64 fd52, fd46, fd50;
mul.f64 fd53, fd24, 0d3FE9E3779B97F4A8;
sub.f64 fd54, %13, fd53;
fma.rn.f64 fd55, fd26, 0d3FD3C6EF372FE950, fd54;
mul.f64 fd56, fd47, 0d3FE2CF2304755A5E;
mul.f64 fd57, fd49, 0d3FEE6F0E134454FF;
sub.f64 fd58, fd56, fd57;
add.f64 fd59, fd58, fd55;
sub.f64 fd60, fd55, fd58;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 400, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd61, fd62}, [rd6];
mul.f64 fd65, fd51, fd62;
mul.f64 fd66, fd34, fd62;
mul.f64 fd67, fd61, fd51;
mul.f64 fd68, fd61, fd61;
mul.f64 fd69, fd62, fd62;
sub.f64 fd70, fd68, fd69;
mul.f64 fd71, fd62, fd61;
fma.rn.f64 fd72, fd62, fd61, fd71;
mul.f64 fd73, fd59, fd72;
mul.f64 fd74, fd42, fd72;
mul.f64 fd75, fd70, fd59;
ld.global.v2.f64 {fd76, fd77}, [rd6+80];
mul.f64 fd80, fd60, fd77;
mul.f64 fd81, fd43, fd77;
mul.f64 fd82, fd76, fd60;
mul.f64 fd83, fd61, fd76;
mul.f64 fd84, fd62, fd77;
sub.f64 fd85, fd83, fd84;
mul.f64 fd86, fd61, fd77;
fma.rn.f64 fd87, fd62, fd76, fd86;
mul.f64 fd88, fd52, fd87;
mul.f64 fd89, fd35, fd87;
mul.f64 fd90, fd85, fd52;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
add.f64 fd91, fd26, fd25;
add.f64 fd92, fd23, fd22;
st.shared.v2.f64 [r9], {fd92, fd91};
fma.rn.f64 fd93, fd61, fd34, fd65;
sub.f64 fd94, fd67, fd66;
st.shared.v2.f64 [r9+16], {fd93, fd94};
fma.rn.f64 fd95, fd70, fd42, fd73;
sub.f64 fd96, fd75, fd74;
st.shared.v2.f64 [r9+32], {fd95, fd96};
fma.rn.f64 fd97, fd76, fd43, fd80;
sub.f64 fd98, fd82, fd81;
st.shared.v2.f64 [r9+48], {fd97, fd98};
fma.rn.f64 fd99, fd85, fd35, fd88;
sub.f64 fd100, fd90, fd89;
st.shared.v2.f64 [r9+64], {fd99, fd100};
barrier.sync 0;
shl.b32 r10, r7, 6;
sub.s32 r11, r9, r10;
ld.shared.v2.f64 {fd101, fd102}, [r11];
ld.shared.v2.f64 {fd105, fd106}, [r11+80];
ld.shared.v2.f64 {fd109, fd110}, [r11+160];
ld.shared.v2.f64 {fd113, fd114}, [r11+240];
ld.shared.v2.f64 {fd117, fd118}, [r11+320];
add.f64 fd121, fd105, fd117;
add.f64 fd122, fd101, fd121;
add.f64 fd123, fd109, fd113;
add.f64 fd124, fd106, fd118;
add.f64 fd125, fd102, fd124;
add.f64 fd126, fd110, fd114;
fma.rn.f64 fd127, fd121, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd128, fd123, 0d3FE9E3779B97F4A8;
sub.f64 fd129, fd127, fd128;
sub.f64 fd130, fd106, fd118;
mul.f64 fd131, fd130, 0d3FEE6F0E134454FF;
sub.f64 fd132, fd110, fd114;
fma.rn.f64 fd133, fd132, 0d3FE2CF2304755A5E, fd131;
mul.f64 fd134, fd121, 0d3FE9E3779B97F4A8;
sub.f64 fd135, fd101, fd134;
fma.rn.f64 fd136, fd123, 0d3FD3C6EF372FE950, fd135;
mul.f64 fd137, fd130, 0d3FE2CF2304755A5E;
mul.f64 fd138, fd132, 0d3FEE6F0E134454FF;
sub.f64 fd139, fd137, fd138;
fma.rn.f64 fd140, fd124, 0d3FD3C6EF372FE950, fd102;
mul.f64 fd141, fd126, 0d3FE9E3779B97F4A8;
sub.f64 fd142, fd140, fd141;
sub.f64 fd143, fd105, fd117;
mul.f64 fd144, fd143, 0d3FEE6F0E134454FF;
sub.f64 fd145, fd109, fd113;
fma.rn.f64 fd146, fd145, 0d3FE2CF2304755A5E, fd144;
mul.f64 fd147, fd124, 0d3FE9E3779B97F4A8;
sub.f64 fd148, fd102, fd147;
fma.rn.f64 fd149, fd126, 0d3FD3C6EF372FE950, fd148;
mul.f64 fd150, fd143, 0d3FE2CF2304755A5E;
mul.f64 fd151, fd145, 0d3FEE6F0E134454FF;
sub.f64 fd152, fd150, fd151;
add.f64 %1, fd126, fd125;
add.f64 %0, fd123, fd122;
add.f64 %3, fd146, fd142;
sub.f64 %2, fd129, fd133;
add.f64 %5, fd152, fd149;
sub.f64 %4, fd136, fd139;
sub.f64 %7, fd149, fd152;
add.f64 %6, fd139, fd136;
sub.f64 %9, fd142, fd146;
add.f64 %8, fd133, fd129;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y): "r"(smem), "l"(lut_dp_5_25), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<706, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<12>;
.reg .f64 fd<153>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 200, r2;
mov.u32 r4, %tid.x;
add.f64 fd21, %14, %22;
add.f64 fd22, %12, fd21;
add.f64 fd23, %17, %20;
add.f64 fd24, fd23, fd22;
add.f64 fd25, %16, %23;
add.f64 fd26, %13, fd25;
add.f64 fd27, %19, %21;
add.f64 fd28, fd27, fd26;
fma.rn.f64 fd29, fd21, 0d3FD3C6EF372FE950, %12;
mul.f64 fd30, fd23, 0d3FE9E3779B97F4A8;
sub.f64 fd31, fd29, fd30;
sub.f64 fd32, %16, %23;
mul.f64 fd33, fd32, 0d3FEE6F0E134454FF;
sub.f64 fd34, %19, %21;
fma.rn.f64 fd35, fd34, 0d3FE2CF2304755A5E, fd33;
sub.f64 fd36, fd31, fd35;
add.f64 fd37, fd35, fd31;
mul.f64 fd38, fd21, 0d3FE9E3779B97F4A8;
sub.f64 fd39, %12, fd38;
fma.rn.f64 fd40, fd23, 0d3FD3C6EF372FE950, fd39;
mul.f64 fd41, fd32, 0d3FE2CF2304755A5E;
mul.f64 fd42, fd34, 0d3FEE6F0E134454FF;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, fd40, fd43;
add.f64 fd45, fd43, fd40;
fma.rn.f64 fd46, fd25, 0d3FD3C6EF372FE950, %13;
mul.f64 fd47, fd27, 0d3FE9E3779B97F4A8;
sub.f64 fd48, fd46, fd47;
sub.f64 fd49, %14, %22;
mul.f64 fd50, fd49, 0d3FEE6F0E134454FF;
sub.f64 fd51, %17, %20;
fma.rn.f64 fd52, fd51, 0d3FE2CF2304755A5E, fd50;
add.f64 fd53, fd52, fd48;
sub.f64 fd54, fd48, fd52;
mul.f64 fd55, fd25, 0d3FE9E3779B97F4A8;
sub.f64 fd56, %13, fd55;
fma.rn.f64 fd57, fd27, 0d3FD3C6EF372FE950, fd56;
mul.f64 fd58, fd49, 0d3FE2CF2304755A5E;
mul.f64 fd59, fd51, 0d3FEE6F0E134454FF;
sub.f64 fd60, fd58, fd59;
add.f64 fd61, fd60, fd57;
sub.f64 fd62, fd57, fd60;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd63, fd64}, [rd6];
mul.f64 fd67, fd53, fd64;
fma.rn.f64 fd68, fd63, fd36, fd67;
mul.f64 fd69, fd36, fd64;
mul.f64 fd70, fd63, fd53;
sub.f64 fd71, fd70, fd69;
mul.f64 fd72, fd63, fd63;
mul.f64 fd73, fd64, fd64;
sub.f64 fd74, fd72, fd73;
mul.f64 fd75, fd64, fd63;
fma.rn.f64 fd76, fd64, fd63, fd75;
mul.f64 fd77, fd61, fd76;
fma.rn.f64 fd78, fd74, fd44, fd77;
mul.f64 fd79, fd44, fd76;
mul.f64 fd80, fd74, fd61;
sub.f64 fd81, fd80, fd79;
ld.global.v2.f64 {fd82, fd83}, [rd6+80];
mul.f64 fd86, fd62, fd83;
fma.rn.f64 fd87, fd82, fd45, fd86;
mul.f64 fd88, fd45, fd83;
mul.f64 fd89, fd82, fd62;
sub.f64 fd90, fd89, fd88;
mul.f64 fd91, fd63, fd82;
mul.f64 fd92, fd64, fd83;
sub.f64 fd93, fd91, fd92;
mul.f64 fd94, fd63, fd83;
fma.rn.f64 fd95, fd64, fd82, fd94;
mul.f64 fd96, fd54, fd95;
fma.rn.f64 fd97, fd93, fd37, fd96;
mul.f64 fd98, fd37, fd95;
mul.f64 fd99, fd93, fd54;
sub.f64 fd100, fd99, fd98;
mad.lo.s32 r8, r5, 200, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
st.shared.f64 [r9], fd24;
st.shared.f64 [r9+8], fd68;
st.shared.f64 [r9+16], fd78;
st.shared.f64 [r9+24], fd87;
st.shared.f64 [r9+32], fd97;
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.f64 fd101, [r11];
ld.shared.f64 fd102, [r11+40];
ld.shared.f64 fd103, [r11+80];
ld.shared.f64 fd104, [r11+120];
ld.shared.f64 fd105, [r11+160];
barrier.sync 0;
st.shared.f64 [r9], fd28;
st.shared.f64 [r9+8], fd71;
st.shared.f64 [r9+16], fd81;
st.shared.f64 [r9+24], fd90;
st.shared.f64 [r9+32], fd100;
barrier.sync 0;
ld.shared.f64 fd106, [r11];
ld.shared.f64 fd107, [r11+40];
ld.shared.f64 fd108, [r11+80];
ld.shared.f64 fd109, [r11+120];
ld.shared.f64 fd110, [r11+160];
add.f64 fd111, fd102, fd105;
add.f64 fd112, fd101, fd111;
add.f64 fd113, fd103, fd104;
add.f64 fd114, fd107, fd110;
add.f64 fd115, fd106, fd114;
add.f64 fd116, fd108, fd109;
fma.rn.f64 fd117, fd111, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd118, fd113, 0d3FE9E3779B97F4A8;
sub.f64 fd119, fd117, fd118;
sub.f64 fd120, fd107, fd110;
mul.f64 fd121, fd120, 0d3FEE6F0E134454FF;
sub.f64 fd122, fd108, fd109;
fma.rn.f64 fd123, fd122, 0d3FE2CF2304755A5E, fd121;
mul.f64 fd124, fd111, 0d3FE9E3779B97F4A8;
sub.f64 fd125, fd101, fd124;
fma.rn.f64 fd126, fd113, 0d3FD3C6EF372FE950, fd125;
mul.f64 fd127, fd120, 0d3FE2CF2304755A5E;
mul.f64 fd128, fd122, 0d3FEE6F0E134454FF;
sub.f64 fd129, fd127, fd128;
fma.rn.f64 fd130, fd114, 0d3FD3C6EF372FE950, fd106;
mul.f64 fd131, fd116, 0d3FE9E3779B97F4A8;
sub.f64 fd132, fd130, fd131;
sub.f64 fd133, fd102, fd105;
mul.f64 fd134, fd133, 0d3FEE6F0E134454FF;
sub.f64 fd135, fd103, fd104;
fma.rn.f64 fd136, fd135, 0d3FE2CF2304755A5E, fd134;
mul.f64 fd137, fd114, 0d3FE9E3779B97F4A8;
sub.f64 fd138, fd106, fd137;
fma.rn.f64 fd139, fd116, 0d3FD3C6EF372FE950, fd138;
mul.f64 fd140, fd133, 0d3FE2CF2304755A5E;
mul.f64 fd141, fd135, 0d3FEE6F0E134454FF;
sub.f64 fd142, fd140, fd141;
add.f64 %0, fd113, fd112;
add.f64 %1, fd116, fd115;
add.f64 %3, fd136, fd132;
sub.f64 %2, fd119, fd123;
sub.f64 %4, fd126, fd129;
add.f64 %5, fd142, fd139;
add.f64 %6, fd129, fd126;
sub.f64 %7, fd139, fd142;
sub.f64 %9, fd132, fd136;
add.f64 %8, fd123, fd119;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y): "r"(smem), "l"(lut_dp_5_25), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y));
};


#endif
