#ifndef CUFFTDX_FFT_3125_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_3125_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<716, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<30>;
.reg .f64 fd<423>;
.reg .b64 rd<22>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 25000, r2;
mov.u32 r4, %tid.x;
add.f64 fd21, %17, %25;
add.f64 fd22, %15, fd21;
add.f64 fd23, %20, %23;
add.f64 fd24, fd23, fd22;
add.f64 fd25, %19, %26;
add.f64 fd26, %16, fd25;
add.f64 fd27, %22, %24;
add.f64 fd28, fd27, fd26;
fma.rn.f64 fd29, fd21, 0d3FD3C6EF372FE950, %15;
mul.f64 fd30, fd23, 0d3FE9E3779B97F4A8;
sub.f64 fd31, fd29, fd30;
sub.f64 fd32, %19, %26;
mul.f64 fd33, fd32, 0d3FEE6F0E134454FF;
sub.f64 fd34, %22, %24;
fma.rn.f64 fd35, fd34, 0d3FE2CF2304755A5E, fd33;
sub.f64 fd36, fd31, fd35;
add.f64 fd37, fd35, fd31;
mul.f64 fd38, fd21, 0d3FE9E3779B97F4A8;
sub.f64 fd39, %15, fd38;
fma.rn.f64 fd40, fd23, 0d3FD3C6EF372FE950, fd39;
mul.f64 fd41, fd32, 0d3FE2CF2304755A5E;
mul.f64 fd42, fd34, 0d3FEE6F0E134454FF;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, fd40, fd43;
add.f64 fd45, fd43, fd40;
fma.rn.f64 fd46, fd25, 0d3FD3C6EF372FE950, %16;
mul.f64 fd47, fd27, 0d3FE9E3779B97F4A8;
sub.f64 fd48, fd46, fd47;
sub.f64 fd49, %17, %25;
mul.f64 fd50, fd49, 0d3FEE6F0E134454FF;
sub.f64 fd51, %20, %23;
fma.rn.f64 fd52, fd51, 0d3FE2CF2304755A5E, fd50;
add.f64 fd53, fd52, fd48;
sub.f64 fd54, fd48, fd52;
mul.f64 fd55, fd25, 0d3FE9E3779B97F4A8;
sub.f64 fd56, %16, fd55;
fma.rn.f64 fd57, fd27, 0d3FD3C6EF372FE950, fd56;
mul.f64 fd58, fd49, 0d3FE2CF2304755A5E;
mul.f64 fd59, fd51, 0d3FEE6F0E134454FF;
sub.f64 fd60, fd58, fd59;
add.f64 fd61, fd60, fd57;
sub.f64 fd62, fd57, fd60;
mul.wide.u32 rd2, r4, -776530087;
shr.u64 rd3, rd2, 41;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 625;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd63, fd64}, [rd6];
mul.f64 fd67, fd53, fd64;
fma.rn.f64 fd68, fd63, fd36, fd67;
mul.f64 fd69, fd36, fd64;
mul.f64 fd70, fd63, fd53;
sub.f64 fd71, fd70, fd69;
mul.f64 fd72, fd63, fd63;
mul.f64 fd73, fd64, fd64;
sub.f64 fd74, fd72, fd73;
mul.f64 fd75, fd64, fd63;
fma.rn.f64 fd76, fd64, fd63, fd75;
mul.f64 fd77, fd61, fd76;
fma.rn.f64 fd78, fd74, fd44, fd77;
mul.f64 fd79, fd44, fd76;
mul.f64 fd80, fd74, fd61;
sub.f64 fd81, fd80, fd79;
ld.global.v2.f64 {fd82, fd83}, [rd6+10000];
mul.f64 fd86, fd62, fd83;
fma.rn.f64 fd87, fd82, fd45, fd86;
mul.f64 fd88, fd45, fd83;
mul.f64 fd89, fd82, fd62;
sub.f64 fd90, fd89, fd88;
mul.f64 fd91, fd63, fd82;
mul.f64 fd92, fd64, fd83;
sub.f64 fd93, fd91, fd92;
mul.f64 fd94, fd63, fd83;
fma.rn.f64 fd95, fd64, fd82, fd94;
mul.f64 fd96, fd54, fd95;
fma.rn.f64 fd97, fd93, fd37, fd96;
mul.f64 fd98, fd37, fd95;
mul.f64 fd99, fd93, fd54;
sub.f64 fd100, fd99, fd98;
mad.lo.s32 r8, r5, 25000, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
st.shared.f64 [r9], fd24;
st.shared.f64 [r9+8], fd68;
st.shared.f64 [r9+16], fd78;
st.shared.f64 [r9+24], fd87;
st.shared.f64 [r9+32], fd97;
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.f64 fd101, [r11];
ld.shared.f64 fd102, [r11+5000];
ld.shared.f64 fd103, [r11+10000];
ld.shared.f64 fd104, [r11+15000];
ld.shared.f64 fd105, [r11+20000];
barrier.sync 0;
st.shared.f64 [r9], fd28;
st.shared.f64 [r9+8], fd71;
st.shared.f64 [r9+16], fd81;
st.shared.f64 [r9+24], fd90;
st.shared.f64 [r9+32], fd100;
barrier.sync 0;
ld.shared.f64 fd106, [r11];
ld.shared.f64 fd107, [r11+5000];
ld.shared.f64 fd108, [r11+10000];
ld.shared.f64 fd109, [r11+15000];
ld.shared.f64 fd110, [r11+20000];
add.f64 fd111, fd102, fd105;
add.f64 fd112, fd101, fd111;
add.f64 fd113, fd103, fd104;
add.f64 fd114, fd113, fd112;
add.f64 fd115, fd107, fd110;
add.f64 fd116, fd106, fd115;
add.f64 fd117, fd108, fd109;
add.f64 fd118, fd117, fd116;
fma.rn.f64 fd119, fd111, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd120, fd113, 0d3FE9E3779B97F4A8;
sub.f64 fd121, fd119, fd120;
sub.f64 fd122, fd107, fd110;
mul.f64 fd123, fd122, 0d3FEE6F0E134454FF;
sub.f64 fd124, fd108, fd109;
fma.rn.f64 fd125, fd124, 0d3FE2CF2304755A5E, fd123;
sub.f64 fd126, fd121, fd125;
add.f64 fd127, fd125, fd121;
mul.f64 fd128, fd111, 0d3FE9E3779B97F4A8;
sub.f64 fd129, fd101, fd128;
fma.rn.f64 fd130, fd113, 0d3FD3C6EF372FE950, fd129;
mul.f64 fd131, fd122, 0d3FE2CF2304755A5E;
mul.f64 fd132, fd124, 0d3FEE6F0E134454FF;
sub.f64 fd133, fd131, fd132;
sub.f64 fd134, fd130, fd133;
add.f64 fd135, fd133, fd130;
fma.rn.f64 fd136, fd115, 0d3FD3C6EF372FE950, fd106;
mul.f64 fd137, fd117, 0d3FE9E3779B97F4A8;
sub.f64 fd138, fd136, fd137;
sub.f64 fd139, fd102, fd105;
mul.f64 fd140, fd139, 0d3FEE6F0E134454FF;
sub.f64 fd141, fd103, fd104;
fma.rn.f64 fd142, fd141, 0d3FE2CF2304755A5E, fd140;
add.f64 fd143, fd142, fd138;
sub.f64 fd144, fd138, fd142;
mul.f64 fd145, fd115, 0d3FE9E3779B97F4A8;
sub.f64 fd146, fd106, fd145;
fma.rn.f64 fd147, fd117, 0d3FD3C6EF372FE950, fd146;
mul.f64 fd148, fd139, 0d3FE2CF2304755A5E;
mul.f64 fd149, fd141, 0d3FEE6F0E134454FF;
sub.f64 fd150, fd148, fd149;
add.f64 fd151, fd150, fd147;
sub.f64 fd152, fd147, fd150;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd153, fd154}, [rd11];
mul.f64 fd157, fd143, fd154;
fma.rn.f64 fd158, fd153, fd126, fd157;
mul.f64 fd159, fd126, fd154;
mul.f64 fd160, fd153, fd143;
sub.f64 fd161, fd160, fd159;
mul.f64 fd162, fd153, fd153;
mul.f64 fd163, fd154, fd154;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, fd153;
fma.rn.f64 fd166, fd154, fd153, fd165;
mul.f64 fd167, fd151, fd166;
fma.rn.f64 fd168, fd164, fd134, fd167;
mul.f64 fd169, fd134, fd166;
mul.f64 fd170, fd164, fd151;
sub.f64 fd171, fd170, fd169;
ld.global.v2.f64 {fd172, fd173}, [rd11+2000];
mul.f64 fd176, fd152, fd173;
fma.rn.f64 fd177, fd172, fd135, fd176;
mul.f64 fd178, fd135, fd173;
mul.f64 fd179, fd172, fd152;
sub.f64 fd180, fd179, fd178;
mul.f64 fd181, fd153, fd172;
mul.f64 fd182, fd154, fd173;
sub.f64 fd183, fd181, fd182;
mul.f64 fd184, fd153, fd173;
fma.rn.f64 fd185, fd154, fd172, fd184;
mul.f64 fd186, fd144, fd185;
fma.rn.f64 fd187, fd183, fd127, fd186;
mul.f64 fd188, fd127, fd185;
mul.f64 fd189, fd183, fd144;
sub.f64 fd190, fd189, fd188;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 200, r16;
st.shared.f64 [r17], fd114;
st.shared.f64 [r17+40], fd158;
st.shared.f64 [r17+80], fd168;
st.shared.f64 [r17+120], fd177;
st.shared.f64 [r17+160], fd187;
barrier.sync 0;
ld.shared.f64 fd191, [r11];
ld.shared.f64 fd192, [r11+5000];
ld.shared.f64 fd193, [r11+10000];
ld.shared.f64 fd194, [r11+15000];
ld.shared.f64 fd195, [r11+20000];
barrier.sync 0;
st.shared.f64 [r17], fd118;
st.shared.f64 [r17+40], fd161;
st.shared.f64 [r17+80], fd171;
st.shared.f64 [r17+120], fd180;
st.shared.f64 [r17+160], fd190;
barrier.sync 0;
ld.shared.f64 fd196, [r11];
ld.shared.f64 fd197, [r11+5000];
ld.shared.f64 fd198, [r11+10000];
ld.shared.f64 fd199, [r11+15000];
ld.shared.f64 fd200, [r11+20000];
add.f64 fd201, fd192, fd195;
add.f64 fd202, fd191, fd201;
add.f64 fd203, fd193, fd194;
add.f64 fd204, fd203, fd202;
add.f64 fd205, fd197, fd200;
add.f64 fd206, fd196, fd205;
add.f64 fd207, fd198, fd199;
add.f64 fd208, fd207, fd206;
fma.rn.f64 fd209, fd201, 0d3FD3C6EF372FE950, fd191;
mul.f64 fd210, fd203, 0d3FE9E3779B97F4A8;
sub.f64 fd211, fd209, fd210;
sub.f64 fd212, fd197, fd200;
mul.f64 fd213, fd212, 0d3FEE6F0E134454FF;
sub.f64 fd214, fd198, fd199;
fma.rn.f64 fd215, fd214, 0d3FE2CF2304755A5E, fd213;
sub.f64 fd216, fd211, fd215;
add.f64 fd217, fd215, fd211;
mul.f64 fd218, fd201, 0d3FE9E3779B97F4A8;
sub.f64 fd219, fd191, fd218;
fma.rn.f64 fd220, fd203, 0d3FD3C6EF372FE950, fd219;
mul.f64 fd221, fd212, 0d3FE2CF2304755A5E;
mul.f64 fd222, fd214, 0d3FEE6F0E134454FF;
sub.f64 fd223, fd221, fd222;
sub.f64 fd224, fd220, fd223;
add.f64 fd225, fd223, fd220;
fma.rn.f64 fd226, fd205, 0d3FD3C6EF372FE950, fd196;
mul.f64 fd227, fd207, 0d3FE9E3779B97F4A8;
sub.f64 fd228, fd226, fd227;
sub.f64 fd229, fd192, fd195;
mul.f64 fd230, fd229, 0d3FEE6F0E134454FF;
sub.f64 fd231, fd193, fd194;
fma.rn.f64 fd232, fd231, 0d3FE2CF2304755A5E, fd230;
add.f64 fd233, fd232, fd228;
sub.f64 fd234, fd228, fd232;
mul.f64 fd235, fd205, 0d3FE9E3779B97F4A8;
sub.f64 fd236, fd196, fd235;
fma.rn.f64 fd237, fd207, 0d3FD3C6EF372FE950, fd236;
mul.f64 fd238, fd229, 0d3FE2CF2304755A5E;
mul.f64 fd239, fd231, 0d3FEE6F0E134454FF;
sub.f64 fd240, fd238, fd239;
add.f64 fd241, fd240, fd237;
sub.f64 fd242, fd237, fd240;
mul.wide.u32 rd12, r7, 1374389535;
shr.u64 rd13, rd12, 35;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 25;
sub.s32 r20, r7, r19;
mul.wide.u32 rd14, r18, 16;
mov.u64 rd15, %13;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd243, fd244}, [rd16];
mul.f64 fd247, fd233, fd244;
fma.rn.f64 fd248, fd243, fd216, fd247;
mul.f64 fd249, fd216, fd244;
mul.f64 fd250, fd243, fd233;
sub.f64 fd251, fd250, fd249;
mul.f64 fd252, fd243, fd243;
mul.f64 fd253, fd244, fd244;
sub.f64 fd254, fd252, fd253;
mul.f64 fd255, fd244, fd243;
fma.rn.f64 fd256, fd244, fd243, fd255;
mul.f64 fd257, fd241, fd256;
fma.rn.f64 fd258, fd254, fd224, fd257;
mul.f64 fd259, fd224, fd256;
mul.f64 fd260, fd254, fd241;
sub.f64 fd261, fd260, fd259;
ld.global.v2.f64 {fd262, fd263}, [rd16+400];
mul.f64 fd266, fd242, fd263;
fma.rn.f64 fd267, fd262, fd225, fd266;
mul.f64 fd268, fd225, fd263;
mul.f64 fd269, fd262, fd242;
sub.f64 fd270, fd269, fd268;
mul.f64 fd271, fd243, fd262;
mul.f64 fd272, fd244, fd263;
sub.f64 fd273, fd271, fd272;
mul.f64 fd274, fd243, fd263;
fma.rn.f64 fd275, fd244, fd262, fd274;
mul.f64 fd276, fd234, fd275;
fma.rn.f64 fd277, fd273, fd217, fd276;
mul.f64 fd278, fd217, fd275;
mul.f64 fd279, fd273, fd234;
sub.f64 fd280, fd279, fd278;
shl.b32 r21, r20, 3;
add.s32 r22, r8, r21;
barrier.sync 0;
mad.lo.s32 r23, r18, 1000, r22;
st.shared.f64 [r23], fd204;
st.shared.f64 [r23+200], fd248;
st.shared.f64 [r23+400], fd258;
st.shared.f64 [r23+600], fd267;
st.shared.f64 [r23+800], fd277;
barrier.sync 0;
ld.shared.f64 fd281, [r11];
ld.shared.f64 fd282, [r11+5000];
ld.shared.f64 fd283, [r11+10000];
ld.shared.f64 fd284, [r11+15000];
ld.shared.f64 fd285, [r11+20000];
barrier.sync 0;
st.shared.f64 [r23], fd208;
st.shared.f64 [r23+200], fd251;
st.shared.f64 [r23+400], fd261;
st.shared.f64 [r23+600], fd270;
st.shared.f64 [r23+800], fd280;
barrier.sync 0;
ld.shared.f64 fd286, [r11];
ld.shared.f64 fd287, [r11+5000];
ld.shared.f64 fd288, [r11+10000];
ld.shared.f64 fd289, [r11+15000];
ld.shared.f64 fd290, [r11+20000];
add.f64 fd291, fd282, fd285;
add.f64 fd292, fd281, fd291;
add.f64 fd293, fd283, fd284;
add.f64 fd294, fd293, fd292;
add.f64 fd295, fd287, fd290;
add.f64 fd296, fd286, fd295;
add.f64 fd297, fd288, fd289;
add.f64 fd298, fd297, fd296;
fma.rn.f64 fd299, fd291, 0d3FD3C6EF372FE950, fd281;
mul.f64 fd300, fd293, 0d3FE9E3779B97F4A8;
sub.f64 fd301, fd299, fd300;
sub.f64 fd302, fd287, fd290;
mul.f64 fd303, fd302, 0d3FEE6F0E134454FF;
sub.f64 fd304, fd288, fd289;
fma.rn.f64 fd305, fd304, 0d3FE2CF2304755A5E, fd303;
sub.f64 fd306, fd301, fd305;
add.f64 fd307, fd305, fd301;
mul.f64 fd308, fd291, 0d3FE9E3779B97F4A8;
sub.f64 fd309, fd281, fd308;
fma.rn.f64 fd310, fd293, 0d3FD3C6EF372FE950, fd309;
mul.f64 fd311, fd302, 0d3FE2CF2304755A5E;
mul.f64 fd312, fd304, 0d3FEE6F0E134454FF;
sub.f64 fd313, fd311, fd312;
sub.f64 fd314, fd310, fd313;
add.f64 fd315, fd313, fd310;
fma.rn.f64 fd316, fd295, 0d3FD3C6EF372FE950, fd286;
mul.f64 fd317, fd297, 0d3FE9E3779B97F4A8;
sub.f64 fd318, fd316, fd317;
sub.f64 fd319, fd282, fd285;
mul.f64 fd320, fd319, 0d3FEE6F0E134454FF;
sub.f64 fd321, fd283, fd284;
fma.rn.f64 fd322, fd321, 0d3FE2CF2304755A5E, fd320;
add.f64 fd323, fd322, fd318;
sub.f64 fd324, fd318, fd322;
mul.f64 fd325, fd295, 0d3FE9E3779B97F4A8;
sub.f64 fd326, fd286, fd325;
fma.rn.f64 fd327, fd297, 0d3FD3C6EF372FE950, fd326;
mul.f64 fd328, fd319, 0d3FE2CF2304755A5E;
mul.f64 fd329, fd321, 0d3FEE6F0E134454FF;
sub.f64 fd330, fd328, fd329;
add.f64 fd331, fd330, fd327;
sub.f64 fd332, fd327, fd330;
mul.wide.u32 rd17, r7, 274877907;
shr.u64 rd18, rd17, 35;
cvt.u32.u64 r24, rd18;
mul.lo.s32 r25, r24, 125;
sub.s32 r26, r7, r25;
mul.wide.u32 rd19, r24, 16;
mov.u64 rd20, %14;
add.s64 rd21, rd20, rd19;
ld.global.v2.f64 {fd333, fd334}, [rd21];
mul.f64 fd337, fd323, fd334;
fma.rn.f64 fd338, fd333, fd306, fd337;
mul.f64 fd339, fd306, fd334;
mul.f64 fd340, fd333, fd323;
sub.f64 fd341, fd340, fd339;
mul.f64 fd342, fd333, fd333;
mul.f64 fd343, fd334, fd334;
sub.f64 fd344, fd342, fd343;
mul.f64 fd345, fd334, fd333;
fma.rn.f64 fd346, fd334, fd333, fd345;
mul.f64 fd347, fd331, fd346;
fma.rn.f64 fd348, fd344, fd314, fd347;
mul.f64 fd349, fd314, fd346;
mul.f64 fd350, fd344, fd331;
sub.f64 fd351, fd350, fd349;
ld.global.v2.f64 {fd352, fd353}, [rd21+80];
mul.f64 fd356, fd332, fd353;
fma.rn.f64 fd357, fd352, fd315, fd356;
mul.f64 fd358, fd315, fd353;
mul.f64 fd359, fd352, fd332;
sub.f64 fd360, fd359, fd358;
mul.f64 fd361, fd333, fd352;
mul.f64 fd362, fd334, fd353;
sub.f64 fd363, fd361, fd362;
mul.f64 fd364, fd333, fd353;
fma.rn.f64 fd365, fd334, fd352, fd364;
mul.f64 fd366, fd324, fd365;
fma.rn.f64 fd367, fd363, fd307, fd366;
mul.f64 fd368, fd307, fd365;
mul.f64 fd369, fd363, fd324;
sub.f64 fd370, fd369, fd368;
shl.b32 r27, r26, 3;
add.s32 r28, r8, r27;
barrier.sync 0;
mad.lo.s32 r29, r24, 5000, r28;
st.shared.f64 [r29], fd294;
st.shared.f64 [r29+1000], fd338;
st.shared.f64 [r29+2000], fd348;
st.shared.f64 [r29+3000], fd357;
st.shared.f64 [r29+4000], fd367;
barrier.sync 0;
ld.shared.f64 fd371, [r11];
ld.shared.f64 fd372, [r11+5000];
ld.shared.f64 fd373, [r11+10000];
ld.shared.f64 fd374, [r11+15000];
ld.shared.f64 fd375, [r11+20000];
barrier.sync 0;
st.shared.f64 [r29], fd298;
st.shared.f64 [r29+1000], fd341;
st.shared.f64 [r29+2000], fd351;
st.shared.f64 [r29+3000], fd360;
st.shared.f64 [r29+4000], fd370;
barrier.sync 0;
ld.shared.f64 fd376, [r11];
ld.shared.f64 fd377, [r11+5000];
ld.shared.f64 fd378, [r11+10000];
ld.shared.f64 fd379, [r11+15000];
ld.shared.f64 fd380, [r11+20000];
add.f64 fd381, fd372, fd375;
add.f64 fd382, fd371, fd381;
add.f64 fd383, fd373, fd374;
add.f64 fd384, fd377, fd380;
add.f64 fd385, fd376, fd384;
add.f64 fd386, fd378, fd379;
fma.rn.f64 fd387, fd381, 0d3FD3C6EF372FE950, fd371;
mul.f64 fd388, fd383, 0d3FE9E3779B97F4A8;
sub.f64 fd389, fd387, fd388;
sub.f64 fd390, fd377, fd380;
mul.f64 fd391, fd390, 0d3FEE6F0E134454FF;
sub.f64 fd392, fd378, fd379;
fma.rn.f64 fd393, fd392, 0d3FE2CF2304755A5E, fd391;
mul.f64 fd394, fd381, 0d3FE9E3779B97F4A8;
sub.f64 fd395, fd371, fd394;
fma.rn.f64 fd396, fd383, 0d3FD3C6EF372FE950, fd395;
mul.f64 fd397, fd390, 0d3FE2CF2304755A5E;
mul.f64 fd398, fd392, 0d3FEE6F0E134454FF;
sub.f64 fd399, fd397, fd398;
fma.rn.f64 fd400, fd384, 0d3FD3C6EF372FE950, fd376;
mul.f64 fd401, fd386, 0d3FE9E3779B97F4A8;
sub.f64 fd402, fd400, fd401;
sub.f64 fd403, fd372, fd375;
mul.f64 fd404, fd403, 0d3FEE6F0E134454FF;
sub.f64 fd405, fd373, fd374;
fma.rn.f64 fd406, fd405, 0d3FE2CF2304755A5E, fd404;
mul.f64 fd407, fd384, 0d3FE9E3779B97F4A8;
sub.f64 fd408, fd376, fd407;
fma.rn.f64 fd409, fd386, 0d3FD3C6EF372FE950, fd408;
mul.f64 fd410, fd403, 0d3FE2CF2304755A5E;
mul.f64 fd411, fd405, 0d3FEE6F0E134454FF;
sub.f64 fd412, fd410, fd411;
add.f64 %0, fd383, fd382;
add.f64 %1, fd386, fd385;
add.f64 %3, fd406, fd402;
sub.f64 %2, fd389, fd393;
sub.f64 %4, fd396, fd399;
add.f64 %5, fd412, fd409;
add.f64 %6, fd399, fd396;
sub.f64 %7, fd409, fd412;
sub.f64 %9, fd402, fd406;
add.f64 %8, fd393, fd389;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y): "r"(smem), "l"(lut_dp_5_3125), "l"(lut_dp_5_625), "l"(lut_dp_5_125), "l"(lut_dp_5_25), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<715, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<30>;
.reg .f64 fd<463>;
.reg .b64 rd<22>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 50000, r2;
mov.u32 r4, %tid.x;
add.f64 fd21, %17, %25;
add.f64 fd22, %15, fd21;
add.f64 fd23, %20, %23;
add.f64 fd24, %19, %26;
add.f64 fd25, %16, fd24;
add.f64 fd26, %22, %24;
fma.rn.f64 fd27, fd21, 0d3FD3C6EF372FE950, %15;
mul.f64 fd28, fd23, 0d3FE9E3779B97F4A8;
sub.f64 fd29, fd27, fd28;
sub.f64 fd30, %19, %26;
mul.f64 fd31, fd30, 0d3FEE6F0E134454FF;
sub.f64 fd32, %22, %24;
fma.rn.f64 fd33, fd32, 0d3FE2CF2304755A5E, fd31;
sub.f64 fd34, fd29, fd33;
add.f64 fd35, fd33, fd29;
mul.f64 fd36, fd21, 0d3FE9E3779B97F4A8;
sub.f64 fd37, %15, fd36;
fma.rn.f64 fd38, fd23, 0d3FD3C6EF372FE950, fd37;
mul.f64 fd39, fd30, 0d3FE2CF2304755A5E;
mul.f64 fd40, fd32, 0d3FEE6F0E134454FF;
sub.f64 fd41, fd39, fd40;
sub.f64 fd42, fd38, fd41;
add.f64 fd43, fd41, fd38;
fma.rn.f64 fd44, fd24, 0d3FD3C6EF372FE950, %16;
mul.f64 fd45, fd26, 0d3FE9E3779B97F4A8;
sub.f64 fd46, fd44, fd45;
sub.f64 fd47, %17, %25;
mul.f64 fd48, fd47, 0d3FEE6F0E134454FF;
sub.f64 fd49, %20, %23;
fma.rn.f64 fd50, fd49, 0d3FE2CF2304755A5E, fd48;
add.f64 fd51, fd50, fd46;
sub.f64 fd52, fd46, fd50;
mul.f64 fd53, fd24, 0d3FE9E3779B97F4A8;
sub.f64 fd54, %16, fd53;
fma.rn.f64 fd55, fd26, 0d3FD3C6EF372FE950, fd54;
mul.f64 fd56, fd47, 0d3FE2CF2304755A5E;
mul.f64 fd57, fd49, 0d3FEE6F0E134454FF;
sub.f64 fd58, fd56, fd57;
add.f64 fd59, fd58, fd55;
sub.f64 fd60, fd55, fd58;
mul.wide.u32 rd2, r4, -776530087;
shr.u64 rd3, rd2, 41;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 625;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 50000, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd61, fd62}, [rd6];
mul.f64 fd65, fd51, fd62;
mul.f64 fd66, fd34, fd62;
mul.f64 fd67, fd61, fd51;
mul.f64 fd68, fd61, fd61;
mul.f64 fd69, fd62, fd62;
sub.f64 fd70, fd68, fd69;
mul.f64 fd71, fd62, fd61;
fma.rn.f64 fd72, fd62, fd61, fd71;
mul.f64 fd73, fd59, fd72;
mul.f64 fd74, fd42, fd72;
mul.f64 fd75, fd70, fd59;
ld.global.v2.f64 {fd76, fd77}, [rd6+10000];
mul.f64 fd80, fd60, fd77;
mul.f64 fd81, fd43, fd77;
mul.f64 fd82, fd76, fd60;
mul.f64 fd83, fd61, fd76;
mul.f64 fd84, fd62, fd77;
sub.f64 fd85, fd83, fd84;
mul.f64 fd86, fd61, fd77;
fma.rn.f64 fd87, fd62, fd76, fd86;
mul.f64 fd88, fd52, fd87;
mul.f64 fd89, fd35, fd87;
mul.f64 fd90, fd85, fd52;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
add.f64 fd91, fd26, fd25;
add.f64 fd92, fd23, fd22;
st.shared.v2.f64 [r9], {fd92, fd91};
fma.rn.f64 fd93, fd61, fd34, fd65;
sub.f64 fd94, fd67, fd66;
st.shared.v2.f64 [r9+16], {fd93, fd94};
fma.rn.f64 fd95, fd70, fd42, fd73;
sub.f64 fd96, fd75, fd74;
st.shared.v2.f64 [r9+32], {fd95, fd96};
fma.rn.f64 fd97, fd76, fd43, fd80;
sub.f64 fd98, fd82, fd81;
st.shared.v2.f64 [r9+48], {fd97, fd98};
fma.rn.f64 fd99, fd85, fd35, fd88;
sub.f64 fd100, fd90, fd89;
st.shared.v2.f64 [r9+64], {fd99, fd100};
barrier.sync 0;
shl.b32 r10, r7, 6;
sub.s32 r11, r9, r10;
ld.shared.v2.f64 {fd101, fd102}, [r11];
ld.shared.v2.f64 {fd105, fd106}, [r11+10000];
ld.shared.v2.f64 {fd109, fd110}, [r11+20000];
ld.shared.v2.f64 {fd113, fd114}, [r11+30000];
ld.shared.v2.f64 {fd117, fd118}, [r11+40000];
add.f64 fd121, fd105, fd117;
add.f64 fd122, fd101, fd121;
add.f64 fd123, fd109, fd113;
add.f64 fd124, fd106, fd118;
add.f64 fd125, fd102, fd124;
add.f64 fd126, fd110, fd114;
fma.rn.f64 fd127, fd121, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd128, fd123, 0d3FE9E3779B97F4A8;
sub.f64 fd129, fd127, fd128;
sub.f64 fd130, fd106, fd118;
mul.f64 fd131, fd130, 0d3FEE6F0E134454FF;
sub.f64 fd132, fd110, fd114;
fma.rn.f64 fd133, fd132, 0d3FE2CF2304755A5E, fd131;
sub.f64 fd134, fd129, fd133;
add.f64 fd135, fd133, fd129;
mul.f64 fd136, fd121, 0d3FE9E3779B97F4A8;
sub.f64 fd137, fd101, fd136;
fma.rn.f64 fd138, fd123, 0d3FD3C6EF372FE950, fd137;
mul.f64 fd139, fd130, 0d3FE2CF2304755A5E;
mul.f64 fd140, fd132, 0d3FEE6F0E134454FF;
sub.f64 fd141, fd139, fd140;
sub.f64 fd142, fd138, fd141;
add.f64 fd143, fd141, fd138;
fma.rn.f64 fd144, fd124, 0d3FD3C6EF372FE950, fd102;
mul.f64 fd145, fd126, 0d3FE9E3779B97F4A8;
sub.f64 fd146, fd144, fd145;
sub.f64 fd147, fd105, fd117;
mul.f64 fd148, fd147, 0d3FEE6F0E134454FF;
sub.f64 fd149, fd109, fd113;
fma.rn.f64 fd150, fd149, 0d3FE2CF2304755A5E, fd148;
add.f64 fd151, fd150, fd146;
sub.f64 fd152, fd146, fd150;
mul.f64 fd153, fd124, 0d3FE9E3779B97F4A8;
sub.f64 fd154, fd102, fd153;
fma.rn.f64 fd155, fd126, 0d3FD3C6EF372FE950, fd154;
mul.f64 fd156, fd147, 0d3FE2CF2304755A5E;
mul.f64 fd157, fd149, 0d3FEE6F0E134454FF;
sub.f64 fd158, fd156, fd157;
add.f64 fd159, fd158, fd155;
sub.f64 fd160, fd155, fd158;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd161, fd162}, [rd11];
mul.f64 fd165, fd151, fd162;
mul.f64 fd166, fd134, fd162;
mul.f64 fd167, fd161, fd151;
mul.f64 fd168, fd161, fd161;
mul.f64 fd169, fd162, fd162;
sub.f64 fd170, fd168, fd169;
mul.f64 fd171, fd162, fd161;
fma.rn.f64 fd172, fd162, fd161, fd171;
mul.f64 fd173, fd159, fd172;
mul.f64 fd174, fd142, fd172;
mul.f64 fd175, fd170, fd159;
ld.global.v2.f64 {fd176, fd177}, [rd11+2000];
mul.f64 fd180, fd160, fd177;
mul.f64 fd181, fd143, fd177;
mul.f64 fd182, fd176, fd160;
mul.f64 fd183, fd161, fd176;
mul.f64 fd184, fd162, fd177;
sub.f64 fd185, fd183, fd184;
mul.f64 fd186, fd161, fd177;
fma.rn.f64 fd187, fd162, fd176, fd186;
mul.f64 fd188, fd152, fd187;
mul.f64 fd189, fd135, fd187;
mul.f64 fd190, fd185, fd152;
shl.b32 r15, r14, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 400, r16;
add.f64 fd191, fd126, fd125;
add.f64 fd192, fd123, fd122;
st.shared.v2.f64 [r17], {fd192, fd191};
fma.rn.f64 fd193, fd161, fd134, fd165;
sub.f64 fd194, fd167, fd166;
st.shared.v2.f64 [r17+80], {fd193, fd194};
fma.rn.f64 fd195, fd170, fd142, fd173;
sub.f64 fd196, fd175, fd174;
st.shared.v2.f64 [r17+160], {fd195, fd196};
fma.rn.f64 fd197, fd176, fd143, fd180;
sub.f64 fd198, fd182, fd181;
st.shared.v2.f64 [r17+240], {fd197, fd198};
fma.rn.f64 fd199, fd185, fd135, fd188;
sub.f64 fd200, fd190, fd189;
st.shared.v2.f64 [r17+320], {fd199, fd200};
barrier.sync 0;
ld.shared.v2.f64 {fd201, fd202}, [r11];
ld.shared.v2.f64 {fd205, fd206}, [r11+10000];
ld.shared.v2.f64 {fd209, fd210}, [r11+20000];
ld.shared.v2.f64 {fd213, fd214}, [r11+30000];
ld.shared.v2.f64 {fd217, fd218}, [r11+40000];
add.f64 fd221, fd205, fd217;
add.f64 fd222, fd201, fd221;
add.f64 fd223, fd209, fd213;
add.f64 fd224, fd206, fd218;
add.f64 fd225, fd202, fd224;
add.f64 fd226, fd210, fd214;
fma.rn.f64 fd227, fd221, 0d3FD3C6EF372FE950, fd201;
mul.f64 fd228, fd223, 0d3FE9E3779B97F4A8;
sub.f64 fd229, fd227, fd228;
sub.f64 fd230, fd206, fd218;
mul.f64 fd231, fd230, 0d3FEE6F0E134454FF;
sub.f64 fd232, fd210, fd214;
fma.rn.f64 fd233, fd232, 0d3FE2CF2304755A5E, fd231;
sub.f64 fd234, fd229, fd233;
add.f64 fd235, fd233, fd229;
mul.f64 fd236, fd221, 0d3FE9E3779B97F4A8;
sub.f64 fd237, fd201, fd236;
fma.rn.f64 fd238, fd223, 0d3FD3C6EF372FE950, fd237;
mul.f64 fd239, fd230, 0d3FE2CF2304755A5E;
mul.f64 fd240, fd232, 0d3FEE6F0E134454FF;
sub.f64 fd241, fd239, fd240;
sub.f64 fd242, fd238, fd241;
add.f64 fd243, fd241, fd238;
fma.rn.f64 fd244, fd224, 0d3FD3C6EF372FE950, fd202;
mul.f64 fd245, fd226, 0d3FE9E3779B97F4A8;
sub.f64 fd246, fd244, fd245;
sub.f64 fd247, fd205, fd217;
mul.f64 fd248, fd247, 0d3FEE6F0E134454FF;
sub.f64 fd249, fd209, fd213;
fma.rn.f64 fd250, fd249, 0d3FE2CF2304755A5E, fd248;
add.f64 fd251, fd250, fd246;
sub.f64 fd252, fd246, fd250;
mul.f64 fd253, fd224, 0d3FE9E3779B97F4A8;
sub.f64 fd254, fd202, fd253;
fma.rn.f64 fd255, fd226, 0d3FD3C6EF372FE950, fd254;
mul.f64 fd256, fd247, 0d3FE2CF2304755A5E;
mul.f64 fd257, fd249, 0d3FEE6F0E134454FF;
sub.f64 fd258, fd256, fd257;
add.f64 fd259, fd258, fd255;
sub.f64 fd260, fd255, fd258;
mul.wide.u32 rd12, r7, 1374389535;
shr.u64 rd13, rd12, 35;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 25;
sub.s32 r20, r7, r19;
mul.wide.u32 rd14, r18, 16;
mov.u64 rd15, %13;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd261, fd262}, [rd16];
mul.f64 fd265, fd251, fd262;
mul.f64 fd266, fd234, fd262;
mul.f64 fd267, fd261, fd251;
mul.f64 fd268, fd261, fd261;
mul.f64 fd269, fd262, fd262;
sub.f64 fd270, fd268, fd269;
mul.f64 fd271, fd262, fd261;
fma.rn.f64 fd272, fd262, fd261, fd271;
mul.f64 fd273, fd259, fd272;
mul.f64 fd274, fd242, fd272;
mul.f64 fd275, fd270, fd259;
ld.global.v2.f64 {fd276, fd277}, [rd16+400];
mul.f64 fd280, fd260, fd277;
mul.f64 fd281, fd243, fd277;
mul.f64 fd282, fd276, fd260;
mul.f64 fd283, fd261, fd276;
mul.f64 fd284, fd262, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd261, fd277;
fma.rn.f64 fd287, fd262, fd276, fd286;
mul.f64 fd288, fd252, fd287;
mul.f64 fd289, fd235, fd287;
mul.f64 fd290, fd285, fd252;
shl.b32 r21, r20, 4;
add.s32 r22, r8, r21;
barrier.sync 0;
mad.lo.s32 r23, r18, 2000, r22;
add.f64 fd291, fd226, fd225;
add.f64 fd292, fd223, fd222;
st.shared.v2.f64 [r23], {fd292, fd291};
fma.rn.f64 fd293, fd261, fd234, fd265;
sub.f64 fd294, fd267, fd266;
st.shared.v2.f64 [r23+400], {fd293, fd294};
fma.rn.f64 fd295, fd270, fd242, fd273;
sub.f64 fd296, fd275, fd274;
st.shared.v2.f64 [r23+800], {fd295, fd296};
fma.rn.f64 fd297, fd276, fd243, fd280;
sub.f64 fd298, fd282, fd281;
st.shared.v2.f64 [r23+1200], {fd297, fd298};
fma.rn.f64 fd299, fd285, fd235, fd288;
sub.f64 fd300, fd290, fd289;
st.shared.v2.f64 [r23+1600], {fd299, fd300};
barrier.sync 0;
ld.shared.v2.f64 {fd301, fd302}, [r11];
ld.shared.v2.f64 {fd305, fd306}, [r11+10000];
ld.shared.v2.f64 {fd309, fd310}, [r11+20000];
ld.shared.v2.f64 {fd313, fd314}, [r11+30000];
ld.shared.v2.f64 {fd317, fd318}, [r11+40000];
add.f64 fd321, fd305, fd317;
add.f64 fd322, fd301, fd321;
add.f64 fd323, fd309, fd313;
add.f64 fd324, fd306, fd318;
add.f64 fd325, fd302, fd324;
add.f64 fd326, fd310, fd314;
fma.rn.f64 fd327, fd321, 0d3FD3C6EF372FE950, fd301;
mul.f64 fd328, fd323, 0d3FE9E3779B97F4A8;
sub.f64 fd329, fd327, fd328;
sub.f64 fd330, fd306, fd318;
mul.f64 fd331, fd330, 0d3FEE6F0E134454FF;
sub.f64 fd332, fd310, fd314;
fma.rn.f64 fd333, fd332, 0d3FE2CF2304755A5E, fd331;
sub.f64 fd334, fd329, fd333;
add.f64 fd335, fd333, fd329;
mul.f64 fd336, fd321, 0d3FE9E3779B97F4A8;
sub.f64 fd337, fd301, fd336;
fma.rn.f64 fd338, fd323, 0d3FD3C6EF372FE950, fd337;
mul.f64 fd339, fd330, 0d3FE2CF2304755A5E;
mul.f64 fd340, fd332, 0d3FEE6F0E134454FF;
sub.f64 fd341, fd339, fd340;
sub.f64 fd342, fd338, fd341;
add.f64 fd343, fd341, fd338;
fma.rn.f64 fd344, fd324, 0d3FD3C6EF372FE950, fd302;
mul.f64 fd345, fd326, 0d3FE9E3779B97F4A8;
sub.f64 fd346, fd344, fd345;
sub.f64 fd347, fd305, fd317;
mul.f64 fd348, fd347, 0d3FEE6F0E134454FF;
sub.f64 fd349, fd309, fd313;
fma.rn.f64 fd350, fd349, 0d3FE2CF2304755A5E, fd348;
add.f64 fd351, fd350, fd346;
sub.f64 fd352, fd346, fd350;
mul.f64 fd353, fd324, 0d3FE9E3779B97F4A8;
sub.f64 fd354, fd302, fd353;
fma.rn.f64 fd355, fd326, 0d3FD3C6EF372FE950, fd354;
mul.f64 fd356, fd347, 0d3FE2CF2304755A5E;
mul.f64 fd357, fd349, 0d3FEE6F0E134454FF;
sub.f64 fd358, fd356, fd357;
add.f64 fd359, fd358, fd355;
sub.f64 fd360, fd355, fd358;
mul.wide.u32 rd17, r7, 274877907;
shr.u64 rd18, rd17, 35;
cvt.u32.u64 r24, rd18;
mul.lo.s32 r25, r24, 125;
sub.s32 r26, r7, r25;
mul.wide.u32 rd19, r24, 16;
mov.u64 rd20, %14;
add.s64 rd21, rd20, rd19;
ld.global.v2.f64 {fd361, fd362}, [rd21];
mul.f64 fd365, fd351, fd362;
mul.f64 fd366, fd334, fd362;
mul.f64 fd367, fd361, fd351;
mul.f64 fd368, fd361, fd361;
mul.f64 fd369, fd362, fd362;
sub.f64 fd370, fd368, fd369;
mul.f64 fd371, fd362, fd361;
fma.rn.f64 fd372, fd362, fd361, fd371;
mul.f64 fd373, fd359, fd372;
mul.f64 fd374, fd342, fd372;
mul.f64 fd375, fd370, fd359;
ld.global.v2.f64 {fd376, fd377}, [rd21+80];
mul.f64 fd380, fd360, fd377;
mul.f64 fd381, fd343, fd377;
mul.f64 fd382, fd376, fd360;
mul.f64 fd383, fd361, fd376;
mul.f64 fd384, fd362, fd377;
sub.f64 fd385, fd383, fd384;
mul.f64 fd386, fd361, fd377;
fma.rn.f64 fd387, fd362, fd376, fd386;
mul.f64 fd388, fd352, fd387;
mul.f64 fd389, fd335, fd387;
mul.f64 fd390, fd385, fd352;
shl.b32 r27, r26, 4;
add.s32 r28, r8, r27;
barrier.sync 0;
mad.lo.s32 r29, r24, 10000, r28;
add.f64 fd391, fd326, fd325;
add.f64 fd392, fd323, fd322;
st.shared.v2.f64 [r29], {fd392, fd391};
fma.rn.f64 fd393, fd361, fd334, fd365;
sub.f64 fd394, fd367, fd366;
st.shared.v2.f64 [r29+2000], {fd393, fd394};
fma.rn.f64 fd395, fd370, fd342, fd373;
sub.f64 fd396, fd375, fd374;
st.shared.v2.f64 [r29+4000], {fd395, fd396};
fma.rn.f64 fd397, fd376, fd343, fd380;
sub.f64 fd398, fd382, fd381;
st.shared.v2.f64 [r29+6000], {fd397, fd398};
fma.rn.f64 fd399, fd385, fd335, fd388;
sub.f64 fd400, fd390, fd389;
st.shared.v2.f64 [r29+8000], {fd399, fd400};
barrier.sync 0;
ld.shared.v2.f64 {fd401, fd402}, [r11];
ld.shared.v2.f64 {fd405, fd406}, [r11+10000];
ld.shared.v2.f64 {fd409, fd410}, [r11+20000];
ld.shared.v2.f64 {fd413, fd414}, [r11+30000];
ld.shared.v2.f64 {fd417, fd418}, [r11+40000];
add.f64 fd421, fd405, fd417;
add.f64 fd422, fd401, fd421;
add.f64 fd423, fd409, fd413;
add.f64 fd424, fd406, fd418;
add.f64 fd425, fd402, fd424;
add.f64 fd426, fd410, fd414;
fma.rn.f64 fd427, fd421, 0d3FD3C6EF372FE950, fd401;
mul.f64 fd428, fd423, 0d3FE9E3779B97F4A8;
sub.f64 fd429, fd427, fd428;
sub.f64 fd430, fd406, fd418;
mul.f64 fd431, fd430, 0d3FEE6F0E134454FF;
sub.f64 fd432, fd410, fd414;
fma.rn.f64 fd433, fd432, 0d3FE2CF2304755A5E, fd431;
mul.f64 fd434, fd421, 0d3FE9E3779B97F4A8;
sub.f64 fd435, fd401, fd434;
fma.rn.f64 fd436, fd423, 0d3FD3C6EF372FE950, fd435;
mul.f64 fd437, fd430, 0d3FE2CF2304755A5E;
mul.f64 fd438, fd432, 0d3FEE6F0E134454FF;
sub.f64 fd439, fd437, fd438;
fma.rn.f64 fd440, fd424, 0d3FD3C6EF372FE950, fd402;
mul.f64 fd441, fd426, 0d3FE9E3779B97F4A8;
sub.f64 fd442, fd440, fd441;
sub.f64 fd443, fd405, fd417;
mul.f64 fd444, fd443, 0d3FEE6F0E134454FF;
sub.f64 fd445, fd409, fd413;
fma.rn.f64 fd446, fd445, 0d3FE2CF2304755A5E, fd444;
mul.f64 fd447, fd424, 0d3FE9E3779B97F4A8;
sub.f64 fd448, fd402, fd447;
fma.rn.f64 fd449, fd426, 0d3FD3C6EF372FE950, fd448;
mul.f64 fd450, fd443, 0d3FE2CF2304755A5E;
mul.f64 fd451, fd445, 0d3FEE6F0E134454FF;
sub.f64 fd452, fd450, fd451;
add.f64 %1, fd426, fd425;
add.f64 %0, fd423, fd422;
add.f64 %3, fd446, fd442;
sub.f64 %2, fd429, fd433;
add.f64 %5, fd452, fd449;
sub.f64 %4, fd436, fd439;
sub.f64 %7, fd449, fd452;
add.f64 %6, fd439, fd436;
sub.f64 %9, fd442, fd446;
add.f64 %8, fd433, fd429;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y): "r"(smem), "l"(lut_dp_5_3125), "l"(lut_dp_5_625), "l"(lut_dp_5_125), "l"(lut_dp_5_25), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y));
};


#endif
