#ifndef CUFFTDX_FFT_1024_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_1024_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<647, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<29>;
.reg .f64 fd<472>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %20, %30;
add.f64 fd34, %21, %32;
sub.f64 fd35, %20, %30;
sub.f64 fd36, %21, %32;
add.f64 fd37, %25, %36;
add.f64 fd38, %27, %37;
sub.f64 fd39, %25, %36;
sub.f64 fd40, %27, %37;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
sub.f64 fd45, fd35, fd40;
add.f64 fd46, fd36, fd39;
add.f64 fd47, fd35, fd40;
sub.f64 fd48, fd36, fd39;
add.f64 fd49, %22, %33;
add.f64 fd50, %24, %35;
sub.f64 fd51, %22, %33;
sub.f64 fd52, %24, %35;
add.f64 fd53, %28, %38;
add.f64 fd54, %29, %39;
sub.f64 fd55, %28, %38;
sub.f64 fd56, %29, %39;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
sub.f64 fd61, fd51, fd56;
add.f64 fd62, fd52, fd55;
add.f64 fd63, fd51, fd56;
sub.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0d3FE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
add.f64 fd68, fd65, fd66;
mul.f64 fd69, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd70, fd64, 0d3FE6A09E667F3BCD;
sub.f64 fd71, fd69, fd70;
mul.f64 fd72, fd64, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd73, fd63, 0d3FE6A09E667F3BCD, fd72;
add.f64 fd74, fd41, fd57;
add.f64 fd75, fd42, fd58;
sub.f64 fd76, fd41, fd57;
sub.f64 fd77, fd42, fd58;
add.f64 fd78, fd45, fd67;
add.f64 fd79, fd46, fd68;
sub.f64 fd80, fd45, fd67;
sub.f64 fd81, fd46, fd68;
sub.f64 fd82, fd43, fd60;
add.f64 fd83, fd44, fd59;
add.f64 fd84, fd43, fd60;
sub.f64 fd85, fd44, fd59;
add.f64 fd86, fd47, fd71;
add.f64 fd87, fd48, fd73;
sub.f64 fd88, fd47, fd71;
sub.f64 fd89, fd48, fd73;
and.b32 r6, r5, 127;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 2032;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd90, fd91}, [rd5];
mul.f64 fd94, fd79, fd91;
fma.rn.f64 fd95, fd90, fd78, fd94;
mul.f64 fd96, fd78, fd91;
mul.f64 fd97, fd90, fd79;
sub.f64 fd98, fd97, fd96;
mul.f64 fd99, fd90, fd90;
mul.f64 fd100, fd91, fd91;
sub.f64 fd101, fd99, fd100;
mul.f64 fd102, fd91, fd90;
fma.rn.f64 fd103, fd91, fd90, fd102;
mul.f64 fd104, fd83, fd103;
fma.rn.f64 fd105, fd101, fd82, fd104;
mul.f64 fd106, fd82, fd103;
mul.f64 fd107, fd101, fd83;
sub.f64 fd108, fd107, fd106;
mul.f64 fd109, fd90, fd101;
mul.f64 fd110, fd91, fd103;
sub.f64 fd111, fd109, fd110;
mul.f64 fd112, fd90, fd103;
fma.rn.f64 fd113, fd91, fd101, fd112;
mul.f64 fd114, fd87, fd113;
fma.rn.f64 fd115, fd111, fd86, fd114;
mul.f64 fd116, fd86, fd113;
mul.f64 fd117, fd111, fd87;
sub.f64 fd118, fd117, fd116;
mul.f64 fd119, fd90, fd111;
mul.f64 fd120, fd91, fd113;
sub.f64 fd121, fd119, fd120;
mul.f64 fd122, fd90, fd113;
fma.rn.f64 fd123, fd91, fd111, fd122;
mul.f64 fd124, fd77, fd123;
fma.rn.f64 fd125, fd121, fd76, fd124;
mul.f64 fd126, fd76, fd123;
mul.f64 fd127, fd121, fd77;
sub.f64 fd128, fd127, fd126;
ld.global.v2.f64 {fd129, fd130}, [rd5+2048];
mul.f64 fd133, fd81, fd130;
fma.rn.f64 fd134, fd129, fd80, fd133;
mul.f64 fd135, fd80, fd130;
mul.f64 fd136, fd129, fd81;
sub.f64 fd137, fd136, fd135;
mul.f64 fd138, fd90, fd129;
mul.f64 fd139, fd91, fd130;
sub.f64 fd140, fd138, fd139;
mul.f64 fd141, fd90, fd130;
fma.rn.f64 fd142, fd91, fd129, fd141;
mul.f64 fd143, fd85, fd142;
fma.rn.f64 fd144, fd140, fd84, fd143;
mul.f64 fd145, fd84, fd142;
mul.f64 fd146, fd140, fd85;
sub.f64 fd147, fd146, fd145;
mul.f64 fd148, fd90, fd140;
mul.f64 fd149, fd91, fd142;
sub.f64 fd150, fd148, fd149;
mul.f64 fd151, fd90, fd142;
fma.rn.f64 fd152, fd91, fd140, fd151;
mul.f64 fd153, fd89, fd152;
fma.rn.f64 fd154, fd150, fd88, fd153;
mul.f64 fd155, fd88, fd152;
mul.f64 fd156, fd150, fd89;
sub.f64 fd157, fd156, fd155;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8128;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd74, fd95};
st.shared.v2.f64 [r12+16], {fd105, fd115};
st.shared.v2.f64 [r12+32], {fd125, fd134};
st.shared.v2.f64 [r12+48], {fd144, fd154};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.f64 fd158, [r13];
ld.shared.f64 fd159, [r13+1024];
ld.shared.f64 fd160, [r13+2048];
ld.shared.f64 fd161, [r13+3072];
ld.shared.f64 fd162, [r13+4096];
ld.shared.f64 fd163, [r13+5120];
ld.shared.f64 fd164, [r13+6144];
ld.shared.f64 fd165, [r13+7168];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd75, fd98};
st.shared.v2.f64 [r12+16], {fd108, fd118};
st.shared.v2.f64 [r12+32], {fd128, fd137};
st.shared.v2.f64 [r12+48], {fd147, fd157};
barrier.sync 0;
ld.shared.f64 fd166, [r13];
ld.shared.f64 fd167, [r13+1024];
ld.shared.f64 fd168, [r13+2048];
ld.shared.f64 fd169, [r13+3072];
ld.shared.f64 fd170, [r13+4096];
ld.shared.f64 fd171, [r13+5120];
ld.shared.f64 fd172, [r13+6144];
ld.shared.f64 fd173, [r13+7168];
add.f64 fd174, fd158, fd162;
add.f64 fd175, fd166, fd170;
sub.f64 fd176, fd158, fd162;
sub.f64 fd177, fd166, fd170;
add.f64 fd178, fd160, fd164;
add.f64 fd179, fd168, fd172;
sub.f64 fd180, fd160, fd164;
sub.f64 fd181, fd168, fd172;
add.f64 fd182, fd174, fd178;
add.f64 fd183, fd175, fd179;
sub.f64 fd184, fd174, fd178;
sub.f64 fd185, fd175, fd179;
sub.f64 fd186, fd176, fd181;
add.f64 fd187, fd177, fd180;
add.f64 fd188, fd176, fd181;
sub.f64 fd189, fd177, fd180;
add.f64 fd190, fd159, fd163;
add.f64 fd191, fd167, fd171;
sub.f64 fd192, fd159, fd163;
sub.f64 fd193, fd167, fd171;
add.f64 fd194, fd161, fd165;
add.f64 fd195, fd169, fd173;
sub.f64 fd196, fd161, fd165;
sub.f64 fd197, fd169, fd173;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
sub.f64 fd202, fd192, fd197;
add.f64 fd203, fd193, fd196;
add.f64 fd204, fd192, fd197;
sub.f64 fd205, fd193, fd196;
mul.f64 fd206, fd202, 0d3FE6A09E667F3BCD;
mul.f64 fd207, fd203, 0d3FE6A09E667F3BCD;
sub.f64 fd208, fd206, fd207;
add.f64 fd209, fd206, fd207;
mul.f64 fd210, fd204, 0dBFE6A09E667F3BCD;
mul.f64 fd211, fd205, 0d3FE6A09E667F3BCD;
sub.f64 fd212, fd210, fd211;
mul.f64 fd213, fd205, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd214, fd204, 0d3FE6A09E667F3BCD, fd213;
add.f64 fd215, fd182, fd198;
add.f64 fd216, fd183, fd199;
sub.f64 fd217, fd182, fd198;
sub.f64 fd218, fd183, fd199;
add.f64 fd219, fd186, fd208;
add.f64 fd220, fd187, fd209;
sub.f64 fd221, fd186, fd208;
sub.f64 fd222, fd187, fd209;
sub.f64 fd223, fd184, fd201;
add.f64 fd224, fd185, fd200;
add.f64 fd225, fd184, fd201;
sub.f64 fd226, fd185, fd200;
add.f64 fd227, fd188, fd212;
add.f64 fd228, fd189, fd214;
sub.f64 fd229, fd188, fd212;
sub.f64 fd230, fd189, fd214;
and.b32 r14, r5, 120;
bfe.u32 r15, r5, 3, 4;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd231, fd232}, [rd8];
mul.f64 fd235, fd220, fd232;
fma.rn.f64 fd236, fd231, fd219, fd235;
mul.f64 fd237, fd219, fd232;
mul.f64 fd238, fd231, fd220;
sub.f64 fd239, fd238, fd237;
mul.f64 fd240, fd231, fd231;
mul.f64 fd241, fd232, fd232;
sub.f64 fd242, fd240, fd241;
mul.f64 fd243, fd232, fd231;
fma.rn.f64 fd244, fd232, fd231, fd243;
mul.f64 fd245, fd224, fd244;
fma.rn.f64 fd246, fd242, fd223, fd245;
mul.f64 fd247, fd223, fd244;
mul.f64 fd248, fd242, fd224;
sub.f64 fd249, fd248, fd247;
mul.f64 fd250, fd231, fd242;
mul.f64 fd251, fd232, fd244;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd231, fd244;
fma.rn.f64 fd254, fd232, fd242, fd253;
mul.f64 fd255, fd228, fd254;
fma.rn.f64 fd256, fd252, fd227, fd255;
mul.f64 fd257, fd227, fd254;
mul.f64 fd258, fd252, fd228;
sub.f64 fd259, fd258, fd257;
mul.f64 fd260, fd231, fd252;
mul.f64 fd261, fd232, fd254;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd231, fd254;
fma.rn.f64 fd264, fd232, fd252, fd263;
mul.f64 fd265, fd218, fd264;
fma.rn.f64 fd266, fd262, fd217, fd265;
mul.f64 fd267, fd217, fd264;
mul.f64 fd268, fd262, fd218;
sub.f64 fd269, fd268, fd267;
ld.global.v2.f64 {fd270, fd271}, [rd8+256];
mul.f64 fd274, fd222, fd271;
fma.rn.f64 fd275, fd270, fd221, fd274;
mul.f64 fd276, fd221, fd271;
mul.f64 fd277, fd270, fd222;
sub.f64 fd278, fd277, fd276;
mul.f64 fd279, fd231, fd270;
mul.f64 fd280, fd232, fd271;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd231, fd271;
fma.rn.f64 fd283, fd232, fd270, fd282;
mul.f64 fd284, fd226, fd283;
fma.rn.f64 fd285, fd281, fd225, fd284;
mul.f64 fd286, fd225, fd283;
mul.f64 fd287, fd281, fd226;
sub.f64 fd288, fd287, fd286;
mul.f64 fd289, fd231, fd281;
mul.f64 fd290, fd232, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd231, fd283;
fma.rn.f64 fd293, fd232, fd281, fd292;
mul.f64 fd294, fd230, fd293;
fma.rn.f64 fd295, fd291, fd229, fd294;
mul.f64 fd296, fd229, fd293;
mul.f64 fd297, fd291, fd230;
sub.f64 fd298, fd297, fd296;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 56;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 7680;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd215;
st.shared.f64 [r20+64], fd236;
st.shared.f64 [r20+128], fd246;
st.shared.f64 [r20+192], fd256;
st.shared.f64 [r20+256], fd266;
st.shared.f64 [r20+320], fd275;
st.shared.f64 [r20+384], fd285;
st.shared.f64 [r20+448], fd295;
barrier.sync 0;
mad.lo.s32 r21, r14, -56, r20;
ld.shared.f64 fd299, [r21];
ld.shared.f64 fd300, [r21+1024];
ld.shared.f64 fd301, [r21+2048];
ld.shared.f64 fd302, [r21+3072];
ld.shared.f64 fd303, [r21+4096];
ld.shared.f64 fd304, [r21+5120];
ld.shared.f64 fd305, [r21+6144];
ld.shared.f64 fd306, [r21+7168];
barrier.sync 0;
st.shared.f64 [r20], fd216;
st.shared.f64 [r20+64], fd239;
st.shared.f64 [r20+128], fd249;
st.shared.f64 [r20+192], fd259;
st.shared.f64 [r20+256], fd269;
st.shared.f64 [r20+320], fd278;
st.shared.f64 [r20+384], fd288;
st.shared.f64 [r20+448], fd298;
barrier.sync 0;
ld.shared.f64 fd307, [r21];
ld.shared.f64 fd308, [r21+1024];
ld.shared.f64 fd309, [r21+2048];
ld.shared.f64 fd310, [r21+3072];
ld.shared.f64 fd311, [r21+4096];
ld.shared.f64 fd312, [r21+5120];
ld.shared.f64 fd313, [r21+6144];
ld.shared.f64 fd314, [r21+7168];
add.f64 fd315, fd299, fd303;
add.f64 fd316, fd307, fd311;
sub.f64 fd317, fd299, fd303;
sub.f64 fd318, fd307, fd311;
add.f64 fd319, fd301, fd305;
add.f64 fd320, fd309, fd313;
sub.f64 fd321, fd301, fd305;
sub.f64 fd322, fd309, fd313;
add.f64 fd323, fd315, fd319;
add.f64 fd324, fd316, fd320;
sub.f64 fd325, fd315, fd319;
sub.f64 fd326, fd316, fd320;
sub.f64 fd327, fd317, fd322;
add.f64 fd328, fd318, fd321;
add.f64 fd329, fd317, fd322;
sub.f64 fd330, fd318, fd321;
add.f64 fd331, fd300, fd304;
add.f64 fd332, fd308, fd312;
sub.f64 fd333, fd300, fd304;
sub.f64 fd334, fd308, fd312;
add.f64 fd335, fd302, fd306;
add.f64 fd336, fd310, fd314;
sub.f64 fd337, fd302, fd306;
sub.f64 fd338, fd310, fd314;
add.f64 fd339, fd331, fd335;
add.f64 fd340, fd332, fd336;
sub.f64 fd341, fd331, fd335;
sub.f64 fd342, fd332, fd336;
sub.f64 fd343, fd333, fd338;
add.f64 fd344, fd334, fd337;
add.f64 fd345, fd333, fd338;
sub.f64 fd346, fd334, fd337;
mul.f64 fd347, fd343, 0d3FE6A09E667F3BCD;
mul.f64 fd348, fd344, 0d3FE6A09E667F3BCD;
sub.f64 fd349, fd347, fd348;
add.f64 fd350, fd347, fd348;
mul.f64 fd351, fd345, 0dBFE6A09E667F3BCD;
mul.f64 fd352, fd346, 0d3FE6A09E667F3BCD;
sub.f64 fd353, fd351, fd352;
mul.f64 fd354, fd346, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd355, fd345, 0d3FE6A09E667F3BCD, fd354;
add.f64 fd356, fd323, fd339;
add.f64 fd357, fd324, fd340;
sub.f64 fd358, fd323, fd339;
sub.f64 fd359, fd324, fd340;
add.f64 fd360, fd327, fd349;
add.f64 fd361, fd328, fd350;
sub.f64 fd362, fd327, fd349;
sub.f64 fd363, fd328, fd350;
sub.f64 fd364, fd325, fd342;
add.f64 fd365, fd326, fd341;
add.f64 fd366, fd325, fd342;
sub.f64 fd367, fd326, fd341;
add.f64 fd368, fd329, fd353;
add.f64 fd369, fd330, fd355;
sub.f64 fd370, fd329, fd353;
sub.f64 fd371, fd330, fd355;
and.b32 r22, r5, 64;
bfe.u32 r23, r5, 6, 1;
mul.wide.u32 rd9, r23, 16;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd372, fd373}, [rd11];
mul.f64 fd376, fd361, fd373;
fma.rn.f64 fd377, fd372, fd360, fd376;
mul.f64 fd378, fd360, fd373;
mul.f64 fd379, fd372, fd361;
sub.f64 fd380, fd379, fd378;
mul.f64 fd381, fd372, fd372;
mul.f64 fd382, fd373, fd373;
sub.f64 fd383, fd381, fd382;
mul.f64 fd384, fd373, fd372;
fma.rn.f64 fd385, fd373, fd372, fd384;
mul.f64 fd386, fd365, fd385;
fma.rn.f64 fd387, fd383, fd364, fd386;
mul.f64 fd388, fd364, fd385;
mul.f64 fd389, fd383, fd365;
sub.f64 fd390, fd389, fd388;
mul.f64 fd391, fd372, fd383;
mul.f64 fd392, fd373, fd385;
sub.f64 fd393, fd391, fd392;
mul.f64 fd394, fd372, fd385;
fma.rn.f64 fd395, fd373, fd383, fd394;
mul.f64 fd396, fd369, fd395;
fma.rn.f64 fd397, fd393, fd368, fd396;
mul.f64 fd398, fd368, fd395;
mul.f64 fd399, fd393, fd369;
sub.f64 fd400, fd399, fd398;
mul.f64 fd401, fd372, fd393;
mul.f64 fd402, fd373, fd395;
sub.f64 fd403, fd401, fd402;
mul.f64 fd404, fd372, fd395;
fma.rn.f64 fd405, fd373, fd393, fd404;
mul.f64 fd406, fd359, fd405;
fma.rn.f64 fd407, fd403, fd358, fd406;
mul.f64 fd408, fd358, fd405;
mul.f64 fd409, fd403, fd359;
sub.f64 fd410, fd409, fd408;
ld.global.v2.f64 {fd411, fd412}, [rd11+32];
mul.f64 fd415, fd363, fd412;
fma.rn.f64 fd416, fd411, fd362, fd415;
mul.f64 fd417, fd362, fd412;
mul.f64 fd418, fd411, fd363;
sub.f64 fd419, fd418, fd417;
mul.f64 fd420, fd372, fd411;
mul.f64 fd421, fd373, fd412;
sub.f64 fd422, fd420, fd421;
mul.f64 fd423, fd372, fd412;
fma.rn.f64 fd424, fd373, fd411, fd423;
mul.f64 fd425, fd367, fd424;
fma.rn.f64 fd426, fd422, fd366, fd425;
mul.f64 fd427, fd366, fd424;
mul.f64 fd428, fd422, fd367;
sub.f64 fd429, fd428, fd427;
mul.f64 fd430, fd372, fd422;
mul.f64 fd431, fd373, fd424;
sub.f64 fd432, fd430, fd431;
mul.f64 fd433, fd372, fd424;
fma.rn.f64 fd434, fd373, fd422, fd433;
mul.f64 fd435, fd371, fd434;
fma.rn.f64 fd436, fd432, fd370, fd435;
mul.f64 fd437, fd370, fd434;
mul.f64 fd438, fd432, fd371;
sub.f64 fd439, fd438, fd437;
and.b32 r24, r16, 504;
add.s32 r25, r10, r24;
barrier.sync 0;
and.b32 r26, r8, 4096;
add.s32 r27, r25, r26;
st.shared.f64 [r27], fd356;
st.shared.f64 [r27+512], fd377;
st.shared.f64 [r27+1024], fd387;
st.shared.f64 [r27+1536], fd397;
st.shared.f64 [r27+2048], fd407;
st.shared.f64 [r27+2560], fd416;
st.shared.f64 [r27+3072], fd426;
st.shared.f64 [r27+3584], fd436;
barrier.sync 0;
mad.lo.s32 r28, r22, -56, r27;
ld.shared.f64 fd440, [r28];
ld.shared.f64 fd441, [r28+1024];
ld.shared.f64 fd442, [r28+2048];
ld.shared.f64 fd443, [r28+3072];
ld.shared.f64 fd444, [r28+4096];
ld.shared.f64 fd445, [r28+5120];
ld.shared.f64 fd446, [r28+6144];
ld.shared.f64 fd447, [r28+7168];
barrier.sync 0;
st.shared.f64 [r27], fd357;
st.shared.f64 [r27+512], fd380;
st.shared.f64 [r27+1024], fd390;
st.shared.f64 [r27+1536], fd400;
st.shared.f64 [r27+2048], fd410;
st.shared.f64 [r27+2560], fd419;
st.shared.f64 [r27+3072], fd429;
st.shared.f64 [r27+3584], fd439;
barrier.sync 0;
ld.shared.f64 fd448, [r28];
ld.shared.f64 fd449, [r28+1024];
ld.shared.f64 fd450, [r28+2048];
ld.shared.f64 fd451, [r28+3072];
ld.shared.f64 fd452, [r28+4096];
ld.shared.f64 fd453, [r28+5120];
ld.shared.f64 fd454, [r28+6144];
ld.shared.f64 fd455, [r28+7168];
add.f64 %0, fd440, fd444;
add.f64 %1, fd448, fd452;
add.f64 %2, fd441, fd445;
add.f64 %3, fd449, fd453;
add.f64 %4, fd442, fd446;
add.f64 %5, fd450, fd454;
add.f64 %6, fd443, fd447;
add.f64 %7, fd451, fd455;
sub.f64 %8, fd440, fd444;
sub.f64 %9, fd448, fd452;
sub.f64 %10, fd441, fd445;
sub.f64 %11, fd449, fd453;
sub.f64 %12, fd442, fd446;
sub.f64 %13, fd450, fd454;
sub.f64 %14, fd443, fd447;
sub.f64 %15, fd451, fd455;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_1024), "l"(lut_dp_8_128), "l"(lut_dp_8_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<648, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<839>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd65, %35, %56;
add.f64 fd66, %36, %58;
sub.f64 fd67, %35, %56;
sub.f64 fd68, %36, %58;
add.f64 fd69, %45, %67;
add.f64 fd70, %47, %68;
sub.f64 fd71, %45, %67;
sub.f64 fd72, %47, %68;
add.f64 fd73, fd65, fd69;
add.f64 fd74, fd66, fd70;
sub.f64 fd75, fd65, fd69;
sub.f64 fd76, fd66, fd70;
sub.f64 fd77, fd67, fd72;
add.f64 fd78, fd68, fd71;
add.f64 fd79, fd67, fd72;
sub.f64 fd80, fd68, fd71;
add.f64 fd81, %40, %61;
add.f64 fd82, %42, %63;
sub.f64 fd83, %40, %61;
sub.f64 fd84, %42, %63;
add.f64 fd85, %51, %72;
add.f64 fd86, %52, %74;
sub.f64 fd87, %51, %72;
sub.f64 fd88, %52, %74;
add.f64 fd89, fd81, fd85;
add.f64 fd90, fd82, fd86;
sub.f64 fd91, fd81, fd85;
sub.f64 fd92, fd82, fd86;
sub.f64 fd93, fd83, fd88;
add.f64 fd94, fd84, fd87;
add.f64 fd95, fd83, fd88;
sub.f64 fd96, fd84, fd87;
mul.f64 fd97, fd93, 0d3FE6A09E667F3BCD;
mul.f64 fd98, fd94, 0d3FE6A09E667F3BCD;
sub.f64 fd99, fd97, fd98;
add.f64 fd100, fd97, fd98;
mul.f64 fd101, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd102, fd96, 0d3FE6A09E667F3BCD;
sub.f64 fd103, fd101, fd102;
mul.f64 fd104, fd96, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd105, fd95, 0d3FE6A09E667F3BCD, fd104;
add.f64 fd106, fd73, fd89;
add.f64 fd107, fd74, fd90;
sub.f64 fd108, fd73, fd89;
sub.f64 fd109, fd74, fd90;
add.f64 fd110, fd77, fd99;
add.f64 fd111, fd78, fd100;
sub.f64 fd112, fd77, fd99;
sub.f64 fd113, fd78, fd100;
sub.f64 fd114, fd75, fd92;
add.f64 fd115, fd76, fd91;
add.f64 fd116, fd75, fd92;
sub.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd103;
add.f64 fd119, fd80, fd105;
sub.f64 fd120, fd79, fd103;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %37, %59;
add.f64 fd123, %39, %60;
sub.f64 fd124, %37, %59;
sub.f64 fd125, %39, %60;
add.f64 fd126, %48, %69;
add.f64 fd127, %50, %71;
sub.f64 fd128, %48, %69;
sub.f64 fd129, %50, %71;
add.f64 fd130, fd122, fd126;
add.f64 fd131, fd123, fd127;
sub.f64 fd132, fd122, fd126;
sub.f64 fd133, fd123, fd127;
sub.f64 fd134, fd124, fd129;
add.f64 fd135, fd125, fd128;
add.f64 fd136, fd124, fd129;
sub.f64 fd137, fd125, fd128;
add.f64 fd138, %43, %64;
add.f64 fd139, %44, %66;
sub.f64 fd140, %43, %64;
sub.f64 fd141, %44, %66;
add.f64 fd142, %53, %75;
add.f64 fd143, %55, %76;
sub.f64 fd144, %53, %75;
sub.f64 fd145, %55, %76;
add.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd143;
sub.f64 fd148, fd138, fd142;
sub.f64 fd149, fd139, fd143;
sub.f64 fd150, fd140, fd145;
add.f64 fd151, fd141, fd144;
add.f64 fd152, fd140, fd145;
sub.f64 fd153, fd141, fd144;
mul.f64 fd154, fd150, 0d3FE6A09E667F3BCD;
mul.f64 fd155, fd151, 0d3FE6A09E667F3BCD;
sub.f64 fd156, fd154, fd155;
add.f64 fd157, fd154, fd155;
mul.f64 fd158, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd159, fd153, 0d3FE6A09E667F3BCD;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd153, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd162, fd152, 0d3FE6A09E667F3BCD, fd161;
add.f64 fd163, fd130, fd146;
add.f64 fd164, fd131, fd147;
sub.f64 fd165, fd130, fd146;
sub.f64 fd166, fd131, fd147;
add.f64 fd167, fd134, fd156;
add.f64 fd168, fd135, fd157;
sub.f64 fd169, fd134, fd156;
sub.f64 fd170, fd135, fd157;
sub.f64 fd171, fd132, fd149;
add.f64 fd172, fd133, fd148;
add.f64 fd173, fd132, fd149;
sub.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd160;
add.f64 fd176, fd137, fd162;
sub.f64 fd177, fd136, fd160;
sub.f64 fd178, fd137, fd162;
mul.f64 fd179, fd167, 0d3FED906BCF328D46;
mul.f64 fd180, fd168, 0d3FD87DE2A6AEA963;
sub.f64 fd181, fd179, fd180;
mul.f64 fd182, fd168, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0d3FD87DE2A6AEA963, fd182;
mul.f64 fd184, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd185, fd172, 0d3FE6A09E667F3BCD;
sub.f64 fd186, fd184, fd185;
add.f64 fd187, fd184, fd185;
mul.f64 fd188, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd189, fd176, 0d3FED906BCF328D46;
sub.f64 fd190, fd188, fd189;
mul.f64 fd191, fd176, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd192, fd175, 0d3FED906BCF328D46, fd191;
mul.f64 fd193, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd194, fd170, 0d3FED906BCF328D46;
sub.f64 fd195, fd193, fd194;
mul.f64 fd196, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd197, fd169, 0d3FED906BCF328D46, fd196;
mul.f64 fd198, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd199, fd174, 0d3FE6A09E667F3BCD;
sub.f64 fd200, fd198, fd199;
mul.f64 fd201, fd174, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd202, fd173, 0d3FE6A09E667F3BCD, fd201;
mul.f64 fd203, fd177, 0dBFED906BCF328D46;
mul.f64 fd204, fd178, 0d3FD87DE2A6AEA963;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0d3FD87DE2A6AEA963, fd206;
add.f64 fd208, fd106, fd163;
add.f64 fd209, fd107, fd164;
sub.f64 fd210, fd106, fd163;
sub.f64 fd211, fd107, fd164;
add.f64 fd212, fd110, fd181;
add.f64 fd213, fd111, fd183;
sub.f64 fd214, fd110, fd181;
sub.f64 fd215, fd111, fd183;
add.f64 fd216, fd114, fd186;
add.f64 fd217, fd115, fd187;
sub.f64 fd218, fd114, fd186;
sub.f64 fd219, fd115, fd187;
add.f64 fd220, fd118, fd190;
add.f64 fd221, fd119, fd192;
sub.f64 fd222, fd118, fd190;
sub.f64 fd223, fd119, fd192;
sub.f64 fd224, fd108, fd166;
add.f64 fd225, fd109, fd165;
add.f64 fd226, fd108, fd166;
sub.f64 fd227, fd109, fd165;
add.f64 fd228, fd112, fd195;
add.f64 fd229, fd113, fd197;
sub.f64 fd230, fd112, fd195;
sub.f64 fd231, fd113, fd197;
add.f64 fd232, fd116, fd200;
add.f64 fd233, fd117, fd202;
sub.f64 fd234, fd116, fd200;
sub.f64 fd235, fd117, fd202;
add.f64 fd236, fd120, fd205;
add.f64 fd237, fd121, fd207;
sub.f64 fd238, fd120, fd205;
sub.f64 fd239, fd121, fd207;
and.b32 r6, r5, 63;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 1008;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd240, fd241}, [rd5];
mul.f64 fd244, fd213, fd241;
fma.rn.f64 fd245, fd240, fd212, fd244;
mul.f64 fd246, fd212, fd241;
mul.f64 fd247, fd240, fd213;
sub.f64 fd248, fd247, fd246;
mul.f64 fd249, fd240, fd240;
mul.f64 fd250, fd241, fd241;
sub.f64 fd251, fd249, fd250;
mul.f64 fd252, fd241, fd240;
fma.rn.f64 fd253, fd241, fd240, fd252;
mul.f64 fd254, fd217, fd253;
fma.rn.f64 fd255, fd251, fd216, fd254;
mul.f64 fd256, fd216, fd253;
mul.f64 fd257, fd251, fd217;
sub.f64 fd258, fd257, fd256;
mul.f64 fd259, fd240, fd251;
mul.f64 fd260, fd241, fd253;
sub.f64 fd261, fd259, fd260;
mul.f64 fd262, fd240, fd253;
fma.rn.f64 fd263, fd241, fd251, fd262;
mul.f64 fd264, fd221, fd263;
fma.rn.f64 fd265, fd261, fd220, fd264;
mul.f64 fd266, fd220, fd263;
mul.f64 fd267, fd261, fd221;
sub.f64 fd268, fd267, fd266;
mul.f64 fd269, fd240, fd261;
mul.f64 fd270, fd241, fd263;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd240, fd263;
fma.rn.f64 fd273, fd241, fd261, fd272;
mul.f64 fd274, fd225, fd273;
fma.rn.f64 fd275, fd271, fd224, fd274;
mul.f64 fd276, fd224, fd273;
mul.f64 fd277, fd271, fd225;
sub.f64 fd278, fd277, fd276;
mul.f64 fd279, fd240, fd271;
mul.f64 fd280, fd241, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd240, fd273;
fma.rn.f64 fd283, fd241, fd271, fd282;
mul.f64 fd284, fd229, fd283;
fma.rn.f64 fd285, fd281, fd228, fd284;
mul.f64 fd286, fd228, fd283;
mul.f64 fd287, fd281, fd229;
sub.f64 fd288, fd287, fd286;
mul.f64 fd289, fd240, fd281;
mul.f64 fd290, fd241, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd240, fd283;
fma.rn.f64 fd293, fd241, fd281, fd292;
mul.f64 fd294, fd233, fd293;
fma.rn.f64 fd295, fd291, fd232, fd294;
mul.f64 fd296, fd232, fd293;
mul.f64 fd297, fd291, fd233;
sub.f64 fd298, fd297, fd296;
mul.f64 fd299, fd240, fd291;
mul.f64 fd300, fd241, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd240, fd293;
fma.rn.f64 fd303, fd241, fd291, fd302;
mul.f64 fd304, fd237, fd303;
fma.rn.f64 fd305, fd301, fd236, fd304;
mul.f64 fd306, fd236, fd303;
mul.f64 fd307, fd301, fd237;
sub.f64 fd308, fd307, fd306;
mul.f64 fd309, fd240, fd301;
mul.f64 fd310, fd241, fd303;
sub.f64 fd311, fd309, fd310;
mul.f64 fd312, fd240, fd303;
fma.rn.f64 fd313, fd241, fd301, fd312;
mul.f64 fd314, fd211, fd313;
fma.rn.f64 fd315, fd311, fd210, fd314;
mul.f64 fd316, fd210, fd313;
mul.f64 fd317, fd311, fd211;
sub.f64 fd318, fd317, fd316;
ld.global.v2.f64 {fd319, fd320}, [rd5+1024];
mul.f64 fd323, fd215, fd320;
fma.rn.f64 fd324, fd319, fd214, fd323;
mul.f64 fd325, fd214, fd320;
mul.f64 fd326, fd319, fd215;
sub.f64 fd327, fd326, fd325;
mul.f64 fd328, fd240, fd319;
mul.f64 fd329, fd241, fd320;
sub.f64 fd330, fd328, fd329;
mul.f64 fd331, fd240, fd320;
fma.rn.f64 fd332, fd241, fd319, fd331;
mul.f64 fd333, fd219, fd332;
fma.rn.f64 fd334, fd330, fd218, fd333;
mul.f64 fd335, fd218, fd332;
mul.f64 fd336, fd330, fd219;
sub.f64 fd337, fd336, fd335;
mul.f64 fd338, fd240, fd330;
mul.f64 fd339, fd241, fd332;
sub.f64 fd340, fd338, fd339;
mul.f64 fd341, fd240, fd332;
fma.rn.f64 fd342, fd241, fd330, fd341;
mul.f64 fd343, fd223, fd342;
fma.rn.f64 fd344, fd340, fd222, fd343;
mul.f64 fd345, fd222, fd342;
mul.f64 fd346, fd340, fd223;
sub.f64 fd347, fd346, fd345;
mul.f64 fd348, fd240, fd340;
mul.f64 fd349, fd241, fd342;
sub.f64 fd350, fd348, fd349;
mul.f64 fd351, fd240, fd342;
fma.rn.f64 fd352, fd241, fd340, fd351;
mul.f64 fd353, fd227, fd352;
fma.rn.f64 fd354, fd350, fd226, fd353;
mul.f64 fd355, fd226, fd352;
mul.f64 fd356, fd350, fd227;
sub.f64 fd357, fd356, fd355;
mul.f64 fd358, fd240, fd350;
mul.f64 fd359, fd241, fd352;
sub.f64 fd360, fd358, fd359;
mul.f64 fd361, fd240, fd352;
fma.rn.f64 fd362, fd241, fd350, fd361;
mul.f64 fd363, fd231, fd362;
fma.rn.f64 fd364, fd360, fd230, fd363;
mul.f64 fd365, fd230, fd362;
mul.f64 fd366, fd360, fd231;
sub.f64 fd367, fd366, fd365;
mul.f64 fd368, fd240, fd360;
mul.f64 fd369, fd241, fd362;
sub.f64 fd370, fd368, fd369;
mul.f64 fd371, fd240, fd362;
fma.rn.f64 fd372, fd241, fd360, fd371;
mul.f64 fd373, fd235, fd372;
fma.rn.f64 fd374, fd370, fd234, fd373;
mul.f64 fd375, fd234, fd372;
mul.f64 fd376, fd370, fd235;
sub.f64 fd377, fd376, fd375;
mul.f64 fd378, fd240, fd370;
mul.f64 fd379, fd241, fd372;
sub.f64 fd380, fd378, fd379;
mul.f64 fd381, fd240, fd372;
fma.rn.f64 fd382, fd241, fd370, fd381;
mul.f64 fd383, fd239, fd382;
fma.rn.f64 fd384, fd380, fd238, fd383;
mul.f64 fd385, fd238, fd382;
mul.f64 fd386, fd380, fd239;
sub.f64 fd387, fd386, fd385;
shl.b32 r8, r5, 7;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8064;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd208, fd245};
st.shared.v2.f64 [r12+16], {fd255, fd265};
st.shared.v2.f64 [r12+32], {fd275, fd285};
st.shared.v2.f64 [r12+48], {fd295, fd305};
st.shared.v2.f64 [r12+64], {fd315, fd324};
st.shared.v2.f64 [r12+80], {fd334, fd344};
st.shared.v2.f64 [r12+96], {fd354, fd364};
st.shared.v2.f64 [r12+112], {fd374, fd384};
barrier.sync 0;
mad.lo.s32 r13, r6, -120, r12;
ld.shared.f64 fd388, [r13];
ld.shared.f64 fd389, [r13+512];
ld.shared.f64 fd390, [r13+1024];
ld.shared.f64 fd391, [r13+1536];
ld.shared.f64 fd392, [r13+2048];
ld.shared.f64 fd393, [r13+2560];
ld.shared.f64 fd394, [r13+3072];
ld.shared.f64 fd395, [r13+3584];
ld.shared.f64 fd396, [r13+4096];
ld.shared.f64 fd397, [r13+4608];
ld.shared.f64 fd398, [r13+5120];
ld.shared.f64 fd399, [r13+5632];
ld.shared.f64 fd400, [r13+6144];
ld.shared.f64 fd401, [r13+6656];
ld.shared.f64 fd402, [r13+7168];
ld.shared.f64 fd403, [r13+7680];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd209, fd248};
st.shared.v2.f64 [r12+16], {fd258, fd268};
st.shared.v2.f64 [r12+32], {fd278, fd288};
st.shared.v2.f64 [r12+48], {fd298, fd308};
st.shared.v2.f64 [r12+64], {fd318, fd327};
st.shared.v2.f64 [r12+80], {fd337, fd347};
st.shared.v2.f64 [r12+96], {fd357, fd367};
st.shared.v2.f64 [r12+112], {fd377, fd387};
barrier.sync 0;
ld.shared.f64 fd404, [r13];
ld.shared.f64 fd405, [r13+512];
ld.shared.f64 fd406, [r13+1024];
ld.shared.f64 fd407, [r13+1536];
ld.shared.f64 fd408, [r13+2048];
ld.shared.f64 fd409, [r13+2560];
ld.shared.f64 fd410, [r13+3072];
ld.shared.f64 fd411, [r13+3584];
ld.shared.f64 fd412, [r13+4096];
ld.shared.f64 fd413, [r13+4608];
ld.shared.f64 fd414, [r13+5120];
ld.shared.f64 fd415, [r13+5632];
ld.shared.f64 fd416, [r13+6144];
ld.shared.f64 fd417, [r13+6656];
ld.shared.f64 fd418, [r13+7168];
ld.shared.f64 fd419, [r13+7680];
add.f64 fd420, fd388, fd396;
add.f64 fd421, fd404, fd412;
sub.f64 fd422, fd388, fd396;
sub.f64 fd423, fd404, fd412;
add.f64 fd424, fd392, fd400;
add.f64 fd425, fd408, fd416;
sub.f64 fd426, fd392, fd400;
sub.f64 fd427, fd408, fd416;
add.f64 fd428, fd420, fd424;
add.f64 fd429, fd421, fd425;
sub.f64 fd430, fd420, fd424;
sub.f64 fd431, fd421, fd425;
sub.f64 fd432, fd422, fd427;
add.f64 fd433, fd423, fd426;
add.f64 fd434, fd422, fd427;
sub.f64 fd435, fd423, fd426;
add.f64 fd436, fd390, fd398;
add.f64 fd437, fd406, fd414;
sub.f64 fd438, fd390, fd398;
sub.f64 fd439, fd406, fd414;
add.f64 fd440, fd394, fd402;
add.f64 fd441, fd410, fd418;
sub.f64 fd442, fd394, fd402;
sub.f64 fd443, fd410, fd418;
add.f64 fd444, fd436, fd440;
add.f64 fd445, fd437, fd441;
sub.f64 fd446, fd436, fd440;
sub.f64 fd447, fd437, fd441;
sub.f64 fd448, fd438, fd443;
add.f64 fd449, fd439, fd442;
add.f64 fd450, fd438, fd443;
sub.f64 fd451, fd439, fd442;
mul.f64 fd452, fd448, 0d3FE6A09E667F3BCD;
mul.f64 fd453, fd449, 0d3FE6A09E667F3BCD;
sub.f64 fd454, fd452, fd453;
add.f64 fd455, fd452, fd453;
mul.f64 fd456, fd450, 0dBFE6A09E667F3BCD;
mul.f64 fd457, fd451, 0d3FE6A09E667F3BCD;
sub.f64 fd458, fd456, fd457;
mul.f64 fd459, fd451, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd460, fd450, 0d3FE6A09E667F3BCD, fd459;
add.f64 fd461, fd428, fd444;
add.f64 fd462, fd429, fd445;
sub.f64 fd463, fd428, fd444;
sub.f64 fd464, fd429, fd445;
add.f64 fd465, fd432, fd454;
add.f64 fd466, fd433, fd455;
sub.f64 fd467, fd432, fd454;
sub.f64 fd468, fd433, fd455;
sub.f64 fd469, fd430, fd447;
add.f64 fd470, fd431, fd446;
add.f64 fd471, fd430, fd447;
sub.f64 fd472, fd431, fd446;
add.f64 fd473, fd434, fd458;
add.f64 fd474, fd435, fd460;
sub.f64 fd475, fd434, fd458;
sub.f64 fd476, fd435, fd460;
add.f64 fd477, fd389, fd397;
add.f64 fd478, fd405, fd413;
sub.f64 fd479, fd389, fd397;
sub.f64 fd480, fd405, fd413;
add.f64 fd481, fd393, fd401;
add.f64 fd482, fd409, fd417;
sub.f64 fd483, fd393, fd401;
sub.f64 fd484, fd409, fd417;
add.f64 fd485, fd477, fd481;
add.f64 fd486, fd478, fd482;
sub.f64 fd487, fd477, fd481;
sub.f64 fd488, fd478, fd482;
sub.f64 fd489, fd479, fd484;
add.f64 fd490, fd480, fd483;
add.f64 fd491, fd479, fd484;
sub.f64 fd492, fd480, fd483;
add.f64 fd493, fd391, fd399;
add.f64 fd494, fd407, fd415;
sub.f64 fd495, fd391, fd399;
sub.f64 fd496, fd407, fd415;
add.f64 fd497, fd395, fd403;
add.f64 fd498, fd411, fd419;
sub.f64 fd499, fd395, fd403;
sub.f64 fd500, fd411, fd419;
add.f64 fd501, fd493, fd497;
add.f64 fd502, fd494, fd498;
sub.f64 fd503, fd493, fd497;
sub.f64 fd504, fd494, fd498;
sub.f64 fd505, fd495, fd500;
add.f64 fd506, fd496, fd499;
add.f64 fd507, fd495, fd500;
sub.f64 fd508, fd496, fd499;
mul.f64 fd509, fd505, 0d3FE6A09E667F3BCD;
mul.f64 fd510, fd506, 0d3FE6A09E667F3BCD;
sub.f64 fd511, fd509, fd510;
add.f64 fd512, fd509, fd510;
mul.f64 fd513, fd507, 0dBFE6A09E667F3BCD;
mul.f64 fd514, fd508, 0d3FE6A09E667F3BCD;
sub.f64 fd515, fd513, fd514;
mul.f64 fd516, fd508, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd517, fd507, 0d3FE6A09E667F3BCD, fd516;
add.f64 fd518, fd485, fd501;
add.f64 fd519, fd486, fd502;
sub.f64 fd520, fd485, fd501;
sub.f64 fd521, fd486, fd502;
add.f64 fd522, fd489, fd511;
add.f64 fd523, fd490, fd512;
sub.f64 fd524, fd489, fd511;
sub.f64 fd525, fd490, fd512;
sub.f64 fd526, fd487, fd504;
add.f64 fd527, fd488, fd503;
add.f64 fd528, fd487, fd504;
sub.f64 fd529, fd488, fd503;
add.f64 fd530, fd491, fd515;
add.f64 fd531, fd492, fd517;
sub.f64 fd532, fd491, fd515;
sub.f64 fd533, fd492, fd517;
mul.f64 fd534, fd522, 0d3FED906BCF328D46;
mul.f64 fd535, fd523, 0d3FD87DE2A6AEA963;
sub.f64 fd536, fd534, fd535;
mul.f64 fd537, fd523, 0d3FED906BCF328D46;
fma.rn.f64 fd538, fd522, 0d3FD87DE2A6AEA963, fd537;
mul.f64 fd539, fd526, 0d3FE6A09E667F3BCD;
mul.f64 fd540, fd527, 0d3FE6A09E667F3BCD;
sub.f64 fd541, fd539, fd540;
add.f64 fd542, fd539, fd540;
mul.f64 fd543, fd530, 0d3FD87DE2A6AEA963;
mul.f64 fd544, fd531, 0d3FED906BCF328D46;
sub.f64 fd545, fd543, fd544;
mul.f64 fd546, fd531, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd547, fd530, 0d3FED906BCF328D46, fd546;
mul.f64 fd548, fd524, 0dBFD87DE2A6AEA963;
mul.f64 fd549, fd525, 0d3FED906BCF328D46;
sub.f64 fd550, fd548, fd549;
mul.f64 fd551, fd525, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd552, fd524, 0d3FED906BCF328D46, fd551;
mul.f64 fd553, fd528, 0dBFE6A09E667F3BCD;
mul.f64 fd554, fd529, 0d3FE6A09E667F3BCD;
sub.f64 fd555, fd553, fd554;
mul.f64 fd556, fd529, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd557, fd528, 0d3FE6A09E667F3BCD, fd556;
mul.f64 fd558, fd532, 0dBFED906BCF328D46;
mul.f64 fd559, fd533, 0d3FD87DE2A6AEA963;
sub.f64 fd560, fd558, fd559;
mul.f64 fd561, fd533, 0dBFED906BCF328D46;
fma.rn.f64 fd562, fd532, 0d3FD87DE2A6AEA963, fd561;
add.f64 fd563, fd461, fd518;
add.f64 fd564, fd462, fd519;
sub.f64 fd565, fd461, fd518;
sub.f64 fd566, fd462, fd519;
add.f64 fd567, fd465, fd536;
add.f64 fd568, fd466, fd538;
sub.f64 fd569, fd465, fd536;
sub.f64 fd570, fd466, fd538;
add.f64 fd571, fd469, fd541;
add.f64 fd572, fd470, fd542;
sub.f64 fd573, fd469, fd541;
sub.f64 fd574, fd470, fd542;
add.f64 fd575, fd473, fd545;
add.f64 fd576, fd474, fd547;
sub.f64 fd577, fd473, fd545;
sub.f64 fd578, fd474, fd547;
sub.f64 fd579, fd463, fd521;
add.f64 fd580, fd464, fd520;
add.f64 fd581, fd463, fd521;
sub.f64 fd582, fd464, fd520;
add.f64 fd583, fd467, fd550;
add.f64 fd584, fd468, fd552;
sub.f64 fd585, fd467, fd550;
sub.f64 fd586, fd468, fd552;
add.f64 fd587, fd471, fd555;
add.f64 fd588, fd472, fd557;
sub.f64 fd589, fd471, fd555;
sub.f64 fd590, fd472, fd557;
add.f64 fd591, fd475, fd560;
add.f64 fd592, fd476, fd562;
sub.f64 fd593, fd475, fd560;
sub.f64 fd594, fd476, fd562;
and.b32 r14, r5, 48;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %34;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd595, fd596}, [rd8];
mul.f64 fd599, fd568, fd596;
fma.rn.f64 fd600, fd595, fd567, fd599;
mul.f64 fd601, fd567, fd596;
mul.f64 fd602, fd595, fd568;
sub.f64 fd603, fd602, fd601;
mul.f64 fd604, fd595, fd595;
mul.f64 fd605, fd596, fd596;
sub.f64 fd606, fd604, fd605;
mul.f64 fd607, fd596, fd595;
fma.rn.f64 fd608, fd596, fd595, fd607;
mul.f64 fd609, fd572, fd608;
fma.rn.f64 fd610, fd606, fd571, fd609;
mul.f64 fd611, fd571, fd608;
mul.f64 fd612, fd606, fd572;
sub.f64 fd613, fd612, fd611;
mul.f64 fd614, fd595, fd606;
mul.f64 fd615, fd596, fd608;
sub.f64 fd616, fd614, fd615;
mul.f64 fd617, fd595, fd608;
fma.rn.f64 fd618, fd596, fd606, fd617;
mul.f64 fd619, fd576, fd618;
fma.rn.f64 fd620, fd616, fd575, fd619;
mul.f64 fd621, fd575, fd618;
mul.f64 fd622, fd616, fd576;
sub.f64 fd623, fd622, fd621;
mul.f64 fd624, fd595, fd616;
mul.f64 fd625, fd596, fd618;
sub.f64 fd626, fd624, fd625;
mul.f64 fd627, fd595, fd618;
fma.rn.f64 fd628, fd596, fd616, fd627;
mul.f64 fd629, fd580, fd628;
fma.rn.f64 fd630, fd626, fd579, fd629;
mul.f64 fd631, fd579, fd628;
mul.f64 fd632, fd626, fd580;
sub.f64 fd633, fd632, fd631;
mul.f64 fd634, fd595, fd626;
mul.f64 fd635, fd596, fd628;
sub.f64 fd636, fd634, fd635;
mul.f64 fd637, fd595, fd628;
fma.rn.f64 fd638, fd596, fd626, fd637;
mul.f64 fd639, fd584, fd638;
fma.rn.f64 fd640, fd636, fd583, fd639;
mul.f64 fd641, fd583, fd638;
mul.f64 fd642, fd636, fd584;
sub.f64 fd643, fd642, fd641;
mul.f64 fd644, fd595, fd636;
mul.f64 fd645, fd596, fd638;
sub.f64 fd646, fd644, fd645;
mul.f64 fd647, fd595, fd638;
fma.rn.f64 fd648, fd596, fd636, fd647;
mul.f64 fd649, fd588, fd648;
fma.rn.f64 fd650, fd646, fd587, fd649;
mul.f64 fd651, fd587, fd648;
mul.f64 fd652, fd646, fd588;
sub.f64 fd653, fd652, fd651;
mul.f64 fd654, fd595, fd646;
mul.f64 fd655, fd596, fd648;
sub.f64 fd656, fd654, fd655;
mul.f64 fd657, fd595, fd648;
fma.rn.f64 fd658, fd596, fd646, fd657;
mul.f64 fd659, fd592, fd658;
fma.rn.f64 fd660, fd656, fd591, fd659;
mul.f64 fd661, fd591, fd658;
mul.f64 fd662, fd656, fd592;
sub.f64 fd663, fd662, fd661;
mul.f64 fd664, fd595, fd656;
mul.f64 fd665, fd596, fd658;
sub.f64 fd666, fd664, fd665;
mul.f64 fd667, fd595, fd658;
fma.rn.f64 fd668, fd596, fd656, fd667;
mul.f64 fd669, fd566, fd668;
fma.rn.f64 fd670, fd666, fd565, fd669;
mul.f64 fd671, fd565, fd668;
mul.f64 fd672, fd666, fd566;
sub.f64 fd673, fd672, fd671;
ld.global.v2.f64 {fd674, fd675}, [rd8+64];
mul.f64 fd678, fd570, fd675;
fma.rn.f64 fd679, fd674, fd569, fd678;
mul.f64 fd680, fd569, fd675;
mul.f64 fd681, fd674, fd570;
sub.f64 fd682, fd681, fd680;
mul.f64 fd683, fd595, fd674;
mul.f64 fd684, fd596, fd675;
sub.f64 fd685, fd683, fd684;
mul.f64 fd686, fd595, fd675;
fma.rn.f64 fd687, fd596, fd674, fd686;
mul.f64 fd688, fd574, fd687;
fma.rn.f64 fd689, fd685, fd573, fd688;
mul.f64 fd690, fd573, fd687;
mul.f64 fd691, fd685, fd574;
sub.f64 fd692, fd691, fd690;
mul.f64 fd693, fd595, fd685;
mul.f64 fd694, fd596, fd687;
sub.f64 fd695, fd693, fd694;
mul.f64 fd696, fd595, fd687;
fma.rn.f64 fd697, fd596, fd685, fd696;
mul.f64 fd698, fd578, fd697;
fma.rn.f64 fd699, fd695, fd577, fd698;
mul.f64 fd700, fd577, fd697;
mul.f64 fd701, fd695, fd578;
sub.f64 fd702, fd701, fd700;
mul.f64 fd703, fd595, fd695;
mul.f64 fd704, fd596, fd697;
sub.f64 fd705, fd703, fd704;
mul.f64 fd706, fd595, fd697;
fma.rn.f64 fd707, fd596, fd695, fd706;
mul.f64 fd708, fd582, fd707;
fma.rn.f64 fd709, fd705, fd581, fd708;
mul.f64 fd710, fd581, fd707;
mul.f64 fd711, fd705, fd582;
sub.f64 fd712, fd711, fd710;
mul.f64 fd713, fd595, fd705;
mul.f64 fd714, fd596, fd707;
sub.f64 fd715, fd713, fd714;
mul.f64 fd716, fd595, fd707;
fma.rn.f64 fd717, fd596, fd705, fd716;
mul.f64 fd718, fd586, fd717;
fma.rn.f64 fd719, fd715, fd585, fd718;
mul.f64 fd720, fd585, fd717;
mul.f64 fd721, fd715, fd586;
sub.f64 fd722, fd721, fd720;
mul.f64 fd723, fd595, fd715;
mul.f64 fd724, fd596, fd717;
sub.f64 fd725, fd723, fd724;
mul.f64 fd726, fd595, fd717;
fma.rn.f64 fd727, fd596, fd715, fd726;
mul.f64 fd728, fd590, fd727;
fma.rn.f64 fd729, fd725, fd589, fd728;
mul.f64 fd730, fd589, fd727;
mul.f64 fd731, fd725, fd590;
sub.f64 fd732, fd731, fd730;
mul.f64 fd733, fd595, fd725;
mul.f64 fd734, fd596, fd727;
sub.f64 fd735, fd733, fd734;
mul.f64 fd736, fd595, fd727;
fma.rn.f64 fd737, fd596, fd725, fd736;
mul.f64 fd738, fd594, fd737;
fma.rn.f64 fd739, fd735, fd593, fd738;
mul.f64 fd740, fd593, fd737;
mul.f64 fd741, fd735, fd594;
sub.f64 fd742, fd741, fd740;
shl.b32 r15, r5, 3;
and.b32 r16, r15, 120;
add.s32 r17, r10, r16;
barrier.sync 0;
and.b32 r18, r8, 6144;
add.s32 r19, r17, r18;
st.shared.f64 [r19], fd563;
st.shared.f64 [r19+128], fd600;
st.shared.f64 [r19+256], fd610;
st.shared.f64 [r19+384], fd620;
st.shared.f64 [r19+512], fd630;
st.shared.f64 [r19+640], fd640;
st.shared.f64 [r19+768], fd650;
st.shared.f64 [r19+896], fd660;
st.shared.f64 [r19+1024], fd670;
st.shared.f64 [r19+1152], fd679;
st.shared.f64 [r19+1280], fd689;
st.shared.f64 [r19+1408], fd699;
st.shared.f64 [r19+1536], fd709;
st.shared.f64 [r19+1664], fd719;
st.shared.f64 [r19+1792], fd729;
st.shared.f64 [r19+1920], fd739;
barrier.sync 0;
mad.lo.s32 r20, r14, -120, r19;
ld.shared.f64 fd743, [r20];
ld.shared.f64 fd744, [r20+512];
ld.shared.f64 fd745, [r20+1024];
ld.shared.f64 fd746, [r20+1536];
ld.shared.f64 fd747, [r20+2048];
ld.shared.f64 fd748, [r20+2560];
ld.shared.f64 fd749, [r20+3072];
ld.shared.f64 fd750, [r20+3584];
ld.shared.f64 fd751, [r20+4096];
ld.shared.f64 fd752, [r20+4608];
ld.shared.f64 fd753, [r20+5120];
ld.shared.f64 fd754, [r20+5632];
ld.shared.f64 fd755, [r20+6144];
ld.shared.f64 fd756, [r20+6656];
ld.shared.f64 fd757, [r20+7168];
ld.shared.f64 fd758, [r20+7680];
barrier.sync 0;
st.shared.f64 [r19], fd564;
st.shared.f64 [r19+128], fd603;
st.shared.f64 [r19+256], fd613;
st.shared.f64 [r19+384], fd623;
st.shared.f64 [r19+512], fd633;
st.shared.f64 [r19+640], fd643;
st.shared.f64 [r19+768], fd653;
st.shared.f64 [r19+896], fd663;
st.shared.f64 [r19+1024], fd673;
st.shared.f64 [r19+1152], fd682;
st.shared.f64 [r19+1280], fd692;
st.shared.f64 [r19+1408], fd702;
st.shared.f64 [r19+1536], fd712;
st.shared.f64 [r19+1664], fd722;
st.shared.f64 [r19+1792], fd732;
st.shared.f64 [r19+1920], fd742;
barrier.sync 0;
ld.shared.f64 fd759, [r20];
ld.shared.f64 fd760, [r20+512];
ld.shared.f64 fd761, [r20+1024];
ld.shared.f64 fd762, [r20+1536];
ld.shared.f64 fd763, [r20+2048];
ld.shared.f64 fd764, [r20+2560];
ld.shared.f64 fd765, [r20+3072];
ld.shared.f64 fd766, [r20+3584];
ld.shared.f64 fd767, [r20+4096];
ld.shared.f64 fd768, [r20+4608];
ld.shared.f64 fd769, [r20+5120];
ld.shared.f64 fd770, [r20+5632];
ld.shared.f64 fd771, [r20+6144];
ld.shared.f64 fd772, [r20+6656];
ld.shared.f64 fd773, [r20+7168];
ld.shared.f64 fd774, [r20+7680];
add.f64 fd775, fd743, fd751;
add.f64 fd776, fd759, fd767;
sub.f64 fd777, fd743, fd751;
sub.f64 fd778, fd759, fd767;
add.f64 fd779, fd747, fd755;
add.f64 fd780, fd763, fd771;
sub.f64 fd781, fd747, fd755;
sub.f64 fd782, fd763, fd771;
add.f64 fd783, fd744, fd752;
add.f64 fd784, fd760, fd768;
sub.f64 fd785, fd744, fd752;
sub.f64 fd786, fd760, fd768;
add.f64 fd787, fd748, fd756;
add.f64 fd788, fd764, fd772;
sub.f64 fd789, fd748, fd756;
sub.f64 fd790, fd764, fd772;
add.f64 fd791, fd745, fd753;
add.f64 fd792, fd761, fd769;
sub.f64 fd793, fd745, fd753;
sub.f64 fd794, fd761, fd769;
add.f64 fd795, fd749, fd757;
add.f64 fd796, fd765, fd773;
sub.f64 fd797, fd749, fd757;
sub.f64 fd798, fd765, fd773;
add.f64 fd799, fd746, fd754;
add.f64 fd800, fd762, fd770;
sub.f64 fd801, fd746, fd754;
sub.f64 fd802, fd762, fd770;
add.f64 fd803, fd750, fd758;
add.f64 fd804, fd766, fd774;
sub.f64 fd805, fd750, fd758;
sub.f64 fd806, fd766, fd774;
add.f64 %0, fd775, fd779;
add.f64 %1, fd776, fd780;
add.f64 %2, fd783, fd787;
add.f64 %3, fd784, fd788;
add.f64 %4, fd791, fd795;
add.f64 %5, fd792, fd796;
add.f64 %6, fd799, fd803;
add.f64 %7, fd800, fd804;
add.f64 %9, fd778, fd781;
sub.f64 %8, fd777, fd782;
add.f64 %11, fd786, fd789;
sub.f64 %10, fd785, fd790;
add.f64 %13, fd794, fd797;
sub.f64 %12, fd793, fd798;
add.f64 %15, fd802, fd805;
sub.f64 %14, fd801, fd806;
sub.f64 %16, fd775, fd779;
sub.f64 %17, fd776, fd780;
sub.f64 %18, fd783, fd787;
sub.f64 %19, fd784, fd788;
sub.f64 %20, fd791, fd795;
sub.f64 %21, fd792, fd796;
sub.f64 %22, fd799, fd803;
sub.f64 %23, fd800, fd804;
sub.f64 %25, fd778, fd781;
add.f64 %24, fd777, fd782;
sub.f64 %27, fd786, fd789;
add.f64 %26, fd785, fd790;
sub.f64 %29, fd794, fd797;
add.f64 %28, fd793, fd798;
sub.f64 %31, fd802, fd805;
add.f64 %30, fd801, fd806;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_1024), "l"(lut_dp_16_64), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<651, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<40>;
.reg .f64 fd<1092>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f64 fd65, %35, %51;
sub.f64 fd67, %35, %51;
add.f64 fd1083, %36, %67;
sub.f64 fd68, %36, %67;
add.f64 fd69, %43, %59;
sub.f64 fd71, %43, %59;
add.f64 fd1081, %68, %60;
sub.f64 fd72, %68, %60;
add.f64 fd73, fd65, fd69;
sub.f64 fd75, fd65, fd69;
add.f64 fd1080, fd1083, fd1081;
sub.f64 fd76, fd1083, fd1081;
sub.f64 fd77, fd67, fd72;
add.f64 fd79, fd67, fd72;
add.f64 fd1079, fd68, fd71;
sub.f64 fd80, fd68, fd71;
add.f64 fd81, %39, %55;
sub.f64 fd83, %39, %55;
add.f64 fd1076, %70, %69;
sub.f64 fd84, %70, %69;
add.f64 fd85, %47, %63;
sub.f64 fd87, %47, %63;
add.f64 fd1074, %48, %71;
sub.f64 fd88, %48, %71;
add.f64 fd89, fd81, fd85;
sub.f64 fd91, fd81, fd85;
add.f64 fd1073, fd1076, fd1074;
sub.f64 fd92, fd1076, fd1074;
sub.f64 fd93, fd83, fd88;
add.f64 fd95, fd83, fd88;
add.f64 fd1072, fd84, fd87;
sub.f64 fd96, fd84, fd87;
mul.f64 fd97, fd93, 0d3FE6A09E667F3BCD;
mul.f64 fd98, fd1072, 0d3FE6A09E667F3BCD;
sub.f64 fd99, fd97, fd98;
add.f64 fd100, fd97, fd98;
mul.f64 fd1070, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd1071, fd96, 0d3FE6A09E667F3BCD;
sub.f64 fd103, fd1070, fd1071;
mul.f64 fd104, fd96, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd105, fd95, 0d3FE6A09E667F3BCD, fd104;
add.f64 fd106, fd73, fd89;
sub.f64 fd108, fd73, fd89;
add.f64 fd1069, fd1080, fd1073;
sub.f64 fd109, fd1080, fd1073;
add.f64 fd110, fd77, fd99;
sub.f64 fd112, fd77, fd99;
add.f64 fd1068, fd1079, fd100;
sub.f64 fd113, fd1079, fd100;
sub.f64 fd114, fd75, fd92;
add.f64 fd116, fd75, fd92;
add.f64 fd1067, fd76, fd91;
sub.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd103;
sub.f64 fd120, fd79, fd103;
add.f64 fd1066, fd80, fd105;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %37, %53;
sub.f64 fd124, %37, %53;
add.f64 fd1064, %72, %54;
sub.f64 fd125, %72, %54;
add.f64 fd126, %45, %61;
sub.f64 fd128, %45, %61;
add.f64 fd1061, %73, %74;
sub.f64 fd129, %73, %74;
add.f64 fd130, fd122, fd126;
sub.f64 fd132, fd122, fd126;
add.f64 fd1060, fd1064, fd1061;
sub.f64 fd133, fd1064, fd1061;
sub.f64 fd134, fd124, fd129;
add.f64 fd136, fd124, fd129;
add.f64 fd1059, fd125, fd128;
sub.f64 fd137, fd125, fd128;
add.f64 fd138, %41, %57;
sub.f64 fd140, %41, %57;
add.f64 fd1057, %42, %75;
sub.f64 fd141, %42, %75;
add.f64 fd142, %49, %65;
sub.f64 fd144, %49, %65;
add.f64 fd1055, %76, %66;
sub.f64 fd145, %76, %66;
add.f64 fd146, fd138, fd142;
sub.f64 fd148, fd138, fd142;
add.f64 fd1054, fd1057, fd1055;
sub.f64 fd149, fd1057, fd1055;
sub.f64 fd150, fd140, fd145;
add.f64 fd152, fd140, fd145;
add.f64 fd1053, fd141, fd144;
sub.f64 fd153, fd141, fd144;
mul.f64 fd154, fd150, 0d3FE6A09E667F3BCD;
mul.f64 fd155, fd1053, 0d3FE6A09E667F3BCD;
sub.f64 fd156, fd154, fd155;
add.f64 fd157, fd154, fd155;
mul.f64 fd1051, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd1052, fd153, 0d3FE6A09E667F3BCD;
sub.f64 fd160, fd1051, fd1052;
mul.f64 fd161, fd153, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd162, fd152, 0d3FE6A09E667F3BCD, fd161;
add.f64 fd163, fd130, fd146;
sub.f64 fd165, fd130, fd146;
add.f64 fd1050, fd1060, fd1054;
sub.f64 fd166, fd1060, fd1054;
add.f64 fd167, fd134, fd156;
sub.f64 fd169, fd134, fd156;
add.f64 fd1049, fd1059, fd157;
sub.f64 fd170, fd1059, fd157;
sub.f64 fd171, fd132, fd149;
add.f64 fd173, fd132, fd149;
add.f64 fd1048, fd133, fd148;
sub.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd160;
sub.f64 fd177, fd136, fd160;
add.f64 fd1047, fd137, fd162;
sub.f64 fd178, fd137, fd162;
mul.f64 fd1045, fd167, 0d3FED906BCF328D46;
mul.f64 fd1046, fd1049, 0d3FD87DE2A6AEA963;
sub.f64 fd181, fd1045, fd1046;
mul.f64 fd182, fd1049, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0d3FD87DE2A6AEA963, fd182;
mul.f64 fd184, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd185, fd1048, 0d3FE6A09E667F3BCD;
sub.f64 fd186, fd184, fd185;
add.f64 fd187, fd184, fd185;
mul.f64 fd189, fd1047, 0d3FED906BCF328D46;
mul.f64 fd1044, fd175, 0d3FD87DE2A6AEA963;
sub.f64 fd190, fd1044, fd189;
mul.f64 fd191, fd1047, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd192, fd175, 0d3FED906BCF328D46, fd191;
mul.f64 fd194, fd170, 0d3FED906BCF328D46;
mul.f64 fd1043, fd169, 0dBFD87DE2A6AEA963;
sub.f64 fd195, fd1043, fd194;
mul.f64 fd196, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd197, fd169, 0d3FED906BCF328D46, fd196;
mul.f64 fd1041, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd1042, fd174, 0d3FE6A09E667F3BCD;
sub.f64 fd200, fd1041, fd1042;
mul.f64 fd201, fd174, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd202, fd173, 0d3FE6A09E667F3BCD, fd201;
mul.f64 fd1039, fd177, 0dBFED906BCF328D46;
mul.f64 fd1040, fd178, 0d3FD87DE2A6AEA963;
sub.f64 fd205, fd1039, fd1040;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0d3FD87DE2A6AEA963, fd206;
add.f64 fd210, fd110, fd181;
sub.f64 fd212, fd110, fd181;
add.f64 fd1038, fd1068, fd183;
sub.f64 fd213, fd1068, fd183;
add.f64 fd214, fd114, fd186;
sub.f64 fd216, fd114, fd186;
add.f64 fd1037, fd1067, fd187;
sub.f64 fd217, fd1067, fd187;
add.f64 fd218, fd118, fd190;
sub.f64 fd220, fd118, fd190;
add.f64 fd1036, fd1066, fd192;
sub.f64 fd221, fd1066, fd192;
sub.f64 fd222, fd108, fd166;
add.f64 fd224, fd108, fd166;
add.f64 fd1035, fd109, fd165;
sub.f64 fd225, fd109, fd165;
add.f64 fd226, fd112, fd195;
sub.f64 fd228, fd112, fd195;
add.f64 fd1034, fd113, fd197;
sub.f64 fd229, fd113, fd197;
add.f64 fd230, fd116, fd200;
sub.f64 fd232, fd116, fd200;
add.f64 fd1033, fd117, fd202;
sub.f64 fd233, fd117, fd202;
add.f64 fd234, fd120, fd205;
sub.f64 fd236, fd120, fd205;
add.f64 fd1032, fd121, fd207;
sub.f64 fd237, fd121, fd207;
mov.u32 r21, %tid.x;
shl.b32 r7, r21, 8;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r21, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 1008;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd238, fd239}, [rd5];
mul.f64 fd242, fd1038, fd239;
mul.f64 fd244, fd238, fd1038;
mul.f64 fd246, fd239, fd239;
mul.f64 fd1031, fd238, fd238;
sub.f64 fd247, fd1031, fd246;
mul.f64 fd248, fd239, fd238;
fma.rn.f64 fd249, fd239, fd238, fd248;
mul.f64 fd250, fd1037, fd249;
mul.f64 fd252, fd247, fd1037;
mul.f64 fd1029, fd238, fd247;
mul.f64 fd1030, fd239, fd249;
sub.f64 fd255, fd1029, fd1030;
mul.f64 fd1028, fd214, fd249;
mul.f64 fd256, fd238, fd249;
fma.rn.f64 fd257, fd239, fd247, fd256;
mul.f64 fd258, fd1036, fd257;
mul.f64 fd260, fd255, fd1036;
mul.f64 fd262, fd239, fd257;
mul.f64 fd1027, fd238, fd255;
sub.f64 fd263, fd1027, fd262;
mul.f64 fd1026, fd218, fd257;
mul.f64 fd264, fd238, fd257;
fma.rn.f64 fd265, fd239, fd255, fd264;
mul.f64 fd266, fd1035, fd265;
mul.f64 fd268, fd263, fd1035;
mul.f64 fd270, fd239, fd265;
mul.f64 fd1025, fd238, fd263;
sub.f64 fd271, fd1025, fd270;
mul.f64 fd1024, fd222, fd265;
mul.f64 fd272, fd238, fd265;
fma.rn.f64 fd273, fd239, fd263, fd272;
mul.f64 fd274, fd1034, fd273;
mul.f64 fd276, fd271, fd1034;
mul.f64 fd1022, fd238, fd271;
mul.f64 fd1023, fd239, fd273;
sub.f64 fd279, fd1022, fd1023;
mul.f64 fd1021, fd226, fd273;
mul.f64 fd280, fd238, fd273;
fma.rn.f64 fd281, fd239, fd271, fd280;
mul.f64 fd282, fd1033, fd281;
mul.f64 fd284, fd279, fd1033;
mul.f64 fd286, fd239, fd281;
mul.f64 fd1020, fd238, fd279;
sub.f64 fd287, fd1020, fd286;
mul.f64 fd1019, fd230, fd281;
mul.f64 fd288, fd238, fd281;
fma.rn.f64 fd289, fd239, fd279, fd288;
mul.f64 fd290, fd1032, fd289;
mul.f64 fd292, fd287, fd1032;
mul.f64 fd294, fd239, fd289;
mul.f64 fd1018, fd238, fd287;
sub.f64 fd295, fd1018, fd294;
mul.f64 fd1017, fd234, fd289;
mul.f64 fd296, fd238, fd289;
fma.rn.f64 fd297, fd239, fd287, fd296;
sub.f64 fd1016, fd1069, fd1050;
mul.f64 fd298, fd1016, fd297;
sub.f64 fd1015, fd106, fd163;
mul.f64 fd299, fd1015, fd297;
mul.f64 fd300, fd295, fd1016;
ld.global.v2.f64 {fd301, fd302}, [rd5+1024];
mul.f64 fd305, fd213, fd302;
mul.f64 fd307, fd301, fd213;
mul.f64 fd1013, fd238, fd301;
mul.f64 fd1014, fd239, fd302;
sub.f64 fd310, fd1013, fd1014;
mul.f64 fd1012, fd212, fd302;
mul.f64 fd311, fd238, fd302;
fma.rn.f64 fd312, fd239, fd301, fd311;
mul.f64 fd313, fd217, fd312;
mul.f64 fd315, fd310, fd217;
mul.f64 fd317, fd239, fd312;
mul.f64 fd1011, fd238, fd310;
sub.f64 fd318, fd1011, fd317;
mul.f64 fd1010, fd216, fd312;
mul.f64 fd319, fd238, fd312;
fma.rn.f64 fd320, fd239, fd310, fd319;
mul.f64 fd321, fd221, fd320;
mul.f64 fd323, fd318, fd221;
mul.f64 fd1008, fd238, fd318;
mul.f64 fd1009, fd239, fd320;
sub.f64 fd326, fd1008, fd1009;
mul.f64 fd1007, fd220, fd320;
mul.f64 fd327, fd238, fd320;
fma.rn.f64 fd328, fd239, fd318, fd327;
mul.f64 fd329, fd225, fd328;
mul.f64 fd331, fd326, fd225;
mul.f64 fd1005, fd238, fd326;
mul.f64 fd1006, fd239, fd328;
sub.f64 fd334, fd1005, fd1006;
mul.f64 fd1004, fd224, fd328;
mul.f64 fd335, fd238, fd328;
fma.rn.f64 fd336, fd239, fd326, fd335;
mul.f64 fd337, fd229, fd336;
mul.f64 fd339, fd334, fd229;
mul.f64 fd341, fd239, fd336;
mul.f64 fd1003, fd238, fd334;
sub.f64 fd342, fd1003, fd341;
mul.f64 fd1002, fd228, fd336;
mul.f64 fd343, fd238, fd336;
fma.rn.f64 fd344, fd239, fd334, fd343;
mul.f64 fd345, fd233, fd344;
mul.f64 fd347, fd342, fd233;
mul.f64 fd1000, fd238, fd342;
mul.f64 fd1001, fd239, fd344;
sub.f64 fd350, fd1000, fd1001;
mul.f64 fd999, fd232, fd344;
mul.f64 fd351, fd238, fd344;
mul.f64 fd998, fd210, fd239;
fma.rn.f64 fd352, fd239, fd342, fd351;
mul.f64 fd353, fd237, fd352;
mul.f64 fd354, fd236, fd352;
mul.f64 fd355, fd350, fd237;
barrier.sync 0;
and.b32 r11, r7, 16128;
add.s32 r12, r9, r11;
mov.u32 r35, %tid.x;
shl.b32 r34, r35, 8;
add.f64 fd356, fd1069, fd1050;
sub.f64 fd1089, fd106, fd163;
and.b32 r23, r34, 16128;
add.s32 r22, r9, r23;
add.f64 fd357, fd106, fd163;
st.shared.v2.f64 [r22], {fd357, fd356};
mov.u32 r33, %tid.x;
shl.b32 r32, r33, 4;
fma.rn.f64 fd358, fd238, fd210, fd242;
sub.f64 fd359, fd244, fd998;
st.shared.v2.f64 [r22+16], {fd358, fd359};
fma.rn.f64 fd360, fd247, fd214, fd250;
sub.f64 fd361, fd252, fd1028;
st.shared.v2.f64 [r22+32], {fd360, fd361};
fma.rn.f64 fd362, fd255, fd218, fd258;
sub.f64 fd363, fd260, fd1026;
st.shared.v2.f64 [r22+48], {fd362, fd363};
sub.f64 fd364, fd268, fd1024;
fma.rn.f64 fd365, fd263, fd222, fd266;
st.shared.v2.f64 [r22+64], {fd365, fd364};
fma.rn.f64 fd366, fd271, fd226, fd274;
sub.f64 fd367, fd276, fd1021;
st.shared.v2.f64 [r22+80], {fd366, fd367};
fma.rn.f64 fd368, fd279, fd230, fd282;
sub.f64 fd369, fd284, fd1019;
st.shared.v2.f64 [r22+96], {fd368, fd369};
fma.rn.f64 fd370, fd287, fd234, fd290;
sub.f64 fd371, fd292, fd1017;
st.shared.v2.f64 [r22+112], {fd370, fd371};
fma.rn.f64 fd372, fd295, fd1089, fd298;
sub.f64 fd373, fd300, fd299;
st.shared.v2.f64 [r22+128], {fd372, fd373};
fma.rn.f64 fd374, fd301, fd212, fd305;
sub.f64 fd375, fd307, fd1012;
st.shared.v2.f64 [r22+144], {fd374, fd375};
fma.rn.f64 fd376, fd310, fd216, fd313;
sub.f64 fd377, fd315, fd1010;
st.shared.v2.f64 [r22+160], {fd376, fd377};
fma.rn.f64 fd378, fd318, fd220, fd321;
sub.f64 fd379, fd323, fd1007;
st.shared.v2.f64 [r22+176], {fd378, fd379};
sub.f64 fd380, fd331, fd1004;
fma.rn.f64 fd381, fd326, fd224, fd329;
st.shared.v2.f64 [r22+192], {fd381, fd380};
fma.rn.f64 fd382, fd334, fd228, fd337;
sub.f64 fd383, fd339, fd1002;
st.shared.v2.f64 [r22+208], {fd382, fd383};
fma.rn.f64 fd384, fd342, fd232, fd345;
sub.f64 fd385, fd347, fd999;
st.shared.v2.f64 [r22+224], {fd384, fd385};
fma.rn.f64 fd386, fd350, fd236, fd353;
sub.f64 fd387, fd355, fd354;
st.shared.v2.f64 [r22+240], {fd386, fd387};
barrier.sync 0;
and.b32 r20, r33, 63;
mad.lo.s32 r13, r20, -240, r22;
ld.shared.v2.f64 {fd388, fd389}, [r13];
ld.shared.v2.f64 {fd392, fd393}, [r13+1024];
ld.shared.v2.f64 {fd396, fd397}, [r13+2048];
ld.shared.v2.f64 {fd400, fd401}, [r13+3072];
ld.shared.v2.f64 {fd404, fd405}, [r13+4096];
ld.shared.v2.f64 {fd408, fd409}, [r13+5120];
ld.shared.v2.f64 {fd412, fd413}, [r13+6144];
ld.shared.v2.f64 {fd416, fd417}, [r13+7168];
ld.shared.v2.f64 {fd420, fd421}, [r13+8192];
ld.shared.v2.f64 {fd424, fd425}, [r13+9216];
ld.shared.v2.f64 {fd428, fd429}, [r13+10240];
ld.shared.v2.f64 {fd432, fd433}, [r13+11264];
ld.shared.v2.f64 {fd436, fd437}, [r13+12288];
ld.shared.v2.f64 {fd440, fd441}, [r13+13312];
ld.shared.v2.f64 {fd444, fd445}, [r13+14336];
ld.shared.v2.f64 {fd448, fd449}, [r13+15360];
add.f64 fd452, fd388, fd420;
sub.f64 fd454, fd388, fd420;
add.f64 fd997, fd389, fd421;
sub.f64 fd455, fd389, fd421;
add.f64 fd456, fd404, fd436;
sub.f64 fd458, fd404, fd436;
add.f64 fd996, fd405, fd437;
sub.f64 fd459, fd405, fd437;
add.f64 fd460, fd452, fd456;
sub.f64 fd462, fd452, fd456;
add.f64 fd995, fd997, fd996;
sub.f64 fd463, fd997, fd996;
sub.f64 fd464, fd454, fd459;
add.f64 fd466, fd454, fd459;
add.f64 fd994, fd455, fd458;
sub.f64 fd467, fd455, fd458;
add.f64 fd468, fd396, fd428;
sub.f64 fd470, fd396, fd428;
add.f64 fd993, fd397, fd429;
sub.f64 fd471, fd397, fd429;
add.f64 fd472, fd412, fd444;
sub.f64 fd474, fd412, fd444;
add.f64 fd992, fd413, fd445;
sub.f64 fd475, fd413, fd445;
add.f64 fd476, fd468, fd472;
sub.f64 fd478, fd468, fd472;
add.f64 fd991, fd993, fd992;
sub.f64 fd479, fd993, fd992;
sub.f64 fd480, fd470, fd475;
add.f64 fd482, fd470, fd475;
add.f64 fd990, fd471, fd474;
sub.f64 fd483, fd471, fd474;
mul.f64 fd484, fd480, 0d3FE6A09E667F3BCD;
mul.f64 fd485, fd990, 0d3FE6A09E667F3BCD;
sub.f64 fd486, fd484, fd485;
add.f64 fd487, fd484, fd485;
mul.f64 fd489, fd483, 0d3FE6A09E667F3BCD;
mul.f64 fd989, fd482, 0dBFE6A09E667F3BCD;
sub.f64 fd490, fd989, fd489;
mul.f64 fd491, fd483, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd492, fd482, 0d3FE6A09E667F3BCD, fd491;
add.f64 fd493, fd460, fd476;
sub.f64 fd495, fd460, fd476;
add.f64 fd988, fd995, fd991;
sub.f64 fd496, fd995, fd991;
add.f64 fd497, fd464, fd486;
sub.f64 fd499, fd464, fd486;
add.f64 fd987, fd994, fd487;
sub.f64 fd500, fd994, fd487;
sub.f64 fd501, fd462, fd479;
add.f64 fd503, fd462, fd479;
add.f64 fd986, fd463, fd478;
sub.f64 fd504, fd463, fd478;
add.f64 fd505, fd466, fd490;
sub.f64 fd507, fd466, fd490;
add.f64 fd985, fd467, fd492;
sub.f64 fd508, fd467, fd492;
add.f64 fd509, fd392, fd424;
sub.f64 fd511, fd392, fd424;
add.f64 fd984, fd393, fd425;
sub.f64 fd512, fd393, fd425;
add.f64 fd513, fd408, fd440;
sub.f64 fd515, fd408, fd440;
add.f64 fd983, fd409, fd441;
sub.f64 fd516, fd409, fd441;
add.f64 fd517, fd509, fd513;
sub.f64 fd519, fd509, fd513;
add.f64 fd982, fd984, fd983;
sub.f64 fd520, fd984, fd983;
sub.f64 fd521, fd511, fd516;
add.f64 fd523, fd511, fd516;
add.f64 fd981, fd512, fd515;
sub.f64 fd524, fd512, fd515;
add.f64 fd525, fd400, fd432;
sub.f64 fd527, fd400, fd432;
add.f64 fd980, fd401, fd433;
sub.f64 fd528, fd401, fd433;
add.f64 fd529, fd416, fd448;
sub.f64 fd531, fd416, fd448;
add.f64 fd979, fd417, fd449;
sub.f64 fd532, fd417, fd449;
add.f64 fd533, fd525, fd529;
sub.f64 fd535, fd525, fd529;
add.f64 fd978, fd980, fd979;
sub.f64 fd536, fd980, fd979;
sub.f64 fd537, fd527, fd532;
add.f64 fd539, fd527, fd532;
add.f64 fd977, fd528, fd531;
sub.f64 fd540, fd528, fd531;
mul.f64 fd541, fd537, 0d3FE6A09E667F3BCD;
mul.f64 fd542, fd977, 0d3FE6A09E667F3BCD;
sub.f64 fd543, fd541, fd542;
add.f64 fd544, fd541, fd542;
mul.f64 fd546, fd540, 0d3FE6A09E667F3BCD;
mul.f64 fd976, fd539, 0dBFE6A09E667F3BCD;
sub.f64 fd547, fd976, fd546;
mul.f64 fd548, fd540, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd549, fd539, 0d3FE6A09E667F3BCD, fd548;
add.f64 fd550, fd517, fd533;
sub.f64 fd552, fd517, fd533;
add.f64 fd975, fd982, fd978;
sub.f64 fd553, fd982, fd978;
add.f64 fd554, fd521, fd543;
sub.f64 fd556, fd521, fd543;
add.f64 fd974, fd981, fd544;
sub.f64 fd557, fd981, fd544;
sub.f64 fd558, fd519, fd536;
add.f64 fd560, fd519, fd536;
add.f64 fd973, fd520, fd535;
sub.f64 fd561, fd520, fd535;
add.f64 fd562, fd523, fd547;
sub.f64 fd564, fd523, fd547;
add.f64 fd972, fd524, fd549;
sub.f64 fd565, fd524, fd549;
mul.f64 fd970, fd554, 0d3FED906BCF328D46;
mul.f64 fd971, fd974, 0d3FD87DE2A6AEA963;
sub.f64 fd568, fd970, fd971;
mul.f64 fd569, fd974, 0d3FED906BCF328D46;
fma.rn.f64 fd570, fd554, 0d3FD87DE2A6AEA963, fd569;
mul.f64 fd571, fd558, 0d3FE6A09E667F3BCD;
mul.f64 fd572, fd973, 0d3FE6A09E667F3BCD;
sub.f64 fd573, fd571, fd572;
add.f64 fd574, fd571, fd572;
mul.f64 fd968, fd562, 0d3FD87DE2A6AEA963;
mul.f64 fd969, fd972, 0d3FED906BCF328D46;
sub.f64 fd577, fd968, fd969;
mul.f64 fd578, fd972, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd579, fd562, 0d3FED906BCF328D46, fd578;
mul.f64 fd966, fd556, 0dBFD87DE2A6AEA963;
mul.f64 fd967, fd557, 0d3FED906BCF328D46;
sub.f64 fd582, fd966, fd967;
mul.f64 fd583, fd557, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd584, fd556, 0d3FED906BCF328D46, fd583;
mul.f64 fd964, fd560, 0dBFE6A09E667F3BCD;
mul.f64 fd965, fd561, 0d3FE6A09E667F3BCD;
sub.f64 fd587, fd964, fd965;
mul.f64 fd588, fd561, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd589, fd560, 0d3FE6A09E667F3BCD, fd588;
mul.f64 fd591, fd565, 0d3FD87DE2A6AEA963;
mul.f64 fd963, fd564, 0dBFED906BCF328D46;
sub.f64 fd592, fd963, fd591;
mul.f64 fd593, fd565, 0dBFED906BCF328D46;
fma.rn.f64 fd594, fd564, 0d3FD87DE2A6AEA963, fd593;
add.f64 fd597, fd497, fd568;
sub.f64 fd599, fd497, fd568;
add.f64 fd962, fd987, fd570;
sub.f64 fd600, fd987, fd570;
add.f64 fd601, fd501, fd573;
sub.f64 fd603, fd501, fd573;
add.f64 fd961, fd986, fd574;
sub.f64 fd604, fd986, fd574;
add.f64 fd605, fd505, fd577;
sub.f64 fd607, fd505, fd577;
add.f64 fd960, fd985, fd579;
sub.f64 fd608, fd985, fd579;
sub.f64 fd609, fd495, fd553;
add.f64 fd611, fd495, fd553;
add.f64 fd959, fd496, fd552;
sub.f64 fd612, fd496, fd552;
add.f64 fd613, fd499, fd582;
sub.f64 fd615, fd499, fd582;
add.f64 fd958, fd500, fd584;
sub.f64 fd616, fd500, fd584;
add.f64 fd617, fd503, fd587;
sub.f64 fd619, fd503, fd587;
add.f64 fd957, fd504, fd589;
sub.f64 fd620, fd504, fd589;
add.f64 fd621, fd507, fd592;
sub.f64 fd623, fd507, fd592;
add.f64 fd956, fd508, fd594;
sub.f64 fd624, fd508, fd594;
and.b32 r14, r33, 48;
mov.u64 rd7, %34;
cvt.u64.u32 rd9, r14;
add.s64 rd8, rd7, rd9;
ld.global.v2.f64 {fd625, fd626}, [rd8];
mul.f64 fd629, fd962, fd626;
mul.f64 fd631, fd625, fd962;
mul.f64 fd633, fd626, fd626;
mul.f64 fd955, fd625, fd625;
sub.f64 fd634, fd955, fd633;
mul.f64 fd635, fd626, fd625;
fma.rn.f64 fd636, fd626, fd625, fd635;
mul.f64 fd637, fd961, fd636;
mul.f64 fd639, fd634, fd961;
mul.f64 fd953, fd625, fd634;
mul.f64 fd954, fd626, fd636;
sub.f64 fd642, fd953, fd954;
mul.f64 fd952, fd601, fd636;
mul.f64 fd643, fd625, fd636;
fma.rn.f64 fd644, fd626, fd634, fd643;
mul.f64 fd645, fd960, fd644;
mul.f64 fd647, fd642, fd960;
mul.f64 fd649, fd626, fd644;
mul.f64 fd951, fd625, fd642;
sub.f64 fd650, fd951, fd649;
mul.f64 fd950, fd605, fd644;
mul.f64 fd651, fd625, fd644;
fma.rn.f64 fd652, fd626, fd642, fd651;
mul.f64 fd653, fd959, fd652;
mul.f64 fd655, fd650, fd959;
mul.f64 fd948, fd625, fd650;
mul.f64 fd949, fd626, fd652;
sub.f64 fd658, fd948, fd949;
mul.f64 fd947, fd609, fd652;
mul.f64 fd659, fd625, fd652;
fma.rn.f64 fd660, fd626, fd650, fd659;
mul.f64 fd661, fd958, fd660;
mul.f64 fd663, fd658, fd958;
mul.f64 fd945, fd625, fd658;
mul.f64 fd946, fd626, fd660;
sub.f64 fd666, fd945, fd946;
mul.f64 fd944, fd613, fd660;
mul.f64 fd667, fd625, fd660;
fma.rn.f64 fd668, fd626, fd658, fd667;
mul.f64 fd669, fd957, fd668;
mul.f64 fd671, fd666, fd957;
mul.f64 fd673, fd626, fd668;
mul.f64 fd943, fd625, fd666;
sub.f64 fd674, fd943, fd673;
mul.f64 fd942, fd617, fd668;
mul.f64 fd675, fd625, fd668;
fma.rn.f64 fd676, fd626, fd666, fd675;
mul.f64 fd677, fd956, fd676;
mul.f64 fd679, fd674, fd956;
mul.f64 fd940, fd625, fd674;
mul.f64 fd941, fd626, fd676;
sub.f64 fd682, fd940, fd941;
mul.f64 fd939, fd621, fd676;
mul.f64 fd683, fd625, fd676;
fma.rn.f64 fd684, fd626, fd674, fd683;
sub.f64 fd938, fd988, fd975;
mul.f64 fd685, fd938, fd684;
sub.f64 fd937, fd493, fd550;
mul.f64 fd686, fd937, fd684;
mul.f64 fd687, fd682, fd938;
ld.global.v2.f64 {fd688, fd689}, [rd8+64];
mul.f64 fd692, fd600, fd689;
mul.f64 fd694, fd688, fd600;
mul.f64 fd696, fd626, fd689;
mul.f64 fd936, fd625, fd688;
sub.f64 fd697, fd936, fd696;
mul.f64 fd935, fd599, fd689;
mul.f64 fd698, fd625, fd689;
fma.rn.f64 fd699, fd626, fd688, fd698;
mul.f64 fd700, fd604, fd699;
mul.f64 fd702, fd697, fd604;
mul.f64 fd704, fd626, fd699;
mul.f64 fd934, fd625, fd697;
sub.f64 fd705, fd934, fd704;
mul.f64 fd933, fd603, fd699;
mul.f64 fd706, fd625, fd699;
fma.rn.f64 fd707, fd626, fd697, fd706;
mul.f64 fd708, fd608, fd707;
mul.f64 fd710, fd705, fd608;
mul.f64 fd931, fd625, fd705;
mul.f64 fd932, fd626, fd707;
sub.f64 fd713, fd931, fd932;
mul.f64 fd930, fd607, fd707;
mul.f64 fd714, fd625, fd707;
fma.rn.f64 fd715, fd626, fd705, fd714;
mul.f64 fd716, fd612, fd715;
mul.f64 fd718, fd713, fd612;
mul.f64 fd720, fd626, fd715;
mul.f64 fd929, fd625, fd713;
sub.f64 fd721, fd929, fd720;
mul.f64 fd928, fd611, fd715;
mul.f64 fd722, fd625, fd715;
fma.rn.f64 fd723, fd626, fd713, fd722;
mul.f64 fd724, fd616, fd723;
mul.f64 fd726, fd721, fd616;
mul.f64 fd728, fd626, fd723;
mul.f64 fd927, fd625, fd721;
sub.f64 fd729, fd927, fd728;
mul.f64 fd926, fd615, fd723;
mul.f64 fd730, fd625, fd723;
fma.rn.f64 fd731, fd626, fd721, fd730;
mul.f64 fd732, fd620, fd731;
mul.f64 fd734, fd729, fd620;
mul.f64 fd924, fd625, fd729;
mul.f64 fd925, fd626, fd731;
sub.f64 fd737, fd924, fd925;
mul.f64 fd923, fd619, fd731;
mul.f64 fd738, fd625, fd731;
mul.f64 fd922, fd597, fd626;
fma.rn.f64 fd739, fd626, fd729, fd738;
mul.f64 fd740, fd624, fd739;
mul.f64 fd741, fd623, fd739;
mul.f64 fd742, fd737, fd624;
and.b32 r15, r32, 240;
add.s32 r16, r9, r15;
mov.u32 r28, %tid.x;
shl.b32 r27, r28, 8;
barrier.sync 0;
and.b32 r17, r27, 12288;
add.s32 r18, r16, r17;
mov.u32 r31, %tid.x;
and.b32 r30, r31, 48;
add.f64 fd743, fd988, fd975;
sub.f64 fd1088, fd493, fd550;
add.f64 fd744, fd493, fd550;
st.shared.v2.f64 [r18], {fd744, fd743};
mov.u32 r37, %tid.x;
and.b32 r36, r37, 48;
fma.rn.f64 fd745, fd625, fd597, fd629;
sub.f64 fd746, fd631, fd922;
st.shared.v2.f64 [r18+256], {fd745, fd746};
fma.rn.f64 fd747, fd634, fd601, fd637;
sub.f64 fd748, fd639, fd952;
st.shared.v2.f64 [r18+512], {fd747, fd748};
fma.rn.f64 fd749, fd642, fd605, fd645;
sub.f64 fd750, fd647, fd950;
st.shared.v2.f64 [r18+768], {fd749, fd750};
fma.rn.f64 fd751, fd650, fd609, fd653;
sub.f64 fd752, fd655, fd947;
st.shared.v2.f64 [r18+1024], {fd751, fd752};
sub.f64 fd753, fd663, fd944;
fma.rn.f64 fd754, fd658, fd613, fd661;
st.shared.v2.f64 [r18+1280], {fd754, fd753};
fma.rn.f64 fd755, fd666, fd617, fd669;
sub.f64 fd756, fd671, fd942;
st.shared.v2.f64 [r18+1536], {fd755, fd756};
fma.rn.f64 fd757, fd674, fd621, fd677;
sub.f64 fd758, fd679, fd939;
st.shared.v2.f64 [r18+1792], {fd757, fd758};
fma.rn.f64 fd759, fd682, fd1088, fd685;
sub.f64 fd760, fd687, fd686;
st.shared.v2.f64 [r18+2048], {fd759, fd760};
fma.rn.f64 fd761, fd688, fd599, fd692;
sub.f64 fd762, fd694, fd935;
st.shared.v2.f64 [r18+2304], {fd761, fd762};
fma.rn.f64 fd763, fd697, fd603, fd700;
sub.f64 fd764, fd702, fd933;
st.shared.v2.f64 [r18+2560], {fd763, fd764};
fma.rn.f64 fd765, fd705, fd607, fd708;
sub.f64 fd766, fd710, fd930;
st.shared.v2.f64 [r18+2816], {fd765, fd766};
fma.rn.f64 fd767, fd713, fd611, fd716;
sub.f64 fd768, fd718, fd928;
st.shared.v2.f64 [r18+3072], {fd767, fd768};
sub.f64 fd769, fd726, fd926;
fma.rn.f64 fd770, fd721, fd615, fd724;
st.shared.v2.f64 [r18+3328], {fd770, fd769};
fma.rn.f64 fd771, fd729, fd619, fd732;
sub.f64 fd772, fd734, fd923;
st.shared.v2.f64 [r18+3584], {fd771, fd772};
fma.rn.f64 fd773, fd737, fd623, fd740;
sub.f64 fd774, fd742, fd741;
st.shared.v2.f64 [r18+3840], {fd773, fd774};
barrier.sync 0;
mad.lo.s32 r19, r36, -240, r18;
ld.shared.v2.f64 {fd775, fd776}, [r19];
ld.shared.v2.f64 {fd779, fd780}, [r19+1024];
ld.shared.v2.f64 {fd783, fd784}, [r19+2048];
ld.shared.v2.f64 {fd787, fd788}, [r19+3072];
ld.shared.v2.f64 {fd791, fd792}, [r19+4096];
ld.shared.v2.f64 {fd795, fd796}, [r19+5120];
ld.shared.v2.f64 {fd799, fd800}, [r19+6144];
ld.shared.v2.f64 {fd803, fd804}, [r19+7168];
ld.shared.v2.f64 {fd807, fd808}, [r19+8192];
ld.shared.v2.f64 {fd811, fd812}, [r19+9216];
ld.shared.v2.f64 {fd815, fd816}, [r19+10240];
ld.shared.v2.f64 {fd819, fd820}, [r19+11264];
ld.shared.v2.f64 {fd823, fd824}, [r19+12288];
ld.shared.v2.f64 {fd827, fd828}, [r19+13312];
ld.shared.v2.f64 {fd831, fd832}, [r19+14336];
ld.shared.v2.f64 {fd835, fd836}, [r19+15360];
add.f64 fd839, fd775, fd807;
sub.f64 fd841, fd775, fd807;
add.f64 fd921, fd776, fd808;
sub.f64 fd842, fd776, fd808;
add.f64 fd843, fd791, fd823;
sub.f64 fd845, fd791, fd823;
add.f64 fd920, fd792, fd824;
sub.f64 fd846, fd792, fd824;
add.f64 fd847, fd779, fd811;
sub.f64 fd849, fd779, fd811;
add.f64 fd919, fd780, fd812;
sub.f64 fd850, fd780, fd812;
add.f64 fd851, fd795, fd827;
sub.f64 fd853, fd795, fd827;
add.f64 fd918, fd796, fd828;
sub.f64 fd854, fd796, fd828;
add.f64 fd855, fd783, fd815;
sub.f64 fd857, fd783, fd815;
add.f64 fd917, fd784, fd816;
sub.f64 fd858, fd784, fd816;
add.f64 fd859, fd799, fd831;
sub.f64 fd861, fd799, fd831;
add.f64 fd916, fd800, fd832;
sub.f64 fd862, fd800, fd832;
add.f64 fd863, fd787, fd819;
sub.f64 fd865, fd787, fd819;
add.f64 fd915, fd788, fd820;
sub.f64 fd866, fd788, fd820;
add.f64 fd867, fd803, fd835;
sub.f64 fd869, fd803, fd835;
add.f64 fd914, fd804, fd836;
sub.f64 fd870, fd804, fd836;
add.f64 %0, fd839, fd843;
add.f64 %1, fd921, fd920;
add.f64 %2, fd847, fd851;
add.f64 %3, fd919, fd918;
add.f64 %4, fd855, fd859;
add.f64 %5, fd917, fd916;
add.f64 %7, fd915, fd914;
add.f64 %6, fd863, fd867;
add.f64 %9, fd842, fd845;
sub.f64 %8, fd841, fd846;
add.f64 %11, fd850, fd853;
sub.f64 %10, fd849, fd854;
sub.f64 %12, fd857, fd862;
add.f64 %13, fd858, fd861;
sub.f64 %14, fd865, fd870;
add.f64 %15, fd866, fd869;
sub.f64 %17, fd921, fd920;
sub.f64 %16, fd839, fd843;
sub.f64 %19, fd919, fd918;
sub.f64 %18, fd847, fd851;
sub.f64 %21, fd917, fd916;
sub.f64 %20, fd855, fd859;
sub.f64 %23, fd915, fd914;
sub.f64 %22, fd863, fd867;
sub.f64 %25, fd842, fd845;
add.f64 %24, fd841, fd846;
sub.f64 %27, fd850, fd853;
add.f64 %26, fd849, fd854;
sub.f64 %29, fd858, fd861;
add.f64 %28, fd857, fd862;
sub.f64 %31, fd866, fd869;
add.f64 %30, fd865, fd870;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_1024), "l"(lut_dp_16_64), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[8].y), "d"(rmem[4].y), "d"(rmem[10].y), "d"(rmem[2].y), "d"(rmem[14].y), "d"(rmem[1].y), "d"(rmem[5].y), "d"(rmem[13].y), "d"(rmem[11].y), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<649, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<35>;
.reg .f64 fd<241>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd17, %13, %18;
add.f64 fd18, %14, %20;
sub.f64 fd19, %13, %18;
sub.f64 fd20, %14, %20;
add.f64 fd21, %15, %21;
add.f64 fd22, %17, %22;
sub.f64 fd23, %15, %21;
sub.f64 fd24, %17, %22;
add.f64 fd25, fd17, fd21;
add.f64 fd26, fd18, fd22;
sub.f64 fd27, fd17, fd21;
sub.f64 fd28, fd18, fd22;
sub.f64 fd29, fd19, fd24;
add.f64 fd30, fd20, fd23;
add.f64 fd31, fd19, fd24;
sub.f64 fd32, fd20, fd23;
and.b32 r6, r5, 255;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 4080;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd33, fd34}, [rd5];
mul.f64 fd37, fd30, fd34;
fma.rn.f64 fd38, fd33, fd29, fd37;
mul.f64 fd39, fd29, fd34;
mul.f64 fd40, fd33, fd30;
sub.f64 fd41, fd40, fd39;
mul.f64 fd42, fd33, fd33;
mul.f64 fd43, fd34, fd34;
sub.f64 fd44, fd42, fd43;
mul.f64 fd45, fd34, fd33;
fma.rn.f64 fd46, fd34, fd33, fd45;
mul.f64 fd47, fd28, fd46;
fma.rn.f64 fd48, fd44, fd27, fd47;
mul.f64 fd49, fd27, fd46;
mul.f64 fd50, fd44, fd28;
sub.f64 fd51, fd50, fd49;
ld.global.v2.f64 {fd52, fd53}, [rd5+4096];
mul.f64 fd56, fd32, fd53;
fma.rn.f64 fd57, fd52, fd31, fd56;
mul.f64 fd58, fd31, fd53;
mul.f64 fd59, fd52, fd32;
sub.f64 fd60, fd59, fd58;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8160;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd25, fd38};
st.shared.v2.f64 [r12+16], {fd48, fd57};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.f64 fd61, [r13];
ld.shared.f64 fd62, [r13+2048];
ld.shared.f64 fd63, [r13+4096];
ld.shared.f64 fd64, [r13+6144];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd26, fd41};
st.shared.v2.f64 [r12+16], {fd51, fd60};
barrier.sync 0;
ld.shared.f64 fd65, [r13];
ld.shared.f64 fd66, [r13+2048];
ld.shared.f64 fd67, [r13+4096];
ld.shared.f64 fd68, [r13+6144];
add.f64 fd69, fd61, fd63;
add.f64 fd70, fd65, fd67;
sub.f64 fd71, fd61, fd63;
sub.f64 fd72, fd65, fd67;
add.f64 fd73, fd62, fd64;
add.f64 fd74, fd66, fd68;
sub.f64 fd75, fd62, fd64;
sub.f64 fd76, fd66, fd68;
add.f64 fd77, fd69, fd73;
add.f64 fd78, fd70, fd74;
sub.f64 fd79, fd69, fd73;
sub.f64 fd80, fd70, fd74;
sub.f64 fd81, fd71, fd76;
add.f64 fd82, fd72, fd75;
add.f64 fd83, fd71, fd76;
sub.f64 fd84, fd72, fd75;
and.b32 r14, r5, 252;
bfe.u32 r15, r5, 2, 6;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd85, fd86}, [rd8];
mul.f64 fd89, fd82, fd86;
fma.rn.f64 fd90, fd85, fd81, fd89;
mul.f64 fd91, fd81, fd86;
mul.f64 fd92, fd85, fd82;
sub.f64 fd93, fd92, fd91;
mul.f64 fd94, fd85, fd85;
mul.f64 fd95, fd86, fd86;
sub.f64 fd96, fd94, fd95;
mul.f64 fd97, fd86, fd85;
fma.rn.f64 fd98, fd86, fd85, fd97;
mul.f64 fd99, fd80, fd98;
fma.rn.f64 fd100, fd96, fd79, fd99;
mul.f64 fd101, fd79, fd98;
mul.f64 fd102, fd96, fd80;
sub.f64 fd103, fd102, fd101;
ld.global.v2.f64 {fd104, fd105}, [rd8+1024];
mul.f64 fd108, fd84, fd105;
fma.rn.f64 fd109, fd104, fd83, fd108;
mul.f64 fd110, fd83, fd105;
mul.f64 fd111, fd104, fd84;
sub.f64 fd112, fd111, fd110;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 24;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 8064;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd77;
st.shared.f64 [r20+32], fd90;
st.shared.f64 [r20+64], fd100;
st.shared.f64 [r20+96], fd109;
barrier.sync 0;
mad.lo.s32 r21, r14, -24, r20;
ld.shared.f64 fd113, [r21];
ld.shared.f64 fd114, [r21+2048];
ld.shared.f64 fd115, [r21+4096];
ld.shared.f64 fd116, [r21+6144];
barrier.sync 0;
st.shared.f64 [r20], fd78;
st.shared.f64 [r20+32], fd93;
st.shared.f64 [r20+64], fd103;
st.shared.f64 [r20+96], fd112;
barrier.sync 0;
ld.shared.f64 fd117, [r21];
ld.shared.f64 fd118, [r21+2048];
ld.shared.f64 fd119, [r21+4096];
ld.shared.f64 fd120, [r21+6144];
add.f64 fd121, fd113, fd115;
add.f64 fd122, fd117, fd119;
sub.f64 fd123, fd113, fd115;
sub.f64 fd124, fd117, fd119;
add.f64 fd125, fd114, fd116;
add.f64 fd126, fd118, fd120;
sub.f64 fd127, fd114, fd116;
sub.f64 fd128, fd118, fd120;
add.f64 fd129, fd121, fd125;
add.f64 fd130, fd122, fd126;
sub.f64 fd131, fd121, fd125;
sub.f64 fd132, fd122, fd126;
sub.f64 fd133, fd123, fd128;
add.f64 fd134, fd124, fd127;
add.f64 fd135, fd123, fd128;
sub.f64 fd136, fd124, fd127;
and.b32 r22, r5, 240;
cvt.u64.u32 rd9, r22;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd137, fd138}, [rd11];
mul.f64 fd141, fd134, fd138;
fma.rn.f64 fd142, fd137, fd133, fd141;
mul.f64 fd143, fd133, fd138;
mul.f64 fd144, fd137, fd134;
sub.f64 fd145, fd144, fd143;
mul.f64 fd146, fd137, fd137;
mul.f64 fd147, fd138, fd138;
sub.f64 fd148, fd146, fd147;
mul.f64 fd149, fd138, fd137;
fma.rn.f64 fd150, fd138, fd137, fd149;
mul.f64 fd151, fd132, fd150;
fma.rn.f64 fd152, fd148, fd131, fd151;
mul.f64 fd153, fd131, fd150;
mul.f64 fd154, fd148, fd132;
sub.f64 fd155, fd154, fd153;
ld.global.v2.f64 {fd156, fd157}, [rd11+256];
mul.f64 fd160, fd136, fd157;
fma.rn.f64 fd161, fd156, fd135, fd160;
mul.f64 fd162, fd135, fd157;
mul.f64 fd163, fd156, fd136;
sub.f64 fd164, fd163, fd162;
and.b32 r23, r16, 120;
add.s32 r24, r10, r23;
barrier.sync 0;
and.b32 r25, r8, 7680;
add.s32 r26, r24, r25;
st.shared.f64 [r26], fd129;
st.shared.f64 [r26+128], fd142;
st.shared.f64 [r26+256], fd152;
st.shared.f64 [r26+384], fd161;
barrier.sync 0;
mad.lo.s32 r27, r22, -24, r26;
ld.shared.f64 fd165, [r27];
ld.shared.f64 fd166, [r27+2048];
ld.shared.f64 fd167, [r27+4096];
ld.shared.f64 fd168, [r27+6144];
barrier.sync 0;
st.shared.f64 [r26], fd130;
st.shared.f64 [r26+128], fd145;
st.shared.f64 [r26+256], fd155;
st.shared.f64 [r26+384], fd164;
barrier.sync 0;
ld.shared.f64 fd169, [r27];
ld.shared.f64 fd170, [r27+2048];
ld.shared.f64 fd171, [r27+4096];
ld.shared.f64 fd172, [r27+6144];
add.f64 fd173, fd165, fd167;
add.f64 fd174, fd169, fd171;
sub.f64 fd175, fd165, fd167;
sub.f64 fd176, fd169, fd171;
add.f64 fd177, fd166, fd168;
add.f64 fd178, fd170, fd172;
sub.f64 fd179, fd166, fd168;
sub.f64 fd180, fd170, fd172;
add.f64 fd181, fd173, fd177;
add.f64 fd182, fd174, fd178;
sub.f64 fd183, fd173, fd177;
sub.f64 fd184, fd174, fd178;
sub.f64 fd185, fd175, fd180;
add.f64 fd186, fd176, fd179;
add.f64 fd187, fd175, fd180;
sub.f64 fd188, fd176, fd179;
and.b32 r28, r5, 192;
bfe.u32 r29, r5, 6, 2;
mul.wide.u32 rd12, r29, 16;
mov.u64 rd13, %12;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd189, fd190}, [rd14];
mul.f64 fd193, fd186, fd190;
fma.rn.f64 fd194, fd189, fd185, fd193;
mul.f64 fd195, fd185, fd190;
mul.f64 fd196, fd189, fd186;
sub.f64 fd197, fd196, fd195;
mul.f64 fd198, fd189, fd189;
mul.f64 fd199, fd190, fd190;
sub.f64 fd200, fd198, fd199;
mul.f64 fd201, fd190, fd189;
fma.rn.f64 fd202, fd190, fd189, fd201;
mul.f64 fd203, fd184, fd202;
fma.rn.f64 fd204, fd200, fd183, fd203;
mul.f64 fd205, fd183, fd202;
mul.f64 fd206, fd200, fd184;
sub.f64 fd207, fd206, fd205;
ld.global.v2.f64 {fd208, fd209}, [rd14+64];
mul.f64 fd212, fd188, fd209;
fma.rn.f64 fd213, fd208, fd187, fd212;
mul.f64 fd214, fd187, fd209;
mul.f64 fd215, fd208, fd188;
sub.f64 fd216, fd215, fd214;
and.b32 r30, r16, 504;
add.s32 r31, r10, r30;
barrier.sync 0;
and.b32 r32, r8, 6144;
add.s32 r33, r31, r32;
st.shared.f64 [r33], fd181;
st.shared.f64 [r33+512], fd194;
st.shared.f64 [r33+1024], fd204;
st.shared.f64 [r33+1536], fd213;
barrier.sync 0;
mad.lo.s32 r34, r28, -24, r33;
ld.shared.f64 fd217, [r34];
ld.shared.f64 fd218, [r34+2048];
ld.shared.f64 fd219, [r34+4096];
ld.shared.f64 fd220, [r34+6144];
barrier.sync 0;
st.shared.f64 [r33], fd182;
st.shared.f64 [r33+512], fd197;
st.shared.f64 [r33+1024], fd207;
st.shared.f64 [r33+1536], fd216;
barrier.sync 0;
ld.shared.f64 fd221, [r34];
ld.shared.f64 fd222, [r34+2048];
ld.shared.f64 fd223, [r34+4096];
ld.shared.f64 fd224, [r34+6144];
add.f64 fd225, fd217, fd219;
add.f64 fd226, fd221, fd223;
sub.f64 fd227, fd217, fd219;
sub.f64 fd228, fd221, fd223;
add.f64 fd229, fd218, fd220;
add.f64 fd230, fd222, fd224;
sub.f64 fd231, fd218, fd220;
sub.f64 fd232, fd222, fd224;
add.f64 %0, fd225, fd229;
add.f64 %1, fd226, fd230;
add.f64 %3, fd228, fd231;
sub.f64 %2, fd227, fd232;
sub.f64 %4, fd225, fd229;
sub.f64 %5, fd226, fd230;
sub.f64 %7, fd228, fd231;
add.f64 %6, fd227, fd232;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y): "r"(smem), "l"(lut_dp_4_1024), "l"(lut_dp_4_256), "l"(lut_dp_4_64), "l"(lut_dp_4_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<650, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<34>;
.reg .f64 fd<273>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd17, %13, %18;
add.f64 fd18, %14, %20;
sub.f64 fd19, %13, %18;
sub.f64 fd20, %14, %20;
add.f64 fd21, %15, %21;
add.f64 fd22, %17, %22;
sub.f64 fd23, %15, %21;
sub.f64 fd24, %17, %22;
sub.f64 fd25, fd17, fd21;
sub.f64 fd26, fd18, fd22;
sub.f64 fd27, fd19, fd24;
add.f64 fd28, fd20, fd23;
add.f64 fd29, fd19, fd24;
sub.f64 fd30, fd20, fd23;
and.b32 r6, r5, 255;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 4080;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd31, fd32}, [rd5];
mul.f64 fd35, fd28, fd32;
mul.f64 fd36, fd27, fd32;
mul.f64 fd37, fd31, fd28;
mul.f64 fd38, fd31, fd31;
mul.f64 fd39, fd32, fd32;
sub.f64 fd40, fd38, fd39;
mul.f64 fd41, fd32, fd31;
fma.rn.f64 fd42, fd32, fd31, fd41;
mul.f64 fd43, fd26, fd42;
mul.f64 fd44, fd25, fd42;
mul.f64 fd45, fd40, fd26;
ld.global.v2.f64 {fd46, fd47}, [rd5+4096];
mul.f64 fd50, fd30, fd47;
mul.f64 fd51, fd29, fd47;
mul.f64 fd52, fd46, fd30;
barrier.sync 0;
and.b32 r11, r7, 16320;
add.s32 r12, r9, r11;
add.f64 fd53, fd18, fd22;
add.f64 fd54, fd17, fd21;
st.shared.v2.f64 [r12], {fd54, fd53};
fma.rn.f64 fd55, fd31, fd27, fd35;
sub.f64 fd56, fd37, fd36;
st.shared.v2.f64 [r12+16], {fd55, fd56};
sub.f64 fd57, fd45, fd44;
fma.rn.f64 fd58, fd40, fd25, fd43;
st.shared.v2.f64 [r12+32], {fd58, fd57};
fma.rn.f64 fd59, fd46, fd29, fd50;
sub.f64 fd60, fd52, fd51;
st.shared.v2.f64 [r12+48], {fd59, fd60};
barrier.sync 0;
mad.lo.s32 r13, r6, -48, r12;
ld.shared.v2.f64 {fd61, fd62}, [r13];
ld.shared.v2.f64 {fd65, fd66}, [r13+4096];
ld.shared.v2.f64 {fd69, fd70}, [r13+8192];
ld.shared.v2.f64 {fd73, fd74}, [r13+12288];
add.f64 fd77, fd61, fd69;
add.f64 fd78, fd62, fd70;
sub.f64 fd79, fd61, fd69;
sub.f64 fd80, fd62, fd70;
add.f64 fd81, fd65, fd73;
add.f64 fd82, fd66, fd74;
sub.f64 fd83, fd65, fd73;
sub.f64 fd84, fd66, fd74;
sub.f64 fd85, fd77, fd81;
sub.f64 fd86, fd78, fd82;
sub.f64 fd87, fd79, fd84;
add.f64 fd88, fd80, fd83;
add.f64 fd89, fd79, fd84;
sub.f64 fd90, fd80, fd83;
and.b32 r14, r5, 252;
bfe.u32 r15, r5, 2, 6;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd91, fd92}, [rd8];
mul.f64 fd95, fd88, fd92;
mul.f64 fd96, fd87, fd92;
mul.f64 fd97, fd91, fd88;
mul.f64 fd98, fd91, fd91;
mul.f64 fd99, fd92, fd92;
sub.f64 fd100, fd98, fd99;
mul.f64 fd101, fd92, fd91;
fma.rn.f64 fd102, fd92, fd91, fd101;
mul.f64 fd103, fd86, fd102;
mul.f64 fd104, fd85, fd102;
mul.f64 fd105, fd100, fd86;
ld.global.v2.f64 {fd106, fd107}, [rd8+1024];
mul.f64 fd110, fd90, fd107;
mul.f64 fd111, fd89, fd107;
mul.f64 fd112, fd106, fd90;
and.b32 r16, r10, 48;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 16128;
add.s32 r19, r17, r18;
add.f64 fd113, fd78, fd82;
add.f64 fd114, fd77, fd81;
st.shared.v2.f64 [r19], {fd114, fd113};
fma.rn.f64 fd115, fd91, fd87, fd95;
sub.f64 fd116, fd97, fd96;
st.shared.v2.f64 [r19+64], {fd115, fd116};
fma.rn.f64 fd117, fd100, fd85, fd103;
sub.f64 fd118, fd105, fd104;
st.shared.v2.f64 [r19+128], {fd117, fd118};
fma.rn.f64 fd119, fd106, fd89, fd110;
sub.f64 fd120, fd112, fd111;
st.shared.v2.f64 [r19+192], {fd119, fd120};
barrier.sync 0;
mad.lo.s32 r20, r14, -48, r19;
ld.shared.v2.f64 {fd121, fd122}, [r20];
ld.shared.v2.f64 {fd125, fd126}, [r20+4096];
ld.shared.v2.f64 {fd129, fd130}, [r20+8192];
ld.shared.v2.f64 {fd133, fd134}, [r20+12288];
add.f64 fd137, fd121, fd129;
add.f64 fd138, fd122, fd130;
sub.f64 fd139, fd121, fd129;
sub.f64 fd140, fd122, fd130;
add.f64 fd141, fd125, fd133;
add.f64 fd142, fd126, fd134;
sub.f64 fd143, fd125, fd133;
sub.f64 fd144, fd126, fd134;
sub.f64 fd145, fd137, fd141;
sub.f64 fd146, fd138, fd142;
sub.f64 fd147, fd139, fd144;
add.f64 fd148, fd140, fd143;
add.f64 fd149, fd139, fd144;
sub.f64 fd150, fd140, fd143;
and.b32 r21, r5, 240;
cvt.u64.u32 rd9, r21;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd151, fd152}, [rd11];
mul.f64 fd155, fd148, fd152;
mul.f64 fd156, fd147, fd152;
mul.f64 fd157, fd151, fd148;
mul.f64 fd158, fd151, fd151;
mul.f64 fd159, fd152, fd152;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd152, fd151;
fma.rn.f64 fd162, fd152, fd151, fd161;
mul.f64 fd163, fd146, fd162;
mul.f64 fd164, fd145, fd162;
mul.f64 fd165, fd160, fd146;
ld.global.v2.f64 {fd166, fd167}, [rd11+256];
mul.f64 fd170, fd150, fd167;
mul.f64 fd171, fd149, fd167;
mul.f64 fd172, fd166, fd150;
and.b32 r22, r10, 240;
add.s32 r23, r9, r22;
barrier.sync 0;
and.b32 r24, r7, 15360;
add.s32 r25, r23, r24;
add.f64 fd173, fd138, fd142;
add.f64 fd174, fd137, fd141;
st.shared.v2.f64 [r25], {fd174, fd173};
fma.rn.f64 fd175, fd151, fd147, fd155;
sub.f64 fd176, fd157, fd156;
st.shared.v2.f64 [r25+256], {fd175, fd176};
fma.rn.f64 fd177, fd160, fd145, fd163;
sub.f64 fd178, fd165, fd164;
st.shared.v2.f64 [r25+512], {fd177, fd178};
fma.rn.f64 fd179, fd166, fd149, fd170;
sub.f64 fd180, fd172, fd171;
st.shared.v2.f64 [r25+768], {fd179, fd180};
barrier.sync 0;
mad.lo.s32 r26, r21, -48, r25;
ld.shared.v2.f64 {fd181, fd182}, [r26];
ld.shared.v2.f64 {fd185, fd186}, [r26+4096];
ld.shared.v2.f64 {fd189, fd190}, [r26+8192];
ld.shared.v2.f64 {fd193, fd194}, [r26+12288];
add.f64 fd197, fd181, fd189;
add.f64 fd198, fd182, fd190;
sub.f64 fd199, fd181, fd189;
sub.f64 fd200, fd182, fd190;
add.f64 fd201, fd185, fd193;
add.f64 fd202, fd186, fd194;
sub.f64 fd203, fd185, fd193;
sub.f64 fd204, fd186, fd194;
sub.f64 fd205, fd197, fd201;
sub.f64 fd206, fd198, fd202;
sub.f64 fd207, fd199, fd204;
add.f64 fd208, fd200, fd203;
add.f64 fd209, fd199, fd204;
sub.f64 fd210, fd200, fd203;
and.b32 r27, r5, 192;
bfe.u32 r28, r5, 6, 2;
mul.wide.u32 rd12, r28, 16;
mov.u64 rd13, %12;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd211, fd212}, [rd14];
mul.f64 fd215, fd208, fd212;
mul.f64 fd216, fd207, fd212;
mul.f64 fd217, fd211, fd208;
mul.f64 fd218, fd211, fd211;
mul.f64 fd219, fd212, fd212;
sub.f64 fd220, fd218, fd219;
mul.f64 fd221, fd212, fd211;
fma.rn.f64 fd222, fd212, fd211, fd221;
mul.f64 fd223, fd206, fd222;
mul.f64 fd224, fd205, fd222;
mul.f64 fd225, fd220, fd206;
ld.global.v2.f64 {fd226, fd227}, [rd14+64];
mul.f64 fd230, fd210, fd227;
mul.f64 fd231, fd209, fd227;
mul.f64 fd232, fd226, fd210;
and.b32 r29, r10, 1008;
add.s32 r30, r9, r29;
barrier.sync 0;
and.b32 r31, r7, 12288;
add.s32 r32, r30, r31;
add.f64 fd233, fd198, fd202;
add.f64 fd234, fd197, fd201;
st.shared.v2.f64 [r32], {fd234, fd233};
fma.rn.f64 fd235, fd211, fd207, fd215;
sub.f64 fd236, fd217, fd216;
st.shared.v2.f64 [r32+1024], {fd235, fd236};
fma.rn.f64 fd237, fd220, fd205, fd223;
sub.f64 fd238, fd225, fd224;
st.shared.v2.f64 [r32+2048], {fd237, fd238};
fma.rn.f64 fd239, fd226, fd209, fd230;
sub.f64 fd240, fd232, fd231;
st.shared.v2.f64 [r32+3072], {fd239, fd240};
barrier.sync 0;
mad.lo.s32 r33, r27, -48, r32;
ld.shared.v2.f64 {fd241, fd242}, [r33];
ld.shared.v2.f64 {fd245, fd246}, [r33+4096];
ld.shared.v2.f64 {fd249, fd250}, [r33+8192];
ld.shared.v2.f64 {fd253, fd254}, [r33+12288];
add.f64 fd257, fd241, fd249;
add.f64 fd258, fd242, fd250;
sub.f64 fd259, fd241, fd249;
sub.f64 fd260, fd242, fd250;
add.f64 fd261, fd245, fd253;
add.f64 fd262, fd246, fd254;
sub.f64 fd263, fd245, fd253;
sub.f64 fd264, fd246, fd254;
add.f64 %1, fd258, fd262;
add.f64 %0, fd257, fd261;
add.f64 %3, fd260, fd263;
sub.f64 %2, fd259, fd264;
sub.f64 %5, fd258, fd262;
sub.f64 %4, fd257, fd261;
sub.f64 %7, fd260, fd263;
add.f64 %6, fd259, fd264;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y): "r"(smem), "l"(lut_dp_4_1024), "l"(lut_dp_4_256), "l"(lut_dp_4_64), "l"(lut_dp_4_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<652, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<520>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %20, %30;
add.f64 fd34, %21, %32;
sub.f64 fd35, %20, %30;
sub.f64 fd36, %21, %32;
add.f64 fd37, %25, %36;
add.f64 fd38, %27, %37;
sub.f64 fd39, %25, %36;
sub.f64 fd40, %27, %37;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
sub.f64 fd45, fd35, fd40;
add.f64 fd46, fd36, fd39;
add.f64 fd47, fd35, fd40;
sub.f64 fd48, fd36, fd39;
add.f64 fd49, %22, %33;
add.f64 fd50, %24, %35;
sub.f64 fd51, %22, %33;
sub.f64 fd52, %24, %35;
add.f64 fd53, %28, %38;
add.f64 fd54, %29, %39;
sub.f64 fd55, %28, %38;
sub.f64 fd56, %29, %39;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
sub.f64 fd61, fd51, fd56;
add.f64 fd62, fd52, fd55;
add.f64 fd63, fd51, fd56;
sub.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0d3FE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
add.f64 fd68, fd65, fd66;
mul.f64 fd69, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd70, fd64, 0d3FE6A09E667F3BCD;
sub.f64 fd71, fd69, fd70;
mul.f64 fd72, fd64, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd73, fd63, 0d3FE6A09E667F3BCD, fd72;
sub.f64 fd74, fd41, fd57;
sub.f64 fd75, fd42, fd58;
add.f64 fd76, fd45, fd67;
add.f64 fd77, fd46, fd68;
sub.f64 fd78, fd45, fd67;
sub.f64 fd79, fd46, fd68;
sub.f64 fd80, fd43, fd60;
add.f64 fd81, fd44, fd59;
add.f64 fd82, fd43, fd60;
sub.f64 fd83, fd44, fd59;
add.f64 fd84, fd47, fd71;
add.f64 fd85, fd48, fd73;
sub.f64 fd86, fd47, fd71;
sub.f64 fd87, fd48, fd73;
and.b32 r6, r5, 127;
shl.b32 r7, r5, 7;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 2032;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd88, fd89}, [rd5];
mul.f64 fd92, fd77, fd89;
mul.f64 fd93, fd76, fd89;
mul.f64 fd94, fd88, fd77;
mul.f64 fd95, fd88, fd88;
mul.f64 fd96, fd89, fd89;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd89, fd88;
fma.rn.f64 fd99, fd89, fd88, fd98;
mul.f64 fd100, fd81, fd99;
mul.f64 fd101, fd80, fd99;
mul.f64 fd102, fd97, fd81;
mul.f64 fd103, fd88, fd97;
mul.f64 fd104, fd89, fd99;
sub.f64 fd105, fd103, fd104;
mul.f64 fd106, fd88, fd99;
fma.rn.f64 fd107, fd89, fd97, fd106;
mul.f64 fd108, fd85, fd107;
mul.f64 fd109, fd84, fd107;
mul.f64 fd110, fd105, fd85;
mul.f64 fd111, fd88, fd105;
mul.f64 fd112, fd89, fd107;
sub.f64 fd113, fd111, fd112;
mul.f64 fd114, fd88, fd107;
fma.rn.f64 fd115, fd89, fd105, fd114;
mul.f64 fd116, fd75, fd115;
mul.f64 fd117, fd74, fd115;
mul.f64 fd118, fd113, fd75;
ld.global.v2.f64 {fd119, fd120}, [rd5+2048];
mul.f64 fd123, fd79, fd120;
mul.f64 fd124, fd78, fd120;
mul.f64 fd125, fd119, fd79;
mul.f64 fd126, fd88, fd119;
mul.f64 fd127, fd89, fd120;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd88, fd120;
fma.rn.f64 fd130, fd89, fd119, fd129;
mul.f64 fd131, fd83, fd130;
mul.f64 fd132, fd82, fd130;
mul.f64 fd133, fd128, fd83;
mul.f64 fd134, fd88, fd128;
mul.f64 fd135, fd89, fd130;
sub.f64 fd136, fd134, fd135;
mul.f64 fd137, fd88, fd130;
fma.rn.f64 fd138, fd89, fd128, fd137;
mul.f64 fd139, fd87, fd138;
mul.f64 fd140, fd86, fd138;
mul.f64 fd141, fd136, fd87;
barrier.sync 0;
and.b32 r11, r7, 16256;
add.s32 r12, r9, r11;
add.f64 fd142, fd42, fd58;
add.f64 fd143, fd41, fd57;
st.shared.v2.f64 [r12], {fd143, fd142};
fma.rn.f64 fd144, fd88, fd76, fd92;
sub.f64 fd145, fd94, fd93;
st.shared.v2.f64 [r12+16], {fd144, fd145};
fma.rn.f64 fd146, fd97, fd80, fd100;
sub.f64 fd147, fd102, fd101;
st.shared.v2.f64 [r12+32], {fd146, fd147};
sub.f64 fd148, fd110, fd109;
fma.rn.f64 fd149, fd105, fd84, fd108;
st.shared.v2.f64 [r12+48], {fd149, fd148};
fma.rn.f64 fd150, fd113, fd74, fd116;
sub.f64 fd151, fd118, fd117;
st.shared.v2.f64 [r12+64], {fd150, fd151};
fma.rn.f64 fd152, fd119, fd78, fd123;
sub.f64 fd153, fd125, fd124;
st.shared.v2.f64 [r12+80], {fd152, fd153};
fma.rn.f64 fd154, fd128, fd82, fd131;
sub.f64 fd155, fd133, fd132;
st.shared.v2.f64 [r12+96], {fd154, fd155};
sub.f64 fd156, fd141, fd140;
fma.rn.f64 fd157, fd136, fd86, fd139;
st.shared.v2.f64 [r12+112], {fd157, fd156};
barrier.sync 0;
mad.lo.s32 r13, r6, -112, r12;
ld.shared.v2.f64 {fd158, fd159}, [r13];
ld.shared.v2.f64 {fd162, fd163}, [r13+2048];
ld.shared.v2.f64 {fd166, fd167}, [r13+4096];
ld.shared.v2.f64 {fd170, fd171}, [r13+6144];
ld.shared.v2.f64 {fd174, fd175}, [r13+8192];
ld.shared.v2.f64 {fd178, fd179}, [r13+10240];
ld.shared.v2.f64 {fd182, fd183}, [r13+12288];
ld.shared.v2.f64 {fd186, fd187}, [r13+14336];
add.f64 fd190, fd158, fd174;
add.f64 fd191, fd159, fd175;
sub.f64 fd192, fd158, fd174;
sub.f64 fd193, fd159, fd175;
add.f64 fd194, fd166, fd182;
add.f64 fd195, fd167, fd183;
sub.f64 fd196, fd166, fd182;
sub.f64 fd197, fd167, fd183;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
sub.f64 fd202, fd192, fd197;
add.f64 fd203, fd193, fd196;
add.f64 fd204, fd192, fd197;
sub.f64 fd205, fd193, fd196;
add.f64 fd206, fd162, fd178;
add.f64 fd207, fd163, fd179;
sub.f64 fd208, fd162, fd178;
sub.f64 fd209, fd163, fd179;
add.f64 fd210, fd170, fd186;
add.f64 fd211, fd171, fd187;
sub.f64 fd212, fd170, fd186;
sub.f64 fd213, fd171, fd187;
add.f64 fd214, fd206, fd210;
add.f64 fd215, fd207, fd211;
sub.f64 fd216, fd206, fd210;
sub.f64 fd217, fd207, fd211;
sub.f64 fd218, fd208, fd213;
add.f64 fd219, fd209, fd212;
add.f64 fd220, fd208, fd213;
sub.f64 fd221, fd209, fd212;
mul.f64 fd222, fd218, 0d3FE6A09E667F3BCD;
mul.f64 fd223, fd219, 0d3FE6A09E667F3BCD;
sub.f64 fd224, fd222, fd223;
add.f64 fd225, fd222, fd223;
mul.f64 fd226, fd220, 0dBFE6A09E667F3BCD;
mul.f64 fd227, fd221, 0d3FE6A09E667F3BCD;
sub.f64 fd228, fd226, fd227;
mul.f64 fd229, fd221, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd230, fd220, 0d3FE6A09E667F3BCD, fd229;
sub.f64 fd231, fd198, fd214;
sub.f64 fd232, fd199, fd215;
add.f64 fd233, fd202, fd224;
add.f64 fd234, fd203, fd225;
sub.f64 fd235, fd202, fd224;
sub.f64 fd236, fd203, fd225;
sub.f64 fd237, fd200, fd217;
add.f64 fd238, fd201, fd216;
add.f64 fd239, fd200, fd217;
sub.f64 fd240, fd201, fd216;
add.f64 fd241, fd204, fd228;
add.f64 fd242, fd205, fd230;
sub.f64 fd243, fd204, fd228;
sub.f64 fd244, fd205, fd230;
and.b32 r14, r5, 120;
bfe.u32 r15, r5, 3, 4;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd245, fd246}, [rd8];
mul.f64 fd249, fd234, fd246;
mul.f64 fd250, fd233, fd246;
mul.f64 fd251, fd245, fd234;
mul.f64 fd252, fd245, fd245;
mul.f64 fd253, fd246, fd246;
sub.f64 fd254, fd252, fd253;
mul.f64 fd255, fd246, fd245;
fma.rn.f64 fd256, fd246, fd245, fd255;
mul.f64 fd257, fd238, fd256;
mul.f64 fd258, fd237, fd256;
mul.f64 fd259, fd254, fd238;
mul.f64 fd260, fd245, fd254;
mul.f64 fd261, fd246, fd256;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd245, fd256;
fma.rn.f64 fd264, fd246, fd254, fd263;
mul.f64 fd265, fd242, fd264;
mul.f64 fd266, fd241, fd264;
mul.f64 fd267, fd262, fd242;
mul.f64 fd268, fd245, fd262;
mul.f64 fd269, fd246, fd264;
sub.f64 fd270, fd268, fd269;
mul.f64 fd271, fd245, fd264;
fma.rn.f64 fd272, fd246, fd262, fd271;
mul.f64 fd273, fd232, fd272;
mul.f64 fd274, fd231, fd272;
mul.f64 fd275, fd270, fd232;
ld.global.v2.f64 {fd276, fd277}, [rd8+256];
mul.f64 fd280, fd236, fd277;
mul.f64 fd281, fd235, fd277;
mul.f64 fd282, fd276, fd236;
mul.f64 fd283, fd245, fd276;
mul.f64 fd284, fd246, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd245, fd277;
fma.rn.f64 fd287, fd246, fd276, fd286;
mul.f64 fd288, fd240, fd287;
mul.f64 fd289, fd239, fd287;
mul.f64 fd290, fd285, fd240;
mul.f64 fd291, fd245, fd285;
mul.f64 fd292, fd246, fd287;
sub.f64 fd293, fd291, fd292;
mul.f64 fd294, fd245, fd287;
fma.rn.f64 fd295, fd246, fd285, fd294;
mul.f64 fd296, fd244, fd295;
mul.f64 fd297, fd243, fd295;
mul.f64 fd298, fd293, fd244;
and.b32 r16, r10, 112;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 15360;
add.s32 r19, r17, r18;
add.f64 fd299, fd199, fd215;
add.f64 fd300, fd198, fd214;
st.shared.v2.f64 [r19], {fd300, fd299};
fma.rn.f64 fd301, fd245, fd233, fd249;
sub.f64 fd302, fd251, fd250;
st.shared.v2.f64 [r19+128], {fd301, fd302};
fma.rn.f64 fd303, fd254, fd237, fd257;
sub.f64 fd304, fd259, fd258;
st.shared.v2.f64 [r19+256], {fd303, fd304};
fma.rn.f64 fd305, fd262, fd241, fd265;
sub.f64 fd306, fd267, fd266;
st.shared.v2.f64 [r19+384], {fd305, fd306};
sub.f64 fd307, fd275, fd274;
fma.rn.f64 fd308, fd270, fd231, fd273;
st.shared.v2.f64 [r19+512], {fd308, fd307};
fma.rn.f64 fd309, fd276, fd235, fd280;
sub.f64 fd310, fd282, fd281;
st.shared.v2.f64 [r19+640], {fd309, fd310};
fma.rn.f64 fd311, fd285, fd239, fd288;
sub.f64 fd312, fd290, fd289;
st.shared.v2.f64 [r19+768], {fd311, fd312};
fma.rn.f64 fd313, fd293, fd243, fd296;
sub.f64 fd314, fd298, fd297;
st.shared.v2.f64 [r19+896], {fd313, fd314};
barrier.sync 0;
mad.lo.s32 r20, r14, -112, r19;
ld.shared.v2.f64 {fd315, fd316}, [r20];
ld.shared.v2.f64 {fd319, fd320}, [r20+2048];
ld.shared.v2.f64 {fd323, fd324}, [r20+4096];
ld.shared.v2.f64 {fd327, fd328}, [r20+6144];
ld.shared.v2.f64 {fd331, fd332}, [r20+8192];
ld.shared.v2.f64 {fd335, fd336}, [r20+10240];
ld.shared.v2.f64 {fd339, fd340}, [r20+12288];
ld.shared.v2.f64 {fd343, fd344}, [r20+14336];
add.f64 fd347, fd315, fd331;
add.f64 fd348, fd316, fd332;
sub.f64 fd349, fd315, fd331;
sub.f64 fd350, fd316, fd332;
add.f64 fd351, fd323, fd339;
add.f64 fd352, fd324, fd340;
sub.f64 fd353, fd323, fd339;
sub.f64 fd354, fd324, fd340;
add.f64 fd355, fd347, fd351;
add.f64 fd356, fd348, fd352;
sub.f64 fd357, fd347, fd351;
sub.f64 fd358, fd348, fd352;
sub.f64 fd359, fd349, fd354;
add.f64 fd360, fd350, fd353;
add.f64 fd361, fd349, fd354;
sub.f64 fd362, fd350, fd353;
add.f64 fd363, fd319, fd335;
add.f64 fd364, fd320, fd336;
sub.f64 fd365, fd319, fd335;
sub.f64 fd366, fd320, fd336;
add.f64 fd367, fd327, fd343;
add.f64 fd368, fd328, fd344;
sub.f64 fd369, fd327, fd343;
sub.f64 fd370, fd328, fd344;
add.f64 fd371, fd363, fd367;
add.f64 fd372, fd364, fd368;
sub.f64 fd373, fd363, fd367;
sub.f64 fd374, fd364, fd368;
sub.f64 fd375, fd365, fd370;
add.f64 fd376, fd366, fd369;
add.f64 fd377, fd365, fd370;
sub.f64 fd378, fd366, fd369;
mul.f64 fd379, fd375, 0d3FE6A09E667F3BCD;
mul.f64 fd380, fd376, 0d3FE6A09E667F3BCD;
sub.f64 fd381, fd379, fd380;
add.f64 fd382, fd379, fd380;
mul.f64 fd383, fd377, 0dBFE6A09E667F3BCD;
mul.f64 fd384, fd378, 0d3FE6A09E667F3BCD;
sub.f64 fd385, fd383, fd384;
mul.f64 fd386, fd378, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd387, fd377, 0d3FE6A09E667F3BCD, fd386;
sub.f64 fd388, fd355, fd371;
sub.f64 fd389, fd356, fd372;
add.f64 fd390, fd359, fd381;
add.f64 fd391, fd360, fd382;
sub.f64 fd392, fd359, fd381;
sub.f64 fd393, fd360, fd382;
sub.f64 fd394, fd357, fd374;
add.f64 fd395, fd358, fd373;
add.f64 fd396, fd357, fd374;
sub.f64 fd397, fd358, fd373;
add.f64 fd398, fd361, fd385;
add.f64 fd399, fd362, fd387;
sub.f64 fd400, fd361, fd385;
sub.f64 fd401, fd362, fd387;
and.b32 r21, r5, 64;
bfe.u32 r22, r5, 6, 1;
mul.wide.u32 rd9, r22, 16;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd402, fd403}, [rd11];
mul.f64 fd406, fd391, fd403;
mul.f64 fd407, fd390, fd403;
mul.f64 fd408, fd402, fd391;
mul.f64 fd409, fd402, fd402;
mul.f64 fd410, fd403, fd403;
sub.f64 fd411, fd409, fd410;
mul.f64 fd412, fd403, fd402;
fma.rn.f64 fd413, fd403, fd402, fd412;
mul.f64 fd414, fd395, fd413;
mul.f64 fd415, fd394, fd413;
mul.f64 fd416, fd411, fd395;
mul.f64 fd417, fd402, fd411;
mul.f64 fd418, fd403, fd413;
sub.f64 fd419, fd417, fd418;
mul.f64 fd420, fd402, fd413;
fma.rn.f64 fd421, fd403, fd411, fd420;
mul.f64 fd422, fd399, fd421;
mul.f64 fd423, fd398, fd421;
mul.f64 fd424, fd419, fd399;
mul.f64 fd425, fd402, fd419;
mul.f64 fd426, fd403, fd421;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd402, fd421;
fma.rn.f64 fd429, fd403, fd419, fd428;
mul.f64 fd430, fd389, fd429;
mul.f64 fd431, fd388, fd429;
mul.f64 fd432, fd427, fd389;
ld.global.v2.f64 {fd433, fd434}, [rd11+32];
mul.f64 fd437, fd393, fd434;
mul.f64 fd438, fd392, fd434;
mul.f64 fd439, fd433, fd393;
mul.f64 fd440, fd402, fd433;
mul.f64 fd441, fd403, fd434;
sub.f64 fd442, fd440, fd441;
mul.f64 fd443, fd402, fd434;
fma.rn.f64 fd444, fd403, fd433, fd443;
mul.f64 fd445, fd397, fd444;
mul.f64 fd446, fd396, fd444;
mul.f64 fd447, fd442, fd397;
mul.f64 fd448, fd402, fd442;
mul.f64 fd449, fd403, fd444;
sub.f64 fd450, fd448, fd449;
mul.f64 fd451, fd402, fd444;
fma.rn.f64 fd452, fd403, fd442, fd451;
mul.f64 fd453, fd401, fd452;
mul.f64 fd454, fd400, fd452;
mul.f64 fd455, fd450, fd401;
and.b32 r23, r10, 1008;
add.s32 r24, r9, r23;
barrier.sync 0;
and.b32 r25, r7, 8192;
add.s32 r26, r24, r25;
add.f64 fd456, fd356, fd372;
add.f64 fd457, fd355, fd371;
st.shared.v2.f64 [r26], {fd457, fd456};
fma.rn.f64 fd458, fd402, fd390, fd406;
sub.f64 fd459, fd408, fd407;
st.shared.v2.f64 [r26+1024], {fd458, fd459};
fma.rn.f64 fd460, fd411, fd394, fd414;
sub.f64 fd461, fd416, fd415;
st.shared.v2.f64 [r26+2048], {fd460, fd461};
fma.rn.f64 fd462, fd419, fd398, fd422;
sub.f64 fd463, fd424, fd423;
st.shared.v2.f64 [r26+3072], {fd462, fd463};
sub.f64 fd464, fd432, fd431;
fma.rn.f64 fd465, fd427, fd388, fd430;
st.shared.v2.f64 [r26+4096], {fd465, fd464};
fma.rn.f64 fd466, fd433, fd392, fd437;
sub.f64 fd467, fd439, fd438;
st.shared.v2.f64 [r26+5120], {fd466, fd467};
fma.rn.f64 fd468, fd442, fd396, fd445;
sub.f64 fd469, fd447, fd446;
st.shared.v2.f64 [r26+6144], {fd468, fd469};
fma.rn.f64 fd470, fd450, fd400, fd453;
sub.f64 fd471, fd455, fd454;
st.shared.v2.f64 [r26+7168], {fd470, fd471};
barrier.sync 0;
mad.lo.s32 r27, r21, -112, r26;
ld.shared.v2.f64 {fd472, fd473}, [r27];
ld.shared.v2.f64 {fd476, fd477}, [r27+2048];
ld.shared.v2.f64 {fd480, fd481}, [r27+4096];
ld.shared.v2.f64 {fd484, fd485}, [r27+6144];
ld.shared.v2.f64 {fd488, fd489}, [r27+8192];
ld.shared.v2.f64 {fd492, fd493}, [r27+10240];
ld.shared.v2.f64 {fd496, fd497}, [r27+12288];
ld.shared.v2.f64 {fd500, fd501}, [r27+14336];
add.f64 %1, fd473, fd489;
add.f64 %0, fd472, fd488;
add.f64 %3, fd477, fd493;
add.f64 %2, fd476, fd492;
add.f64 %5, fd481, fd497;
add.f64 %4, fd480, fd496;
add.f64 %7, fd485, fd501;
add.f64 %6, fd484, fd500;
sub.f64 %9, fd473, fd489;
sub.f64 %8, fd472, fd488;
sub.f64 %11, fd477, fd493;
sub.f64 %10, fd476, fd492;
sub.f64 %13, fd481, fd497;
sub.f64 %12, fd480, fd496;
sub.f64 %15, fd485, fd501;
sub.f64 %14, fd484, fd500;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_1024), "l"(lut_dp_8_128), "l"(lut_dp_8_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<654, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<70>;
.reg .f64 fd<166>;
.reg .b64 rd<30>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd9, %14, %16;
add.f64 fd10, %15, %17;
sub.f64 fd11, %14, %16;
sub.f64 fd12, %15, %17;
shl.b32 r6, r5, 4;
cvt.u64.u32 rd2, r6;
and.b64 rd3, rd2, 8176;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd13, fd14}, [rd5];
mul.f64 fd17, fd12, fd14;
fma.rn.f64 fd18, fd13, fd11, fd17;
mul.f64 fd19, fd11, fd14;
mul.f64 fd20, fd13, fd12;
sub.f64 fd21, fd20, fd19;
and.b32 r7, r6, -8192;
add.s32 r8, r4, r7;
barrier.sync 0;
and.b32 r9, r6, 8176;
add.s32 r10, r8, r9;
st.shared.v2.f64 [r10], {fd9, fd18};
barrier.sync 0;
shl.b32 r11, r5, 3;
and.b32 r12, r11, 4088;
sub.s32 r13, r10, r12;
ld.shared.f64 fd22, [r13];
ld.shared.f64 fd23, [r13+4096];
barrier.sync 0;
st.shared.v2.f64 [r10], {fd10, fd21};
barrier.sync 0;
ld.shared.f64 fd24, [r13];
ld.shared.f64 fd25, [r13+4096];
add.f64 fd26, fd22, fd23;
add.f64 fd27, fd24, fd25;
sub.f64 fd28, fd22, fd23;
sub.f64 fd29, fd24, fd25;
bfe.u32 r14, r5, 1, 8;
mul.wide.u32 rd6, r14, 16;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd30, fd31}, [rd8];
mul.f64 fd34, fd29, fd31;
fma.rn.f64 fd35, fd30, fd28, fd34;
mul.f64 fd36, fd28, fd31;
mul.f64 fd37, fd30, fd29;
sub.f64 fd38, fd37, fd36;
and.b32 r15, r11, 8;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 8160;
add.s32 r18, r16, r17;
st.shared.f64 [r18], fd26;
st.shared.f64 [r18+16], fd35;
barrier.sync 0;
and.b32 r19, r11, 4080;
sub.s32 r20, r18, r19;
ld.shared.f64 fd39, [r20];
ld.shared.f64 fd40, [r20+4096];
barrier.sync 0;
st.shared.f64 [r18], fd27;
st.shared.f64 [r18+16], fd38;
barrier.sync 0;
ld.shared.f64 fd41, [r20];
ld.shared.f64 fd42, [r20+4096];
add.f64 fd43, fd39, fd40;
add.f64 fd44, fd41, fd42;
sub.f64 fd45, fd39, fd40;
sub.f64 fd46, fd41, fd42;
bfe.u32 r21, r5, 2, 7;
mul.wide.u32 rd9, r21, 16;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd47, fd48}, [rd11];
mul.f64 fd51, fd46, fd48;
fma.rn.f64 fd52, fd47, fd45, fd51;
mul.f64 fd53, fd45, fd48;
mul.f64 fd54, fd47, fd46;
sub.f64 fd55, fd54, fd53;
and.b32 r22, r11, 24;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 8128;
add.s32 r25, r23, r24;
st.shared.f64 [r25], fd43;
st.shared.f64 [r25+32], fd52;
barrier.sync 0;
and.b32 r26, r11, 4064;
sub.s32 r27, r25, r26;
ld.shared.f64 fd56, [r27];
ld.shared.f64 fd57, [r27+4096];
barrier.sync 0;
st.shared.f64 [r25], fd44;
st.shared.f64 [r25+32], fd55;
barrier.sync 0;
ld.shared.f64 fd58, [r27];
ld.shared.f64 fd59, [r27+4096];
add.f64 fd60, fd56, fd57;
add.f64 fd61, fd58, fd59;
sub.f64 fd62, fd56, fd57;
sub.f64 fd63, fd58, fd59;
bfe.u32 r28, r5, 3, 6;
mul.wide.u32 rd12, r28, 16;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd64, fd65}, [rd14];
mul.f64 fd68, fd63, fd65;
fma.rn.f64 fd69, fd64, fd62, fd68;
mul.f64 fd70, fd62, fd65;
mul.f64 fd71, fd64, fd63;
sub.f64 fd72, fd71, fd70;
and.b32 r29, r11, 56;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 8064;
add.s32 r32, r30, r31;
st.shared.f64 [r32], fd60;
st.shared.f64 [r32+64], fd69;
barrier.sync 0;
and.b32 r33, r11, 4032;
sub.s32 r34, r32, r33;
ld.shared.f64 fd73, [r34];
ld.shared.f64 fd74, [r34+4096];
barrier.sync 0;
st.shared.f64 [r32], fd61;
st.shared.f64 [r32+64], fd72;
barrier.sync 0;
ld.shared.f64 fd75, [r34];
ld.shared.f64 fd76, [r34+4096];
add.f64 fd77, fd73, fd74;
add.f64 fd78, fd75, fd76;
sub.f64 fd79, fd73, fd74;
sub.f64 fd80, fd75, fd76;
and.b32 r35, r5, 496;
cvt.u64.u32 rd15, r35;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f64 {fd81, fd82}, [rd17];
mul.f64 fd85, fd80, fd82;
fma.rn.f64 fd86, fd81, fd79, fd85;
mul.f64 fd87, fd79, fd82;
mul.f64 fd88, fd81, fd80;
sub.f64 fd89, fd88, fd87;
and.b32 r36, r11, 120;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 7936;
add.s32 r39, r37, r38;
st.shared.f64 [r39], fd77;
st.shared.f64 [r39+128], fd86;
barrier.sync 0;
and.b32 r40, r11, 3968;
sub.s32 r41, r39, r40;
ld.shared.f64 fd90, [r41];
ld.shared.f64 fd91, [r41+4096];
barrier.sync 0;
st.shared.f64 [r39], fd78;
st.shared.f64 [r39+128], fd89;
barrier.sync 0;
ld.shared.f64 fd92, [r41];
ld.shared.f64 fd93, [r41+4096];
add.f64 fd94, fd90, fd91;
add.f64 fd95, fd92, fd93;
sub.f64 fd96, fd90, fd91;
sub.f64 fd97, fd92, fd93;
bfe.u32 r42, r5, 5, 4;
mul.wide.u32 rd18, r42, 16;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f64 {fd98, fd99}, [rd20];
mul.f64 fd102, fd97, fd99;
fma.rn.f64 fd103, fd98, fd96, fd102;
mul.f64 fd104, fd96, fd99;
mul.f64 fd105, fd98, fd97;
sub.f64 fd106, fd105, fd104;
and.b32 r43, r11, 248;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 7680;
add.s32 r46, r44, r45;
st.shared.f64 [r46], fd94;
st.shared.f64 [r46+256], fd103;
barrier.sync 0;
and.b32 r47, r11, 3840;
sub.s32 r48, r46, r47;
ld.shared.f64 fd107, [r48];
ld.shared.f64 fd108, [r48+4096];
barrier.sync 0;
st.shared.f64 [r46], fd95;
st.shared.f64 [r46+256], fd106;
barrier.sync 0;
ld.shared.f64 fd109, [r48];
ld.shared.f64 fd110, [r48+4096];
add.f64 fd111, fd107, fd108;
add.f64 fd112, fd109, fd110;
sub.f64 fd113, fd107, fd108;
sub.f64 fd114, fd109, fd110;
bfe.u32 r49, r5, 6, 3;
mul.wide.u32 rd21, r49, 16;
mov.u64 rd22, %11;
add.s64 rd23, rd22, rd21;
ld.global.v2.f64 {fd115, fd116}, [rd23];
mul.f64 fd119, fd114, fd116;
fma.rn.f64 fd120, fd115, fd113, fd119;
mul.f64 fd121, fd113, fd116;
mul.f64 fd122, fd115, fd114;
sub.f64 fd123, fd122, fd121;
and.b32 r50, r11, 504;
add.s32 r51, r8, r50;
barrier.sync 0;
and.b32 r52, r6, 7168;
add.s32 r53, r51, r52;
st.shared.f64 [r53], fd111;
st.shared.f64 [r53+512], fd120;
barrier.sync 0;
and.b32 r54, r11, 3584;
sub.s32 r55, r53, r54;
ld.shared.f64 fd124, [r55];
ld.shared.f64 fd125, [r55+4096];
barrier.sync 0;
st.shared.f64 [r53], fd112;
st.shared.f64 [r53+512], fd123;
barrier.sync 0;
ld.shared.f64 fd126, [r55];
ld.shared.f64 fd127, [r55+4096];
add.f64 fd128, fd124, fd125;
add.f64 fd129, fd126, fd127;
sub.f64 fd130, fd124, fd125;
sub.f64 fd131, fd126, fd127;
bfe.u32 r56, r5, 7, 2;
mul.wide.u32 rd24, r56, 16;
mov.u64 rd25, %12;
add.s64 rd26, rd25, rd24;
ld.global.v2.f64 {fd132, fd133}, [rd26];
mul.f64 fd136, fd131, fd133;
fma.rn.f64 fd137, fd132, fd130, fd136;
mul.f64 fd138, fd130, fd133;
mul.f64 fd139, fd132, fd131;
sub.f64 fd140, fd139, fd138;
and.b32 r57, r11, 1016;
add.s32 r58, r8, r57;
barrier.sync 0;
and.b32 r59, r6, 6144;
add.s32 r60, r58, r59;
st.shared.f64 [r60], fd128;
st.shared.f64 [r60+1024], fd137;
barrier.sync 0;
and.b32 r61, r11, 3072;
sub.s32 r62, r60, r61;
ld.shared.f64 fd141, [r62];
ld.shared.f64 fd142, [r62+4096];
barrier.sync 0;
st.shared.f64 [r60], fd129;
st.shared.f64 [r60+1024], fd140;
barrier.sync 0;
ld.shared.f64 fd143, [r62];
ld.shared.f64 fd144, [r62+4096];
add.f64 fd145, fd141, fd142;
add.f64 fd146, fd143, fd144;
sub.f64 fd147, fd141, fd142;
sub.f64 fd148, fd143, fd144;
bfe.u32 r63, r5, 8, 1;
mul.wide.u32 rd27, r63, 16;
mov.u64 rd28, %13;
add.s64 rd29, rd28, rd27;
ld.global.v2.f64 {fd149, fd150}, [rd29];
mul.f64 fd153, fd148, fd150;
fma.rn.f64 fd154, fd149, fd147, fd153;
mul.f64 fd155, fd147, fd150;
mul.f64 fd156, fd149, fd148;
sub.f64 fd157, fd156, fd155;
and.b32 r64, r11, 2040;
add.s32 r65, r8, r64;
barrier.sync 0;
and.b32 r66, r6, 4096;
add.s32 r67, r65, r66;
st.shared.f64 [r67], fd145;
st.shared.f64 [r67+2048], fd154;
barrier.sync 0;
and.b32 r68, r11, 2048;
sub.s32 r69, r67, r68;
ld.shared.f64 fd158, [r69];
ld.shared.f64 fd159, [r69+4096];
barrier.sync 0;
st.shared.f64 [r67], fd146;
st.shared.f64 [r67+2048], fd157;
barrier.sync 0;
ld.shared.f64 fd160, [r69];
ld.shared.f64 fd161, [r69+4096];
add.f64 %0, fd158, fd159;
add.f64 %1, fd160, fd161;
sub.f64 %2, fd158, fd159;
sub.f64 %3, fd160, fd161;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y): "r"(smem), "l"(lut_dp_2_1024), "l"(lut_dp_2_512), "l"(lut_dp_2_256), "l"(lut_dp_2_128), "l"(lut_dp_2_64), "l"(lut_dp_2_32), "l"(lut_dp_2_16), "l"(lut_dp_2_8), "l"(lut_dp_2_4), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<653, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<70>;
.reg .f64 fd<202>;
.reg .b64 rd<30>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
sub.f64 fd9, %14, %16;
sub.f64 fd10, %15, %17;
shl.b32 r6, r5, 5;
and.b32 r7, r6, -16384;
add.s32 r8, r4, r7;
shl.b32 r9, r5, 4;
cvt.u64.u32 rd2, r9;
and.b64 rd3, rd2, 8176;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd11, fd12}, [rd5];
mul.f64 fd15, fd10, fd12;
mul.f64 fd16, fd9, fd12;
mul.f64 fd17, fd11, fd10;
barrier.sync 0;
and.b32 r10, r6, 16352;
add.s32 r11, r8, r10;
add.f64 fd18, %15, %17;
add.f64 fd19, %14, %16;
st.shared.v2.f64 [r11], {fd19, fd18};
sub.f64 fd20, fd17, fd16;
fma.rn.f64 fd21, fd11, fd9, fd15;
st.shared.v2.f64 [r11+16], {fd21, fd20};
barrier.sync 0;
and.b32 r12, r9, 8176;
sub.s32 r13, r11, r12;
ld.shared.v2.f64 {fd22, fd23}, [r13];
ld.shared.v2.f64 {fd26, fd27}, [r13+8192];
sub.f64 fd30, fd22, fd26;
sub.f64 fd31, fd23, fd27;
bfe.u32 r14, r5, 1, 8;
mul.wide.u32 rd6, r14, 16;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd32, fd33}, [rd8];
mul.f64 fd36, fd31, fd33;
mul.f64 fd37, fd30, fd33;
mul.f64 fd38, fd32, fd31;
and.b32 r15, r9, 16;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 16320;
add.s32 r18, r16, r17;
add.f64 fd39, fd23, fd27;
add.f64 fd40, fd22, fd26;
st.shared.v2.f64 [r18], {fd40, fd39};
fma.rn.f64 fd41, fd32, fd30, fd36;
sub.f64 fd42, fd38, fd37;
st.shared.v2.f64 [r18+32], {fd41, fd42};
barrier.sync 0;
and.b32 r19, r9, 8160;
sub.s32 r20, r18, r19;
ld.shared.v2.f64 {fd43, fd44}, [r20];
ld.shared.v2.f64 {fd47, fd48}, [r20+8192];
sub.f64 fd51, fd43, fd47;
sub.f64 fd52, fd44, fd48;
bfe.u32 r21, r5, 2, 7;
mul.wide.u32 rd9, r21, 16;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd53, fd54}, [rd11];
mul.f64 fd57, fd52, fd54;
mul.f64 fd58, fd51, fd54;
mul.f64 fd59, fd53, fd52;
and.b32 r22, r9, 48;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 16256;
add.s32 r25, r23, r24;
add.f64 fd60, fd44, fd48;
add.f64 fd61, fd43, fd47;
st.shared.v2.f64 [r25], {fd61, fd60};
fma.rn.f64 fd62, fd53, fd51, fd57;
sub.f64 fd63, fd59, fd58;
st.shared.v2.f64 [r25+64], {fd62, fd63};
barrier.sync 0;
and.b32 r26, r9, 8128;
sub.s32 r27, r25, r26;
ld.shared.v2.f64 {fd64, fd65}, [r27];
ld.shared.v2.f64 {fd68, fd69}, [r27+8192];
sub.f64 fd72, fd64, fd68;
sub.f64 fd73, fd65, fd69;
bfe.u32 r28, r5, 3, 6;
mul.wide.u32 rd12, r28, 16;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd74, fd75}, [rd14];
mul.f64 fd78, fd73, fd75;
mul.f64 fd79, fd72, fd75;
mul.f64 fd80, fd74, fd73;
and.b32 r29, r9, 112;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 16128;
add.s32 r32, r30, r31;
add.f64 fd81, fd65, fd69;
add.f64 fd82, fd64, fd68;
st.shared.v2.f64 [r32], {fd82, fd81};
fma.rn.f64 fd83, fd74, fd72, fd78;
sub.f64 fd84, fd80, fd79;
st.shared.v2.f64 [r32+128], {fd83, fd84};
barrier.sync 0;
and.b32 r33, r9, 8064;
sub.s32 r34, r32, r33;
ld.shared.v2.f64 {fd85, fd86}, [r34];
ld.shared.v2.f64 {fd89, fd90}, [r34+8192];
sub.f64 fd93, fd85, fd89;
sub.f64 fd94, fd86, fd90;
and.b32 r35, r5, 496;
cvt.u64.u32 rd15, r35;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f64 {fd95, fd96}, [rd17];
mul.f64 fd99, fd94, fd96;
mul.f64 fd100, fd93, fd96;
mul.f64 fd101, fd95, fd94;
and.b32 r36, r9, 240;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 15872;
add.s32 r39, r37, r38;
add.f64 fd102, fd86, fd90;
add.f64 fd103, fd85, fd89;
st.shared.v2.f64 [r39], {fd103, fd102};
fma.rn.f64 fd104, fd95, fd93, fd99;
sub.f64 fd105, fd101, fd100;
st.shared.v2.f64 [r39+256], {fd104, fd105};
barrier.sync 0;
and.b32 r40, r9, 7936;
sub.s32 r41, r39, r40;
ld.shared.v2.f64 {fd106, fd107}, [r41];
ld.shared.v2.f64 {fd110, fd111}, [r41+8192];
sub.f64 fd114, fd106, fd110;
sub.f64 fd115, fd107, fd111;
bfe.u32 r42, r5, 5, 4;
mul.wide.u32 rd18, r42, 16;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f64 {fd116, fd117}, [rd20];
mul.f64 fd120, fd115, fd117;
mul.f64 fd121, fd114, fd117;
mul.f64 fd122, fd116, fd115;
and.b32 r43, r9, 496;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 15360;
add.s32 r46, r44, r45;
add.f64 fd123, fd107, fd111;
add.f64 fd124, fd106, fd110;
st.shared.v2.f64 [r46], {fd124, fd123};
fma.rn.f64 fd125, fd116, fd114, fd120;
sub.f64 fd126, fd122, fd121;
st.shared.v2.f64 [r46+512], {fd125, fd126};
barrier.sync 0;
and.b32 r47, r9, 7680;
sub.s32 r48, r46, r47;
ld.shared.v2.f64 {fd127, fd128}, [r48];
ld.shared.v2.f64 {fd131, fd132}, [r48+8192];
sub.f64 fd135, fd127, fd131;
sub.f64 fd136, fd128, fd132;
bfe.u32 r49, r5, 6, 3;
mul.wide.u32 rd21, r49, 16;
mov.u64 rd22, %11;
add.s64 rd23, rd22, rd21;
ld.global.v2.f64 {fd137, fd138}, [rd23];
mul.f64 fd141, fd136, fd138;
mul.f64 fd142, fd135, fd138;
mul.f64 fd143, fd137, fd136;
and.b32 r50, r9, 1008;
add.s32 r51, r8, r50;
barrier.sync 0;
and.b32 r52, r6, 14336;
add.s32 r53, r51, r52;
add.f64 fd144, fd128, fd132;
add.f64 fd145, fd127, fd131;
st.shared.v2.f64 [r53], {fd145, fd144};
fma.rn.f64 fd146, fd137, fd135, fd141;
sub.f64 fd147, fd143, fd142;
st.shared.v2.f64 [r53+1024], {fd146, fd147};
barrier.sync 0;
and.b32 r54, r9, 7168;
sub.s32 r55, r53, r54;
ld.shared.v2.f64 {fd148, fd149}, [r55];
ld.shared.v2.f64 {fd152, fd153}, [r55+8192];
sub.f64 fd156, fd148, fd152;
sub.f64 fd157, fd149, fd153;
bfe.u32 r56, r5, 7, 2;
mul.wide.u32 rd24, r56, 16;
mov.u64 rd25, %12;
add.s64 rd26, rd25, rd24;
ld.global.v2.f64 {fd158, fd159}, [rd26];
mul.f64 fd162, fd157, fd159;
mul.f64 fd163, fd156, fd159;
mul.f64 fd164, fd158, fd157;
and.b32 r57, r9, 2032;
add.s32 r58, r8, r57;
barrier.sync 0;
and.b32 r59, r6, 12288;
add.s32 r60, r58, r59;
add.f64 fd165, fd149, fd153;
add.f64 fd166, fd148, fd152;
st.shared.v2.f64 [r60], {fd166, fd165};
fma.rn.f64 fd167, fd158, fd156, fd162;
sub.f64 fd168, fd164, fd163;
st.shared.v2.f64 [r60+2048], {fd167, fd168};
barrier.sync 0;
and.b32 r61, r9, 6144;
sub.s32 r62, r60, r61;
ld.shared.v2.f64 {fd169, fd170}, [r62];
ld.shared.v2.f64 {fd173, fd174}, [r62+8192];
sub.f64 fd177, fd169, fd173;
sub.f64 fd178, fd170, fd174;
bfe.u32 r63, r5, 8, 1;
mul.wide.u32 rd27, r63, 16;
mov.u64 rd28, %13;
add.s64 rd29, rd28, rd27;
ld.global.v2.f64 {fd179, fd180}, [rd29];
mul.f64 fd183, fd178, fd180;
mul.f64 fd184, fd177, fd180;
mul.f64 fd185, fd179, fd178;
and.b32 r64, r9, 4080;
add.s32 r65, r8, r64;
barrier.sync 0;
and.b32 r66, r6, 8192;
add.s32 r67, r65, r66;
add.f64 fd186, fd170, fd174;
add.f64 fd187, fd169, fd173;
st.shared.v2.f64 [r67], {fd187, fd186};
fma.rn.f64 fd188, fd179, fd177, fd183;
sub.f64 fd189, fd185, fd184;
st.shared.v2.f64 [r67+4096], {fd188, fd189};
barrier.sync 0;
and.b32 r68, r9, 4096;
sub.s32 r69, r67, r68;
ld.shared.v2.f64 {fd190, fd191}, [r69];
ld.shared.v2.f64 {fd194, fd195}, [r69+8192];
add.f64 %1, fd191, fd195;
add.f64 %0, fd190, fd194;
sub.f64 %3, fd191, fd195;
sub.f64 %2, fd190, fd194;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y): "r"(smem), "l"(lut_dp_2_1024), "l"(lut_dp_2_512), "l"(lut_dp_2_256), "l"(lut_dp_2_128), "l"(lut_dp_2_64), "l"(lut_dp_2_32), "l"(lut_dp_2_16), "l"(lut_dp_2_8), "l"(lut_dp_2_4), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y));
};


#endif
