#ifndef CUFFTDX_FFT_30_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_30_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<14, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<755>;
.reg .b64 rd<2>;
add.f32 f121, %76, %124;
add.f32 f122, %60, f121;
add.f32 f123, %92, %108;
add.f32 f124, f123, f122;
add.f32 f125, %77, %125;
add.f32 f126, %61, f125;
add.f32 f127, %93, %109;
add.f32 f128, f127, f126;
fma.rn.f32 f129, f121, 0f3E9E377A, %60;
mul.f32 f130, f123, 0f3F4F1BBD;
sub.f32 f131, f129, f130;
sub.f32 f132, %77, %125;
mul.f32 f133, f132, 0f3F737871;
sub.f32 f134, %93, %109;
mul.f32 f135, f134, 0fBF167918;
sub.f32 f136, f135, f133;
sub.f32 f137, f131, f136;
add.f32 f138, f136, f131;
mul.f32 f139, f121, 0f3F4F1BBD;
sub.f32 f140, %60, f139;
fma.rn.f32 f141, f123, 0f3E9E377A, f140;
mul.f32 f142, f132, 0f3F167918;
mul.f32 f143, f134, 0f3F737871;
sub.f32 f144, f143, f142;
sub.f32 f145, f141, f144;
add.f32 f146, f144, f141;
fma.rn.f32 f147, f125, 0f3E9E377A, %61;
mul.f32 f148, f127, 0f3F4F1BBD;
sub.f32 f149, f147, f148;
sub.f32 f150, %76, %124;
mul.f32 f151, f150, 0f3F737871;
sub.f32 f152, %92, %108;
mul.f32 f153, f152, 0fBF167918;
sub.f32 f154, f153, f151;
add.f32 f155, f154, f149;
sub.f32 f156, f149, f154;
mul.f32 f157, f125, 0f3F4F1BBD;
sub.f32 f158, %61, f157;
fma.rn.f32 f159, f127, 0f3E9E377A, f158;
mul.f32 f160, f150, 0f3F167918;
mul.f32 f161, f152, 0f3F737871;
sub.f32 f162, f161, f160;
add.f32 f163, f162, f159;
sub.f32 f164, f159, f162;
add.f32 f165, %81, %129;
add.f32 f166, %65, f165;
add.f32 f167, %97, %113;
add.f32 f168, f167, f166;
add.f32 f169, %83, %131;
add.f32 f170, %67, f169;
add.f32 f171, %99, %115;
add.f32 f172, f171, f170;
fma.rn.f32 f173, f165, 0f3E9E377A, %65;
mul.f32 f174, f167, 0f3F4F1BBD;
sub.f32 f175, f173, f174;
sub.f32 f176, %83, %131;
mul.f32 f177, f176, 0f3F737871;
sub.f32 f178, %99, %115;
mul.f32 f179, f178, 0fBF167918;
sub.f32 f180, f179, f177;
sub.f32 f181, f175, f180;
add.f32 f182, f180, f175;
mul.f32 f183, f165, 0f3F4F1BBD;
sub.f32 f184, %65, f183;
fma.rn.f32 f185, f167, 0f3E9E377A, f184;
mul.f32 f186, f176, 0f3F167918;
mul.f32 f187, f178, 0f3F737871;
sub.f32 f188, f187, f186;
sub.f32 f189, f185, f188;
add.f32 f190, f188, f185;
fma.rn.f32 f191, f169, 0f3E9E377A, %67;
mul.f32 f192, f171, 0f3F4F1BBD;
sub.f32 f193, f191, f192;
sub.f32 f194, %81, %129;
mul.f32 f195, f194, 0f3F737871;
sub.f32 f196, %97, %113;
mul.f32 f197, f196, 0fBF167918;
sub.f32 f198, f197, f195;
add.f32 f199, f198, f193;
sub.f32 f200, f193, f198;
mul.f32 f201, f169, 0f3F4F1BBD;
sub.f32 f202, %67, f201;
fma.rn.f32 f203, f171, 0f3E9E377A, f202;
mul.f32 f204, f194, 0f3F167918;
mul.f32 f205, f196, 0f3F737871;
sub.f32 f206, f205, f204;
add.f32 f207, f206, f203;
sub.f32 f208, f203, f206;
add.f32 f209, %86, %134;
add.f32 f210, %70, f209;
add.f32 f211, %102, %118;
add.f32 f212, f211, f210;
add.f32 f213, %88, %136;
add.f32 f214, %72, f213;
add.f32 f215, %104, %120;
add.f32 f216, f215, f214;
fma.rn.f32 f217, f209, 0f3E9E377A, %70;
mul.f32 f218, f211, 0f3F4F1BBD;
sub.f32 f219, f217, f218;
sub.f32 f220, %88, %136;
mul.f32 f221, f220, 0f3F737871;
sub.f32 f222, %104, %120;
mul.f32 f223, f222, 0fBF167918;
sub.f32 f224, f223, f221;
sub.f32 f225, f219, f224;
add.f32 f226, f224, f219;
mul.f32 f227, f209, 0f3F4F1BBD;
sub.f32 f228, %70, f227;
fma.rn.f32 f229, f211, 0f3E9E377A, f228;
mul.f32 f230, f220, 0f3F167918;
mul.f32 f231, f222, 0f3F737871;
sub.f32 f232, f231, f230;
sub.f32 f233, f229, f232;
add.f32 f234, f232, f229;
fma.rn.f32 f235, f213, 0f3E9E377A, %72;
mul.f32 f236, f215, 0f3F4F1BBD;
sub.f32 f237, f235, f236;
sub.f32 f238, %86, %134;
mul.f32 f239, f238, 0f3F737871;
sub.f32 f240, %102, %118;
mul.f32 f241, f240, 0fBF167918;
sub.f32 f242, f241, f239;
add.f32 f243, f242, f237;
sub.f32 f244, f237, f242;
mul.f32 f245, f213, 0f3F4F1BBD;
sub.f32 f246, %72, f245;
fma.rn.f32 f247, f215, 0f3E9E377A, f246;
mul.f32 f248, f238, 0f3F167918;
mul.f32 f249, f240, 0f3F737871;
sub.f32 f250, f249, f248;
add.f32 f251, f250, f247;
sub.f32 f252, f247, f250;
mul.f32 f253, f181, 0f3F69DE1D;
mul.f32 f254, f199, 0fBED03FC9;
sub.f32 f255, f253, f254;
mul.f32 f256, f199, 0f3F69DE1D;
fma.rn.f32 f257, f181, 0fBED03FC9, f256;
mul.f32 f258, f225, 0f3F2B4C25;
mul.f32 f259, f243, 0fBF3E3EBD;
sub.f32 f260, f258, f259;
mul.f32 f261, f243, 0f3F2B4C25;
fma.rn.f32 f262, f225, 0fBF3E3EBD, f261;
mul.f32 f263, f189, 0f3F2B4C25;
mul.f32 f264, f207, 0fBF3E3EBD;
sub.f32 f265, f263, f264;
mul.f32 f266, f207, 0f3F2B4C25;
fma.rn.f32 f267, f189, 0fBF3E3EBD, f266;
mul.f32 f268, f233, 0fBDD61305;
mul.f32 f269, f251, 0fBF7E98FD;
sub.f32 f270, f268, f269;
mul.f32 f271, f251, 0fBDD61305;
fma.rn.f32 f272, f233, 0fBF7E98FD, f271;
mul.f32 f273, f190, 0f3E9E377A;
mul.f32 f274, f208, 0fBF737871;
sub.f32 f275, f273, f274;
mul.f32 f276, f208, 0f3E9E377A;
fma.rn.f32 f277, f190, 0fBF737871, f276;
mul.f32 f278, f234, 0fBF4F1BBD;
mul.f32 f279, f252, 0fBF167918;
sub.f32 f280, f278, f279;
mul.f32 f281, f252, 0fBF4F1BBD;
fma.rn.f32 f282, f234, 0fBF167918, f281;
mul.f32 f283, f182, 0fBDD61305;
mul.f32 f284, f200, 0fBF7E98FD;
sub.f32 f285, f283, f284;
mul.f32 f286, f200, 0fBDD61305;
fma.rn.f32 f287, f182, 0fBF7E98FD, f286;
mul.f32 f288, f226, 0fBF7A67E2;
mul.f32 f289, f244, 0f3E54E6CD;
sub.f32 f290, f288, f289;
mul.f32 f291, f244, 0fBF7A67E2;
fma.rn.f32 f292, f226, 0f3E54E6CD, f291;
add.f32 f293, f168, f212;
add.f32 f294, f124, f293;
add.f32 f295, f172, f216;
add.f32 f296, f128, f295;
mul.f32 f297, f293, 0f3F000000;
sub.f32 f298, f124, f297;
sub.f32 f299, f172, f216;
mul.f32 f300, f299, 0f3F5DB3D7;
add.f32 f301, f300, f298;
sub.f32 f302, f298, f300;
mul.f32 f303, f295, 0f3F000000;
sub.f32 f304, f128, f303;
sub.f32 f305, f168, f212;
mul.f32 f306, f305, 0f3F5DB3D7;
sub.f32 f307, f304, f306;
add.f32 f308, f306, f304;
add.f32 f309, f255, f260;
add.f32 f310, f137, f309;
add.f32 f311, f257, f262;
add.f32 f312, f155, f311;
mul.f32 f313, f309, 0f3F000000;
sub.f32 f314, f137, f313;
sub.f32 f315, f257, f262;
mul.f32 f316, f315, 0f3F5DB3D7;
add.f32 f317, f316, f314;
sub.f32 f318, f314, f316;
mul.f32 f319, f311, 0f3F000000;
sub.f32 f320, f155, f319;
sub.f32 f321, f255, f260;
mul.f32 f322, f321, 0f3F5DB3D7;
sub.f32 f323, f320, f322;
add.f32 f324, f322, f320;
add.f32 f325, f265, f270;
add.f32 f326, f145, f325;
add.f32 f327, f267, f272;
add.f32 f328, f163, f327;
mul.f32 f329, f325, 0f3F000000;
sub.f32 f330, f145, f329;
sub.f32 f331, f267, f272;
mul.f32 f332, f331, 0f3F5DB3D7;
add.f32 f333, f332, f330;
sub.f32 f334, f330, f332;
mul.f32 f335, f327, 0f3F000000;
sub.f32 f336, f163, f335;
sub.f32 f337, f265, f270;
mul.f32 f338, f337, 0f3F5DB3D7;
sub.f32 f339, f336, f338;
add.f32 f340, f338, f336;
add.f32 f341, f275, f280;
add.f32 f342, f146, f341;
add.f32 f343, f277, f282;
add.f32 f344, f164, f343;
mul.f32 f345, f341, 0f3F000000;
sub.f32 f346, f146, f345;
sub.f32 f347, f277, f282;
mul.f32 f348, f347, 0f3F5DB3D7;
add.f32 f349, f348, f346;
sub.f32 f350, f346, f348;
mul.f32 f351, f343, 0f3F000000;
sub.f32 f352, f164, f351;
sub.f32 f353, f275, f280;
mul.f32 f354, f353, 0f3F5DB3D7;
sub.f32 f355, f352, f354;
add.f32 f356, f354, f352;
add.f32 f357, f285, f290;
add.f32 f358, f138, f357;
add.f32 f359, f287, f292;
add.f32 f360, f156, f359;
mul.f32 f361, f357, 0f3F000000;
sub.f32 f362, f138, f361;
sub.f32 f363, f287, f292;
mul.f32 f364, f363, 0f3F5DB3D7;
add.f32 f365, f364, f362;
sub.f32 f366, f362, f364;
mul.f32 f367, f359, 0f3F000000;
sub.f32 f368, f156, f367;
sub.f32 f369, f285, f290;
mul.f32 f370, f369, 0f3F5DB3D7;
sub.f32 f371, f368, f370;
add.f32 f372, f370, f368;
add.f32 f373, %78, %126;
add.f32 f374, %62, f373;
add.f32 f375, %94, %110;
add.f32 f376, f375, f374;
add.f32 f377, %80, %128;
add.f32 f378, %64, f377;
add.f32 f379, %96, %112;
add.f32 f380, f379, f378;
fma.rn.f32 f381, f373, 0f3E9E377A, %62;
mul.f32 f382, f375, 0f3F4F1BBD;
sub.f32 f383, f381, f382;
sub.f32 f384, %80, %128;
mul.f32 f385, f384, 0f3F737871;
sub.f32 f386, %96, %112;
mul.f32 f387, f386, 0fBF167918;
sub.f32 f388, f387, f385;
sub.f32 f389, f383, f388;
add.f32 f390, f388, f383;
mul.f32 f391, f373, 0f3F4F1BBD;
sub.f32 f392, %62, f391;
fma.rn.f32 f393, f375, 0f3E9E377A, f392;
mul.f32 f394, f384, 0f3F167918;
mul.f32 f395, f386, 0f3F737871;
sub.f32 f396, f395, f394;
sub.f32 f397, f393, f396;
add.f32 f398, f396, f393;
fma.rn.f32 f399, f377, 0f3E9E377A, %64;
mul.f32 f400, f379, 0f3F4F1BBD;
sub.f32 f401, f399, f400;
sub.f32 f402, %78, %126;
mul.f32 f403, f402, 0f3F737871;
sub.f32 f404, %94, %110;
mul.f32 f405, f404, 0fBF167918;
sub.f32 f406, f405, f403;
add.f32 f407, f406, f401;
sub.f32 f408, f401, f406;
mul.f32 f409, f377, 0f3F4F1BBD;
sub.f32 f410, %64, f409;
fma.rn.f32 f411, f379, 0f3E9E377A, f410;
mul.f32 f412, f402, 0f3F167918;
mul.f32 f413, f404, 0f3F737871;
sub.f32 f414, f413, f412;
add.f32 f415, f414, f411;
sub.f32 f416, f411, f414;
add.f32 f417, %84, %132;
add.f32 f418, %68, f417;
add.f32 f419, %100, %116;
add.f32 f420, f419, f418;
add.f32 f421, %85, %133;
add.f32 f422, %69, f421;
add.f32 f423, %101, %117;
add.f32 f424, f423, f422;
fma.rn.f32 f425, f417, 0f3E9E377A, %68;
mul.f32 f426, f419, 0f3F4F1BBD;
sub.f32 f427, f425, f426;
sub.f32 f428, %85, %133;
mul.f32 f429, f428, 0f3F737871;
sub.f32 f430, %101, %117;
mul.f32 f431, f430, 0fBF167918;
sub.f32 f432, f431, f429;
sub.f32 f433, f427, f432;
add.f32 f434, f432, f427;
mul.f32 f435, f417, 0f3F4F1BBD;
sub.f32 f436, %68, f435;
fma.rn.f32 f437, f419, 0f3E9E377A, f436;
mul.f32 f438, f428, 0f3F167918;
mul.f32 f439, f430, 0f3F737871;
sub.f32 f440, f439, f438;
sub.f32 f441, f437, f440;
add.f32 f442, f440, f437;
fma.rn.f32 f443, f421, 0f3E9E377A, %69;
mul.f32 f444, f423, 0f3F4F1BBD;
sub.f32 f445, f443, f444;
sub.f32 f446, %84, %132;
mul.f32 f447, f446, 0f3F737871;
sub.f32 f448, %100, %116;
mul.f32 f449, f448, 0fBF167918;
sub.f32 f450, f449, f447;
add.f32 f451, f450, f445;
sub.f32 f452, f445, f450;
mul.f32 f453, f421, 0f3F4F1BBD;
sub.f32 f454, %69, f453;
fma.rn.f32 f455, f423, 0f3E9E377A, f454;
mul.f32 f456, f446, 0f3F167918;
mul.f32 f457, f448, 0f3F737871;
sub.f32 f458, f457, f456;
add.f32 f459, f458, f455;
sub.f32 f460, f455, f458;
add.f32 f461, %89, %137;
add.f32 f462, %73, f461;
add.f32 f463, %105, %121;
add.f32 f464, f463, f462;
add.f32 f465, %91, %138;
add.f32 f466, %75, f465;
add.f32 f467, %107, %123;
add.f32 f468, f467, f466;
fma.rn.f32 f469, f461, 0f3E9E377A, %73;
mul.f32 f470, f463, 0f3F4F1BBD;
sub.f32 f471, f469, f470;
sub.f32 f472, %91, %138;
mul.f32 f473, f472, 0f3F737871;
sub.f32 f474, %107, %123;
mul.f32 f475, f474, 0fBF167918;
sub.f32 f476, f475, f473;
sub.f32 f477, f471, f476;
add.f32 f478, f476, f471;
mul.f32 f479, f461, 0f3F4F1BBD;
sub.f32 f480, %73, f479;
fma.rn.f32 f481, f463, 0f3E9E377A, f480;
mul.f32 f482, f472, 0f3F167918;
mul.f32 f483, f474, 0f3F737871;
sub.f32 f484, f483, f482;
sub.f32 f485, f481, f484;
add.f32 f486, f484, f481;
fma.rn.f32 f487, f465, 0f3E9E377A, %75;
mul.f32 f488, f467, 0f3F4F1BBD;
sub.f32 f489, f487, f488;
sub.f32 f490, %89, %137;
mul.f32 f491, f490, 0f3F737871;
sub.f32 f492, %105, %121;
mul.f32 f493, f492, 0fBF167918;
sub.f32 f494, f493, f491;
add.f32 f495, f494, f489;
sub.f32 f496, f489, f494;
mul.f32 f497, f465, 0f3F4F1BBD;
sub.f32 f498, %75, f497;
fma.rn.f32 f499, f467, 0f3E9E377A, f498;
mul.f32 f500, f490, 0f3F167918;
mul.f32 f501, f492, 0f3F737871;
sub.f32 f502, f501, f500;
add.f32 f503, f502, f499;
sub.f32 f504, f499, f502;
mul.f32 f505, f433, 0f3F69DE1D;
mul.f32 f506, f451, 0fBED03FC9;
sub.f32 f507, f505, f506;
mul.f32 f508, f451, 0f3F69DE1D;
fma.rn.f32 f509, f433, 0fBED03FC9, f508;
mul.f32 f510, f477, 0f3F2B4C25;
mul.f32 f511, f495, 0fBF3E3EBD;
sub.f32 f512, f510, f511;
mul.f32 f513, f495, 0f3F2B4C25;
fma.rn.f32 f514, f477, 0fBF3E3EBD, f513;
mul.f32 f515, f441, 0f3F2B4C25;
mul.f32 f516, f459, 0fBF3E3EBD;
sub.f32 f517, f515, f516;
mul.f32 f518, f459, 0f3F2B4C25;
fma.rn.f32 f519, f441, 0fBF3E3EBD, f518;
mul.f32 f520, f485, 0fBDD61305;
mul.f32 f521, f503, 0fBF7E98FD;
sub.f32 f522, f520, f521;
mul.f32 f523, f503, 0fBDD61305;
fma.rn.f32 f524, f485, 0fBF7E98FD, f523;
mul.f32 f525, f442, 0f3E9E377A;
mul.f32 f526, f460, 0fBF737871;
sub.f32 f527, f525, f526;
mul.f32 f528, f460, 0f3E9E377A;
fma.rn.f32 f529, f442, 0fBF737871, f528;
mul.f32 f530, f486, 0fBF4F1BBD;
mul.f32 f531, f504, 0fBF167918;
sub.f32 f532, f530, f531;
mul.f32 f533, f504, 0fBF4F1BBD;
fma.rn.f32 f534, f486, 0fBF167918, f533;
mul.f32 f535, f434, 0fBDD61305;
mul.f32 f536, f452, 0fBF7E98FD;
sub.f32 f537, f535, f536;
mul.f32 f538, f452, 0fBDD61305;
fma.rn.f32 f539, f434, 0fBF7E98FD, f538;
mul.f32 f540, f478, 0fBF7A67E2;
mul.f32 f541, f496, 0f3E54E6CD;
sub.f32 f542, f540, f541;
mul.f32 f543, f496, 0fBF7A67E2;
fma.rn.f32 f544, f478, 0f3E54E6CD, f543;
add.f32 f545, f420, f464;
add.f32 f546, f376, f545;
add.f32 f547, f424, f468;
add.f32 f548, f380, f547;
mul.f32 f549, f545, 0f3F000000;
sub.f32 f550, f376, f549;
sub.f32 f551, f424, f468;
mul.f32 f552, f551, 0f3F5DB3D7;
add.f32 f553, f552, f550;
sub.f32 f554, f550, f552;
mul.f32 f555, f547, 0f3F000000;
sub.f32 f556, f380, f555;
sub.f32 f557, f420, f464;
mul.f32 f558, f557, 0f3F5DB3D7;
sub.f32 f559, f556, f558;
add.f32 f560, f558, f556;
add.f32 f561, f507, f512;
add.f32 f562, f389, f561;
add.f32 f563, f509, f514;
add.f32 f564, f407, f563;
mul.f32 f565, f561, 0f3F000000;
sub.f32 f566, f389, f565;
sub.f32 f567, f509, f514;
mul.f32 f568, f567, 0f3F5DB3D7;
add.f32 f569, f568, f566;
sub.f32 f570, f566, f568;
mul.f32 f571, f563, 0f3F000000;
sub.f32 f572, f407, f571;
sub.f32 f573, f507, f512;
mul.f32 f574, f573, 0f3F5DB3D7;
sub.f32 f575, f572, f574;
add.f32 f576, f574, f572;
add.f32 f577, f517, f522;
add.f32 f578, f397, f577;
add.f32 f579, f519, f524;
add.f32 f580, f415, f579;
mul.f32 f581, f577, 0f3F000000;
sub.f32 f582, f397, f581;
sub.f32 f583, f519, f524;
mul.f32 f584, f583, 0f3F5DB3D7;
add.f32 f585, f584, f582;
sub.f32 f586, f582, f584;
mul.f32 f587, f579, 0f3F000000;
sub.f32 f588, f415, f587;
sub.f32 f589, f517, f522;
mul.f32 f590, f589, 0f3F5DB3D7;
sub.f32 f591, f588, f590;
add.f32 f592, f590, f588;
add.f32 f593, f527, f532;
add.f32 f594, f398, f593;
add.f32 f595, f529, f534;
add.f32 f596, f416, f595;
mul.f32 f597, f593, 0f3F000000;
sub.f32 f598, f398, f597;
sub.f32 f599, f529, f534;
mul.f32 f600, f599, 0f3F5DB3D7;
add.f32 f601, f600, f598;
sub.f32 f602, f598, f600;
mul.f32 f603, f595, 0f3F000000;
sub.f32 f604, f416, f603;
sub.f32 f605, f527, f532;
mul.f32 f606, f605, 0f3F5DB3D7;
sub.f32 f607, f604, f606;
add.f32 f608, f606, f604;
add.f32 f609, f537, f542;
add.f32 f610, f390, f609;
add.f32 f611, f539, f544;
add.f32 f612, f408, f611;
mul.f32 f613, f609, 0f3F000000;
sub.f32 f614, f390, f613;
sub.f32 f615, f539, f544;
mul.f32 f616, f615, 0f3F5DB3D7;
add.f32 f617, f616, f614;
sub.f32 f618, f614, f616;
mul.f32 f619, f611, 0f3F000000;
sub.f32 f620, f408, f619;
sub.f32 f621, f537, f542;
mul.f32 f622, f621, 0f3F5DB3D7;
sub.f32 f623, f620, f622;
add.f32 f624, f622, f620;
mul.f32 f625, f562, 0f3F7A67E2;
mul.f32 f626, f564, 0fBE54E6CD;
sub.f32 f627, f625, f626;
mul.f32 f628, f564, 0f3F7A67E2;
fma.rn.f32 f629, f562, 0fBE54E6CD, f628;
mul.f32 f630, f578, 0f3F69DE1D;
mul.f32 f631, f580, 0fBED03FC9;
sub.f32 f632, f630, f631;
mul.f32 f633, f580, 0f3F69DE1D;
fma.rn.f32 f634, f578, 0fBED03FC9, f633;
mul.f32 f635, f594, 0f3F4F1BBD;
mul.f32 f636, f596, 0fBF167918;
sub.f32 f637, f635, f636;
mul.f32 f638, f596, 0f3F4F1BBD;
fma.rn.f32 f639, f594, 0fBF167918, f638;
mul.f32 f640, f610, 0f3F2B4C25;
mul.f32 f641, f612, 0fBF3E3EBD;
sub.f32 f642, f640, f641;
mul.f32 f643, f612, 0f3F2B4C25;
fma.rn.f32 f644, f610, 0fBF3E3EBD, f643;
mul.f32 f645, f553, 0f3F000000;
mul.f32 f646, f559, 0fBF5DB3D7;
sub.f32 f647, f645, f646;
mul.f32 f648, f559, 0f3F000000;
fma.rn.f32 f649, f553, 0fBF5DB3D7, f648;
mul.f32 f650, f569, 0f3E9E377A;
mul.f32 f651, f575, 0fBF737871;
sub.f32 f652, f650, f651;
mul.f32 f653, f575, 0f3E9E377A;
fma.rn.f32 f654, f569, 0fBF737871, f653;
mul.f32 f655, f585, 0f3DD61305;
mul.f32 f656, f591, 0fBF7E98FD;
sub.f32 f657, f655, f656;
mul.f32 f658, f591, 0f3DD61305;
fma.rn.f32 f659, f585, 0fBF7E98FD, f658;
mul.f32 f660, f601, 0fBDD61305;
mul.f32 f661, f607, 0fBF7E98FD;
sub.f32 f662, f660, f661;
mul.f32 f663, f607, 0fBDD61305;
fma.rn.f32 f664, f601, 0fBF7E98FD, f663;
mul.f32 f665, f617, 0fBE9E377A;
mul.f32 f666, f623, 0fBF737871;
sub.f32 f667, f665, f666;
mul.f32 f668, f623, 0fBE9E377A;
fma.rn.f32 f669, f617, 0fBF737871, f668;
mul.f32 f670, f554, 0fBF000000;
mul.f32 f671, f560, 0fBF5DB3D7;
sub.f32 f672, f670, f671;
mul.f32 f673, f560, 0fBF000000;
fma.rn.f32 f674, f554, 0fBF5DB3D7, f673;
mul.f32 f675, f570, 0fBF2B4C25;
mul.f32 f676, f576, 0fBF3E3EBD;
sub.f32 f677, f675, f676;
mul.f32 f678, f576, 0fBF2B4C25;
fma.rn.f32 f679, f570, 0fBF3E3EBD, f678;
mul.f32 f680, f586, 0fBF4F1BBD;
mul.f32 f681, f592, 0fBF167918;
sub.f32 f682, f680, f681;
mul.f32 f683, f592, 0fBF4F1BBD;
fma.rn.f32 f684, f586, 0fBF167918, f683;
mul.f32 f685, f602, 0fBF69DE1D;
mul.f32 f686, f608, 0fBED03FC9;
sub.f32 f687, f685, f686;
mul.f32 f688, f608, 0fBF69DE1D;
fma.rn.f32 f689, f602, 0fBED03FC9, f688;
mul.f32 f690, f618, 0fBF7A67E2;
mul.f32 f691, f624, 0fBE54E6CD;
sub.f32 f692, f690, f691;
mul.f32 f693, f624, 0fBF7A67E2;
fma.rn.f32 f694, f618, 0fBE54E6CD, f693;
add.f32 %1, f296, f548;
add.f32 %0, f294, f546;
add.f32 %3, f312, f629;
add.f32 %2, f310, f627;
add.f32 %5, f328, f634;
add.f32 %4, f326, f632;
add.f32 %7, f344, f639;
add.f32 %6, f342, f637;
add.f32 %9, f360, f644;
add.f32 %8, f358, f642;
add.f32 %11, f307, f649;
add.f32 %10, f301, f647;
add.f32 %13, f323, f654;
add.f32 %12, f317, f652;
add.f32 %15, f339, f659;
add.f32 %14, f333, f657;
add.f32 %17, f355, f664;
add.f32 %16, f349, f662;
add.f32 %19, f371, f669;
add.f32 %18, f365, f667;
add.f32 %21, f308, f674;
add.f32 %20, f302, f672;
add.f32 %23, f324, f679;
add.f32 %22, f318, f677;
add.f32 %25, f340, f684;
add.f32 %24, f334, f682;
add.f32 %27, f356, f689;
add.f32 %26, f350, f687;
add.f32 %29, f372, f694;
add.f32 %28, f366, f692;
sub.f32 %31, f296, f548;
sub.f32 %30, f294, f546;
sub.f32 %33, f312, f629;
sub.f32 %32, f310, f627;
sub.f32 %35, f328, f634;
sub.f32 %34, f326, f632;
sub.f32 %37, f344, f639;
sub.f32 %36, f342, f637;
sub.f32 %39, f360, f644;
sub.f32 %38, f358, f642;
sub.f32 %41, f307, f649;
sub.f32 %40, f301, f647;
sub.f32 %43, f323, f654;
sub.f32 %42, f317, f652;
sub.f32 %45, f339, f659;
sub.f32 %44, f333, f657;
sub.f32 %47, f355, f664;
sub.f32 %46, f349, f662;
sub.f32 %49, f371, f669;
sub.f32 %48, f365, f667;
sub.f32 %51, f308, f674;
sub.f32 %50, f302, f672;
sub.f32 %53, f324, f679;
sub.f32 %52, f318, f677;
sub.f32 %55, f340, f684;
sub.f32 %54, f334, f682;
sub.f32 %57, f356, f689;
sub.f32 %56, f350, f687;
sub.f32 %59, f372, f694;
sub.f32 %58, f366, f692;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y));
};


#endif
