

# Setup

`pip install -r requirements.txt`



# Running the training

Example SD1.5 launch

```bash
# from launchers/sd15.sh
export MODEL_NAME="runwayml/stable-diffusion-v1-5"
export DATASET_NAME="yuvalkirstain/pickapic_v2"

CUDA_VISIBLE_DEVICES=0,1 accelerate launch --mixed_precision="fp16"  train.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --dataset_name=$DATASET_NAME \
  --train_batch_size=32 \
  --dataloader_num_workers=16 \
  --gradient_accumulation_steps=32 \
  --max_train_steps=2000 \
  --lr_scheduler="constant_with_warmup" --lr_warmup_steps=500 \
  --learning_rate=1e-6 \
  --cache_dir="/export/share/datasets/vision_language/pick_a_pic_v2/" \
  --checkpointing_steps 500 \
  --beta_dpo 5000 \
  --output_dir="Self-DPO-sd15"
```

## Important Args

### General

- `--pretrained_model_name_or_path` what model to train/initalize from
- `--output_dir` where to save/log to
- `--seed` training seed (not set by default)
- `--sdxl` run SDXL training
- `--sft` run SFT instead of Self-DPO

### Optimizers/learning rates

- `--max_train_steps` How many train steps to take

- `--gradient_accumulation_steps`

- `--train_batch_size` see above notes in script for actual BS

- `--checkpointing_steps` how often to save model

- `--gradient_checkpointing` turned on automatically for SDXL

- `--learning_rate`

- `--lr_scheduler` Type of LR warmup/decay. Default is linear warmup to constant

- `--lr_warmup_steps` number of scheduler warmup steps

- `--use_adafactor` Adafactor over Adam (lower memory, default for SDXL)

### Data

- `--dataset_name` if you want to switch from Pick-a-Pic
- `--cache_dir` where dataset is cached locally **(users will want to change this to fit their file system)**
- `--resolution` defaults to 512 for non-SDXL, 1024 for SDXL.
- `--random_crop` and `--no_hflip` changes data aug
- `--dataloader_num_workers` number of total dataloader workers
