# UnrealPose

## prerequisite

* pytorch
* Ray(RLlib)
* OpenAI Gym
* Zarr
* PyQtGraph (See [here](https://github.com/pyqtgraph/pyqtgraph) and [here](https://www.pyqtgraph.org/))
  * PyQt5
  * pyopengl
  * cupy
  * numba
  * colorcet
* ffmpeg
* pyav, pims
* numpy, scipy, matplotlib, h5py, json_tricks, easy_dict
* numba (optional for acceleration)


## Preparation
1. Put [pytorch checkpoint](anonymous) or [tensorrt engine](anonymous) under ${POSE_ROOT}/checkpoints. If you use tensorrt engine to inference, please follow the instructions [here](https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html) to install the tensorrt(8.2.3) in your conda env.
2. Download UnrealCV Env from [here](anonymous). Put it
   under ${POSE_ROOT}/binary

## Data Directory

```
${POSE_ROOT}
   ├── unrealpose
   ├── binary
   ├── checkpoints
   ├── configs
   ├── data
   ├── input
   ├── log
   ├── output
   ├── run
   ├── render_data
   ├──README.md
```

### Apply Ray Patches

```bash
conda activate urealpose
pip3 uninstall ray 'ray[rllib]'
pip3 install 'ray[rllib]==1.12.0'
bash apply-ray-patch.sh
```
