#!/usr/bin/env bash

VERSION="$1"
NUM_BINARIES="$2"

SCRIPT_PATH="$(realpath "$0")"
ROOT_DIR="$(dirname "${SCRIPT_PATH}")"
BINARY_PATH="${ROOT_DIR}/binary/v${VERSION}"
BINARY_NAME="UnrealPose"
TMP_DIR="$(mktemp -d -t urealpose.XXXXXX)"

set -x

if [[ ! -d "${BINARY_PATH}/${BINARY_NAME}" ]]; then
	echo "ERROR: Path \"${BINARY_PATH}/${BINARY_NAME}\" does not exist." >&2
	exit 1
fi

if ! [[ "${NUM_BINARIES}" -gt 0 ]]; then
	echo "ERROR: Got invalid number of binaries (\"${NUM_BINARIES}\")" >&2
	exit 1
fi

if [[ -d "${BINARY_PATH}/${BINARY_NAME}/Saved/Logs" ]]; then
	rm -rf "${BINARY_PATH}/${BINARY_NAME}/Saved/Logs"
fi

if [[ -d "${BINARY_PATH}/subbinaries" ]]; then
	rm -rf "${BINARY_PATH}/subbinaries"
fi

mkdir -p "${TMP_DIR}/subbinaries"
cp -a "${BINARY_PATH}" "${TMP_DIR}/subbinaries/00000"
mv -f "${TMP_DIR}/subbinaries" "${BINARY_PATH}/subbinaries"
ln -sfn ".." "${BINARY_PATH}/subbinaries/current"
rm -r "${TMP_DIR}"

for ((i = 1; i <= NUM_BINARIES; ++i)); do
	index="$(printf "%05d" "${i}")"
	cp -a "${BINARY_PATH}/subbinaries/00000" "${BINARY_PATH}/subbinaries/${index}"
done
