import os
import time

from unrealpose import ROOT_DIR

os.chdir(ROOT_DIR)
os.environ['PWD'] = ROOT_DIR

from experiments.mappoimbl import ENV_CONFIG
from unrealpose.control.envs import make_train_env

ENV_CONFIG['UE4Binary_SLEEPTIME'] = os.environ['UE4Binary_SLEEPTIME'] = '20'
env = make_train_env(ENV_CONFIG, is_training=False).unwrapped

obs = env.reset()

start_time = time.perf_counter()

frames = 0
for i in range(100):
    _, _, done, _ = env.step(env.action_space.sample())
    frames += 1
    if done:
        break

end_time = time.perf_counter()

env.reset()
env.close()

print(f'FPS = {frames / (end_time - start_time)}')
