
from .mappoimbl.model import IMBLModel

CUSTOM_MODELS = {
    'imbl_model': IMBLModel,
}


def load_custom_models(CUSTOM_MODELS=CUSTOM_MODELS):
    from ray.rllib.models import ModelCatalog

    for _custom_model_name in CUSTOM_MODELS:
        _class = CUSTOM_MODELS[_custom_model_name]
        ModelCatalog.register_custom_model(_custom_model_name, _class)
