import numpy as np

map_config_dict = {
    'Blank': {
        'ground_center': np.array([0, 0, 0], dtype=np.float32),
        'human_z': 86.15,
    },

    'SchoolGymDay': {
        'ground_center': np.array([-1120, 330, 130], dtype=np.float32),
        'human_z': 216.15,
    },

    'Building': {
        'ground_center': np.array([430, -270, -30], dtype=np.float32),
        'human_z': 56.15,
    },

    'Grass': {
        'ground_center': np.array([0, 0, 0], dtype=np.float32),
        'human_z': 86.15,
    },
}


human_model_config_dict = {
    'Default': {
        'changable_mesh': True,
    },

    'Sportman': {
        'changable_mesh': False,
    },

    'Businessman': {
        'changable_mesh': False,
    },
}


env_config_dict = {
    'C4_6x6_h30_p35': {
        'env_description': '6X6 square, cameras height: 3.0m, with a pitch of 35',
        'area': np.array([
            [300.0, 300.0],
            [300.0, -300.0],
            [-300.0, -300.0],
            [-300.0, 300.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 4,
        'camera_param_list': [
            np.array((300.0, 300.0, 300.0, -35.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((300.0, -300.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32),
            np.array((-300.0, -300.0, 300.0, -35.0, 45.0, 0, 90.0), dtype=np.float32),
            np.array((-300.0, 300.0, 300.0, -35.0, -45.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 450],  # x, y, z
    },

    'C2_6x6_h30_p35_1fix_1free': {
        'env_description': 'simple test env, 1 camera fixed, 1 camera free',
        'area': np.array([
            [300.0, 300.0],
            [300.0, -300.0],
            [-300.0, -300.0],
            [-300.0, 300.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((300.0, 300.0, 300.0, -35.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((300.0, -300.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 450],  # x, y, z
    },

    'C2_6x6_h30_p35_5mx5m': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((500.0, 500.0, 300.0, -35.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((500.0, -500.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 450],  # x, y, z
    },

    'C2_6x6_h30_p35_5mx5m_for_demo': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((150.0, 500.0, 300.0, -35.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 300.0, -35.0, -45.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 450],  # x, y, z
    },

    'C2_6x6_h30_p35_10mx10m_x13y13z3': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((150.0, 500.0, 200.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 200.0, -15.0, -45.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-650, -650, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [650, 650, 300],  # x, y, z
    },

    'C3_6x6_h30_p35_10mx10m_x13y13z3': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 3,
        'camera_param_list': [
            np.array((150.0, 500.0, 200.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 200.0, -15.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((0, -300.0, 200.0, -15.0, 90.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-650, -650, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [650, 650, 300],  # x, y, z
    },

    'C4_6x6_h30_p35_10mx10m_x13y13z3': {
        'env_description': '6X6 square, cameras height: 3.0m, with a pitch of 35',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 4,
        'camera_param_list': [
            np.array((500.0, 500.0, 300.0, -35.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((500.0, -500.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32),
            np.array((-500.0, -500.0, 300.0, -35.0, 45.0, 0, 90.0), dtype=np.float32),
            np.array((-500.0, 500.0, 300.0, -35.0, -45.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-650, -650, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [650, 650, 300],  # x, y, z
    },

    'C5_6x6_h30_p35_10mx10m_x13y13z3': {
        'env_description': '6X6 square, cameras height: 3.0m, with a pitch of 35',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 5,
        'camera_param_list': [
            np.array((0.0, -500.0, 300.0, -35.0, 90.0, 0, 90.0), dtype=np.float32),
            np.array((475.5, -154.5, 300.0, -35.0, 162.0, 0, 90.0), dtype=np.float32),
            np.array((293.9, 404.5, 300.0, -35.0, 234.0, 0, 90.0), dtype=np.float32),
            np.array((-293.9, 404.5, 300.0, -35.0, 306.0, 0, 90.0), dtype=np.float32),
            np.array((-475.5, -154.5, 300.0, -35.0, 18.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 90.15,  # z location for human object
        'lower_bound_for_camera': [-650, -650, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [650, 650, 300],  # x, y, z
    },

    'C2_6x6_h30_p35_10mx10m_x13y13z23': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((150.0, 500.0, 200.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 200.0, -15.0, -45.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-650, -650, 200],  # x, y, z, camera move area
        'higher_bound_for_camera': [650, 650, 300],  # x, y, z
    },

    'C3_6x6_h30_p35_10mx10m_x13y13z23': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 3,
        'camera_param_list': [
            np.array((150.0, 500.0, 200.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 200.0, -15.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((0, -300.0, 200.0, -15.0, 90.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-650, -650, 200],  # x, y, z, camera move area
        'higher_bound_for_camera': [650, 650, 300],  # x, y, z
    },

    'C2_6x6_h30_p35_5mx5m_z200': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((150.0, 500.0, 200.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 200.0, -15.0, -45.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 200],  # x, y, z
    },

    'C3_6x6_h30_p35_5mx5m_z160': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 3,
        'camera_param_list': [
            np.array((150.0, 500.0, 160.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 160.0, -15.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((0, -300.0, 160.0, -15.0, 90.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 160],  # x, y, z
    },

    'C3_6x6_h30_p35_5mx5m_z200': {
        'env_description': 'simple test env, enlarge moving area to 5mx5m',
        'area': np.array([
            [500.0, 500.0],
            [500.0, -500.0],
            [-500.0, -500.0],
            [-500.0, 500.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 3,
        'camera_param_list': [
            np.array((150.0, 500.0, 200.0, -15.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((-150.0, 500.0, 200.0, -15.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((0, -300.0, 200.0, -15.0, 90.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 200],  # x, y, z
    },

    'C2_6x6_h30_p35_1fix_1free_trajectory_line': {
        'env_description': 'simple test env, 1 camera fixed, 1 camera free, ' + \
        'humans walk to designated location repeatedly',
        'area': np.array([
            [300.0, 300.0],
            [300.0, -300.0],
            [-300.0, -300.0],
            [-300.0, 300.0]
        ]),
        'target_trajectory': np.array([
            [180, 180],
            [180, -180],
            [-180, -180],
            [-180, 180],
        ]),  # higher priority over 'area' for generating target points.
        'area_shape': 'rectangle',  # used to random sample points in area
        'num_cameras': 2,
        'camera_param_list': [
            np.array((-300.0, 300.0, 300.0, -35.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((300.0, -300.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 450],  # x, y, z
    },

    'C4_6x6_h30_p35_slider_rect': {
        'env_description': '6X6 square, cameras height: 3.0m, with a pitch of 35',
        'area': np.array([
            [300.0, 300.0],
            [300.0, -300.0],
            [-300.0, -300.0],
            [-300.0, 300.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 4,
        'camera_param_list': [
            np.array((0, 400.0, 300.0, -35.0, -90.0, 0, 90.0), dtype=np.float32),
            np.array((400.0, 0, 300.0, -35.0, 180.0, 0, 90.0), dtype=np.float32),
            np.array((0, -400.0, 300.0, -35.0, 90.0, 0, 90.0), dtype=np.float32),
            np.array((-400.0, 0, 300.0, -35.0, 0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-400, -400, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [400, 400, 300],  # x, y, z
        'camera_move_along_axis_list': [0, 1, 0, 1],  # 0: along x, 1: along y
    },

    'C2_6x6_h30_p35_1fix_1free_slider_rect': {
        'env_description': 'simple test env, 1 camera fixed, 1 camera free',
        'area': np.array([
            [300.0, 300.0],
            [300.0, -300.0],
            [-300.0, -300.0],
            [-300.0, 300.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 2,
        'camera_param_list': [
            np.array((-300.0, 300.0, 300.0, -35.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((300.0, -300.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32)
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-300, -300, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [300, 300, 300],  # x, y, z
        'camera_move_along_axis_list': [0, 1],
    },
    'C8_6x6_h30_p35': {
        'env_description': '6X6 square, cameras height: 3.0m, with a pitch of 35',
        'area': np.array([
            [300.0, 300.0],
            [300.0, -300.0],
            [-300.0, -300.0],
            [-300.0, 300.0]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': 8,
        'camera_param_list': [
            np.array((300.0, 300.0, 300.0, -35.0, -135.0, 0, 90.0), dtype=np.float32),
            np.array((300.0, -300.0, 300.0, -35.0, 135.0, 0, 90.0), dtype=np.float32),
            np.array((-300.0, -300.0, 300.0, -35.0, 45.0, 0, 90.0), dtype=np.float32),
            np.array((-300.0, 300.0, 300.0, -35.0, -45.0, 0, 90.0), dtype=np.float32),
            np.array((0, 300.0, 300.0, -35.0, -90.0, 0, 90.0), dtype=np.float32),
            np.array((300.0, 0, 300.0, -35.0, 180.0, 0, 90.0), dtype=np.float32),
            np.array((0, -300.0, 300.0, -35.0, 90.0, 0, 90.0), dtype=np.float32),
            np.array((-300.0, 0, 300.0, -35.0, 0, 0, 90.0), dtype=np.float32),
        ],
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-500, -500, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [500, 500, 450],  # x, y, z
    },
}

# number_of_human : config
human_config_dict = {
    # 'walk_speed_range': [20, 30],  # [10, 20], [50, 75]
    # 'rot_speed_range': [80, 100],  # [80, 100]
    1: {
        'human_id_list': [1],
        'human_location_list': [[0, 0, 0]],
        'human_rotation_list': [[0, 0, 0]],
        'mask_color': [[126, 12, 250]],  # RGB
        'scale': [1],
        'action': ['walk'],
    },
    2: {
        'human_id_list': [1, 2],
        'human_location_list': [[0, 0, 0], [60, 60, 0]],
        'human_rotation_list': [[0, 0, 0], [0, 0, 0]],
        'mask_color': [[126, 12, 250], [1, 17, 250]],  # RGB
        'scale': [1, 1],
        'action': ['walk' for _ in range(2)],
    },
    3: {
        'human_id_list': [1, 2, 3],
        # 'human_location_list': [[0, 0, 0], [60, 60, 0], [120, 120, 0]],
        'human_location_list': [[0, 0, 0], [180, 180, 0], [-180, 180, 0]],
        'human_rotation_list': [[0, 0, 0], [0, 0, 0], [0, 0, 0]],
        'mask_color': [[126, 12, 250], [1, 17, 250], [12, 153, 250]],  # RGB
        'scale': [1, 1, 1],
        'action': ['walk' for _ in range(3)],
    },
    4: {
        'human_id_list': [1, 2, 3, 4],
        'human_location_list': [[0, 0, 0], [-200, 200, 0], [-200, -200, 0], [200, 0, 0]],
        'human_rotation_list': [[0, 0, 0], [0, 0, 0], [0, 0, 0], [0, 0, 0]],
        'mask_color': [[126, 12, 250], [1, 17, 250], [12, 153, 250], [250, 249, 25]],  # RGB
        'scale': [1, 1, 1, 1],
        'action': ['walk' for _ in range(4)],
    },
    5: {
        'human_id_list': [1, 2, 3, 4, 5],
        'human_location_list': [[0, 0, 0], [0, 400, 0], [0, -400, 0],
                                [400, 0, 0], [-400, 0, 0]],
        'human_rotation_list': [[0, 0, 0], [0, 0, 0], [0, 0, 0], [0, 0, 0], [0, 0, 0]],
        'mask_color': [[126, 12, 250], [1, 17, 250], [12, 153, 250], [250, 249, 25], [250, 158, 25]],  # RGB
        'scale': [1, 1, 1, 1, 1],
        'action': ['walk' for _ in range(5)],
    },
    6: {
        'human_id_list': [1, 2, 3, 4, 5, 6],
        'human_location_list': [[0, 0, 0], [-300, 300, 0], [-300, -300, 0], [300, -300, 0],
                                [300, 300, 0], [-180, 0, 0]],
        'human_rotation_list': [[0, 0, 0] for _ in range(6)],
        'mask_color': [[126, 12, 250], [1, 17, 250], [12, 153, 250], [250, 249, 25], [250, 158, 25],
                       [12, 250, 226], ],  # RGB
        'scale': [1, 1, 1, 1, 1, 1],
        'action': ['walk' for _ in range(6)],
    },
    7: {
        'human_id_list': [1, 2, 3, 4, 5, 6, 7],
        'human_location_list': [[0, 300, 0], [-300, 300, 0], [-300, -300, 0], [300, -300, 0],
                                [300, 300, 0], [-180, 0, 0], [180, 0, 0]],
        'human_rotation_list': [[0, 0, 0] for _ in range(7)],
        'mask_color': [[126, 12, 250], [1, 17, 250], [12, 153, 250], [250, 249, 25], [250, 158, 25],
                       [12, 250, 226], [0, 250, 82], ],  # RGB
        'scale': [1, 1, 1, 1, 1, 1, 1],
        'action': ['walk' for _ in range(7)],
    },
    10: {
        'human_id_list': [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        'human_location_list': [[0, 0, 0], [-240, -240, 0], [-180, -180, 0], [-120, -120, 0], [-60, -60, 0],
                                [60, 60, 0], [120, 120, 0], [180, 180, 0], [240, 240, 0], [300, 300, 0]],
        'human_rotation_list': [[0, 0, 0] for _ in range(10)],
        'mask_color': [[126, 12, 250], [1, 17, 250], [12, 153, 250], [250, 249, 25], [250, 158, 25],
                       [12, 250, 226], [0, 250, 82], [81, 250, 12], [250, 96, 25], [250, 25, 230]],  # RGB
        'scale': [1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
        'action': ['walk' for _ in range(10)],
    },
}


def get_human_config(num_humans=None):

    if num_humans is None or num_humans <= 0:
        config_dict = np.random.choice(list(human_config_dict.values()))
        num_humans = len(config_dict['human_id_list'])
    else:
        config_dict = human_config_dict[num_humans]

    # config_dict['walk_speed_range'] = walk_speed_range if walk_speed_range is not None else human_config_dict['walk_speed_range']
    # config_dict['rot_speed_range'] = human_config_dict['rot_speed_range']
    config_dict['num_humans'] = num_humans
    return num_humans, config_dict


def get_env_config(env_name=None):
    if env_name is None:
        return np.random.choice(list(env_config_dict.items()))
    else:
        return env_name, env_config_dict[env_name]


def get_map_config(map_name='default'):
    return map_config_dict[map_name]


def get_human_model_config(model_name='default'):
    return model_name, human_model_config_dict[model_name]


def baseline_env_builder(C, S, H=2, P=0.35):
    key = f'C{C}_{S}x{S}_h{H}0_p35'
    size = S * 100.0 / 2
    height = H * 100.0
    pitch = P * 100.0
    D = {
        'env_description': f'{S}X{S} square, cameras height: {H}.0m, with a pitch of {pitch}',
        'area': np.array([
            [size, size],
            [size, -size],
            [-size, -size],
            [-size, size]
        ]),
        'area_shape': 'rectangle',  # used to sample points, sample rate = 0.9
        'num_cameras': C,
        'human_mesh_list': ['ch{}'.format(i) for i in range(1, 7)],
        'floor_z_of_human': 0,  # z location for human object
        'lower_bound_for_camera': [-size - 150.0, -size - 150.0, 90],  # x, y, z, camera move area
        'higher_bound_for_camera': [size + 150.0, size + 150.0, 450],  # x, y, z
    }

    if C == 2:
        D['camera_param_list'] = [
            np.array((size, size, height, -pitch, -45.0, 0, 90.0), dtype=np.float32),
            np.array((-size, -size, height, -pitch, 45.0, 0, 90.0), dtype=np.float32),
        ]
    elif C == 3:
        D['camera_param_list'] = [
            np.array((0, -size, height, -pitch, 90.0, 0, 90.0), dtype=np.float32),
            np.array((-size, size, height, -pitch, -45.0, 0, 90.0), dtype=np.float32),
            np.array((size, size, height, -pitch, -135.0, 0, 90.0), dtype=np.float32)
        ]
    elif C == 4:
        D['camera_param_list'] = [
            np.array((size, size, height, -pitch, -135.0, 0, 90.0), dtype=np.float32),
            np.array((size, -size, height, -pitch, 135.0, 0, 90.0), dtype=np.float32),
            np.array((-size, -size, height, -pitch, 45.0, 0, 90.0), dtype=np.float32),
            np.array((-size, size, height, -pitch, -45.0, 0, 90.0), dtype=np.float32)
        ]

    return {key: D}


for c in [2, 3, 4]:
    for s in [6, 10, 20]:
        for h in [3]:
            env_config_dict.update(baseline_env_builder(c, s, h))
