import gym
import os
from argparse import Namespace

from .base import MultiviewPose
# from .base_value import MultiviewPose_Value
from unrealpose.config import config, update_config
from unrealpose.envs.wrappers import *
from unrealpose import ROOT_DIR


def make_env(
    args=None,
    air_wall_outer=False,
    air_wall_inner={'use': False, 'args': {'lower_bound': [-200, -200, 0], 'higher_bound': [200, 200, 500]}},
    gt_observation={'use': False, 'args': {'gt_noise_scale': 0}},
    place_cam={'use': False, 'args': {'num_place_cameras': 1, 'place_on_slider': False}},
    fix_human={'use': False, 'args': {'random_init_states': False, 'index_list': None}},
    movable_cam={'use': False, 'args': {'num_movable_cameras': 1}},
    rule_based_rot={'use': False, 'args': {'use_gt3d': True, 'num_rule_cameras': None, 'index_list': [0]}},
    slider={'use': False},
    reach_target_done={'use': False},
    scale_human={'use': False, 'args': {'scale': 2, 'index_list': None}},
    ego_action={'use': False},
    rot_limit={'use': False, 'args': {'pitch_low': -85, 'pitch_high': 85, 'yaw_low': -360, 'yaw_high': 360}},
    rand_reset_human={'use': False, 'args': {'random_init_loc_rot': True}},
    shuffle_cam_id={'use': False},
    partial_triangulation={'use':False},
    imitate_rot={'use':False, 'args': {'index_list': [0]}},
    **kwargs,
):
    update_config(config, args)

    # TODO: Move this to a better place
    config['NETWORK']['PRETRAINED'] = os.path.join(ROOT_DIR, config['NETWORK']['PRETRAINED'])
    config['TEST']['MODEL_FILE'] = os.path.join(ROOT_DIR, config['TEST']['MODEL_FILE'])

    worker_index = getattr(args, 'worker_index', 0)
    env = MultiviewPose(config, worker_index=worker_index)

    if air_wall_outer:
        env = AirWallOuter(env)

    if air_wall_inner.get('use', False):
        env = AirWallInner(env, **air_wall_inner.get('args', dict()))

    if gt_observation.get('use', False):
        env = GroundTruthObservation(env, **gt_observation.get('args', dict()))

    if place_cam.get('use', False):
        env = PlaceCam(env, **place_cam.get('args', dict()))

    if fix_human.get('use', False):
        env = FixHuman(env, **fix_human.get('args', dict()))

    if movable_cam.get('use', False):
        env = MovableCam(env, **movable_cam.get('args', dict()))

    if rule_based_rot.get('use', False):
        env = RuleBasedRot(env, **rule_based_rot.get('args', dict()))

    if slider.get('use', False):
        env = Slider(env)

    if reach_target_done.get('use', False):
        env = ReachTargetDone(env)

    if scale_human.get('use', False):
        env = ScaleHuman(env, **scale_human.get('args', dict()))

    if ego_action.get('use', False):
        env = EgoAction(env)

    if rot_limit.get('use', False):
        env = RotLimit(env, **rot_limit.get('args', dict()))

    if rand_reset_human.get('use', False):
        env = RandResetHuman(env, **rand_reset_human.get('args', dict()))

    if shuffle_cam_id.get('use', False):
        env = ShuffleCamID(env)

    if partial_triangulation.get('use', False):
        env = PartialTriangulation(env)

    if imitate_rot.get('use', False):
        env = ImitateRot(env, **imitate_rot.get('args', dict()))

    return env


# def make_env_numerical(
#     args=None,
#     air_wall=True,
#     gt_observation=False,
#     place_cam={'use': False, 'args': {'num_place_cameras': 1, 'place_on_slider': False}},
#     fix_human={'use': False, 'args': {'random_init_states': False, 'index_list': None}},
#     movable_cam={'use': False, 'args': {'num_movable_cameras': 1}},
#     rule_based_rot={'use': False, 'args': {'use_gt3d': True}},
#     slider={'use': False},
#     **kwargs):
#     """
#     Only AirWall, SingleEvaluationStep and NormalizeObservation
#     FlattenAction, FlattenObservation, can be used !!!!
#     """

#     update_config(config, args)

#     env = MultiviewPose_Value(config)

#     if air_wall:
#         env = AirWall(env)

#     if gt_observation:
#         raise NotImplementedError
#         # env = GroundTruthObservation(env)

#     if place_cam.get('use', False):
#         env = PlaceCam(env, **place_cam.get('args', dict()))

#     if fix_human.get('use', False):
#         raise NotImplementedError
#         # env = FixHuman(env, **fix_human.get('args', dict()))

#     if movable_cam.get('use', False):
#         raise NotImplementedError
#         # env = MovableCam(env, **movable_cam.get('args', dict()))

#     if rule_based_rot.get('use', False):
#         raise NotImplementedError
#         # env = RuleBasedRot(env, **rule_based_rot.get('args', dict()))

#     if slider.get('use', False):
#         # not implemented now !
#         env = Slider(env)

#     return env


gym.register(id='base-v0', entry_point=make_env)
# gym.register(id='base-num-v0', entry_point=make_env_numerical)
