## Code for Robust Imitation Learning via Decision-Time Planning

### Requirements:

* Stable Baselines
* MuJoCo
* Tensorflow
```
conda env create -f environment.yml
conda activate sb
```

### Commands:

To train a GAIL agent: 
`
python scripts/run_gail_experiment.py --traj_limitation 4 --env_id Hopper-v2 --expert_path data/expert_demonstrations/hopper_trpo_subsampled.npz --total_timesteps 2000000 --seed 0
`

To run IMPLANT on the trained GAIL agent:
`
python scripts/run_rejection_sampling_experiment.py --env_id Hopper-v2 --generator gail --no-use_airl --dis_path results/<date>/gail/100_best_gail_Hopper-v2_traj4.0_testing_0 --n_epochs 0 --generator_path results/<date>/gail/100_best_gail_Hopper-v2_traj4.0_testing_0--no-eval_best --n_envs 20 --look_ahead 100 --seed 0
`

To run in causal confusion settings, add the following flags:
`
--train_mode confounded
--eval_mode original
`
To run in motor noise settings, add the following flags:
`
--eval_mode noisy --sigma <value>
`
To run in dynamics noise settings, add the following flags:
`
--eval_mode noisy-obs --sigma <value>
`