from numpy import genfromtxt
import numpy as np
import matplotlib.pyplot as plt

original = genfromtxt('results/rollouts/logs_gail_Hopper-v2_original_500000_0.monitor.csv', delimiter=',')
original = original[1:]

confounded = genfromtxt('results/rollouts/logs_confounded_0.monitor.csv', delimiter=',')
confounded = confounded[1:]
interval = 1

fig, ax = plt.subplots()  # a figure with a single Axes
ax.plot(range(0, original.shape[0], interval), original[::interval,0], label="original")
ax.plot(range(0, confounded.shape[0], interval), confounded[::interval,0], label="confounded")
ax.set_xlabel("Num of episodes during training")
ax.set_ylabel("Reward")
ax.legend()

plt.show()
# plt.savefig("results/dump/seed0")

