import gym
import numpy as np

class NoisyActionWrapper(gym.ActionWrapper):
    def __init__(self, env, sigma=1.0):
        super().__init__(env)
        self.sigma = sigma

    def action(self, act):
        # modify act
        return act + np.random.randn(*self.action_space.shape) * self.sigma