''' This script shows that, in a QL Fisher market, a buyer i can misreport its valuations v[i] (even subject to v[i] @ s == constant) to attain a higher QL utility at equilibrium '''

import numpy as np
np.random.seed(2021)
from utils import compute_qlme_mosek
from mosek.fusion import *

############################################################
# each item has supply s[j] == 1/m, NOT s[j] == 1

n = m = 2
# n, m = v.shape
B = (np.random.uniform(0,1, n) + 0.2) * 3
B /= np.sum(B)
# s = np.ones(m) / m
s = np.random.uniform(size=m)
s /= np.sum(s)

v_true = (2 * (np.random.exponential(size=(n,m)) + np.random.uniform(size=(n,m)))) / 4

print('m = {}, n = {}'.format(m, n))
print()

print('B[0] = {}, B[1] = {}'.format(*B))
print('s[0] = {}, s[1] = {}'.format(*s))
print()

print('true v[0] = {}'.format(v_true[0]))
print('true v[1] = {}'.format(v_true[1]))
print()

# misreport
method = 1 # 1 or 2
v_mis = v_true.copy()
if method == 1: # buyer 1's valuation changes but its total valuation of all items is the same
    v_mis[1] = np.random.uniform(size=m)
    total = v_mis[1] @ s
    v_mis[1] = v_mis[1] / total * (v_true[1] @ s)
# if method == 2: v_mis = 0.25 * v_true # both scale down together

print('misreported v[0] = {}'.format(v_mis[0]))
print('misreported v[1] = {}'.format(v_mis[1]))
print()

print(f'buyer 1 total value of all items true & misreport: {v_mis[1] @ s}, {v_true[1] @ s}')
print()

x_true, u_true, delta_true, beta_true, p_true = compute_qlme_mosek(v_true, s, B)
u_qlme_true = np.sum(v_true * x_true, axis=1) - np.sum(p_true * x_true, axis=1)
x_mis, u_mis, delta_mis, beta_mis, p_mis = compute_qlme_mosek(v_mis, s, B)
u_qlme_mis = np.sum(v_true * x_mis, axis=1) - np.sum(p_mis * x_mis, axis=1)

print('buyer 0 truthful beta = {:.4f}, misreport beta = {:.4f}'.format(beta_true[0], beta_true[1]))
print('buyer 1 truthful beta = {:.4f}, misreport beta = {:.4f}'.format(beta_mis[0], beta_mis[1]))
print()
print('truthful item prices = {}'.format(p_true))
print('misreport item prices = {}'.format(p_mis))
print()
print('buyer 0 truthful QLME utility = {:.4f}, misreport QLME utility = {:.4f}'.format(u_qlme_true[0], u_qlme_mis[0]))
print('buyer 1 truthful QLME utility = {:.4f}, misreport QLME utility = {:.4f}'.format(u_qlme_true[1], u_qlme_mis[1]))