import numpy as np
np.random.seed(2021)
from utils import compute_qlme_mosek
from mosek.fusion import *

############################################################
# each item has supply s[j] == 1/m, NOT s[j] == 1

n, m = 2, 3
# n, m = v.shape
B = (np.random.uniform(0,1, n) + 0.2) * 3
B /= np.sum(B)
# s = np.ones(m) / m
s = np.random.uniform(size=m)
s /= np.sum(s)

v_true = (2 * (np.random.exponential(size=(n,m)) + np.random.uniform(size=(n,m)))) / 4
# misreport

method = 2 # 1 or 2
v_mis = v_true.copy()
if method == 1: v_mis[1] *= 0.25 # buyer 1 scales down its utility
if method == 2: v_mis = 0.25 * v_true # both scale down together

x_true, u_true, delta_true, beta_true, p_true = compute_qlme_mosek(v_true, s, B)
u_qlme_true = np.sum(v_true * x_true, axis=1) - np.sum(p_true * x_true, axis=1)
x_mis, u_mis, delta_mis, beta_mis, p_mis = compute_qlme_mosek(v_mis, s, B)
u_qlme_mis = np.sum(v_true * x_mis, axis=1) - np.sum(p_mis * x_mis, axis=1)

print('truthful beta[0] = {:.4f}, truthful beta[1] = {:.4f}'.format(*beta_true))
print('misreport beta[0] = {:.4f}, misreport beta[1] = {:.4f}'.format(*beta_mis))
print()
print('truthful item prices = {}'.format(p_true))
print('misreport item prices = {}'.format(p_mis))
print()
print('buyer 0 truthful QLME utility = {:.4f}, misreport QLME utility = {:.4f}'.format(u_qlme_true[0], u_qlme_mis[0]))
print('buyer 1 truthful QLME utility = {:.4f}, misreport QLME utility = {:.4f}'.format(u_qlme_true[1], u_qlme_mis[1]))