from abc import ABC, abstractmethod
from typing import Any, Dict

import torch

from ...protocol import DataProto
from .config import RewardConfig


__all__ = ["BasePPORM"]


class BasePPORM(ABC):
    def __init__(self, config: RewardConfig):
        self.config = config

    @abstractmethod
    def compute_rm_score(self, data: DataProto, processor) -> torch.Tensor:
        """Compute values"""
        pass

    @abstractmethod
    def update_rm(self, data: DataProto, processor) -> Dict[str, Any]:
        """Update the critic"""
        pass