
# Official Implementation of SATCH

This repository contains the implementation of **SATCH** for class-incremental learning. SATCH utilizes an assistant teacher to guide task learning and improve performance in both clean and noisy label settings.

This codebase is based on [Mammoth](https://github.com/aimagelab/mammoth).

## 1. Dataset Setup

- **CIFAR-100**: This dataset will automatically download when evaluating on CIFAR-100.
- **TinyImageNet**: To download and extract, run:
  ```bash
  bash download_tinyimagenet.sh
  ```
  and move the extracted results to `/data/TINYIMG`.
- **MiniImageNet**: Download the dataset from [this Kaggle link](https://www.kaggle.com/datasets/arjunashok33/miniimagenet) and extract it to `/data/MINIIMG`.

## 2. Experimental Results

### Class Incremental Learning

To reproduce the results reported for class-incremental learning on CIFAR-100, TinyImageNet, and MiniImageNet, use the following commands:

```bash
bash scripts/buf_cifar.sh
bash scripts/buf_tiny.sh
bash scripts/buf_mini.sh
```

### Noisy Label Settings

For experiments on noisy label settings with CIFAR-100 and TinyImageNet, use the following commands:

```bash
bash scripts/buf_cifar_noise.sh
bash scripts/buf_tiny_noise.sh
```

### Ablation Study

To reproduce the ablation study for all SATCH components and backbone sizes on CIFAR-100, use:

```bash
bash scripts/ablation.sh
```


All hyperparameters can be seen in the bash files for the following methods:
- ER
- ER-ACE
- DER++
- SSIL
- CLS-ER
- ESMER


SATCH adds two new arguments: 
- `lamb` is the \lambda hyper-parameter controlling influence of the assistant teacher when guiding new task learning 
- `teacher_backbone` is the backbone for the assistant teacher, the options are:
  - `resnet18_lg` is the resnet18 backbone
  - `resnet18` is the reduced resnet18 backbone
  - `conv_real` is the 3 layer convnet

Example command using DER++ + SATCH on CIFAR-100 with 5000 buffer size
```
python main.py --gpu_id 0 --model derpp_ablation --biam 1 --bufs 1 --newl 1 --divk 1 --teacher_backbone resnet18 --lamb 0.1 --alpha 0.1 --beta 0.5 --lr 0.03 --buffer_size 5000 --dataset seq-cifar100 --seed 0 --backbone resnet18_lg --epochs 50 --n_tasks 10 --name buf_tkd 
```

The bash files provided in this repository allow you to experiment with various methods, including:
- **ER**
- **ER-ACE**
- **DER++**
- **SSIL**
- **CLS-ER**
- **ESMER**

SATCH introduces two new arguments:
- `lamb`: The λ (lambda) hyper-parameter, which controls the influence of the assistant teacher during task learning.
- `teacher_backbone`: The backbone used for the assistant teacher. Options include:
  - `resnet18_lg`: Large ResNet-18 backbone
  - `resnet18`: Reduced ResNet-18 backbone
  - `conv_real`: A 3-layer convolutional network backbone

## 4. Example Command

Below is an example of how to run **DER++ with SATCH** on CIFAR-100 using a buffer size of 5000:

```bash
python main.py --gpu_id 0 --model derpp_ablation --biam 1 --bufs 1 --newl 1 --divk 1 --teacher_backbone resnet18 --lamb 0.1 --alpha 0.1 --beta 0.5 --lr 0.03 --buffer_size 5000 --dataset seq-cifar100 --seed 0 --backbone resnet18_lg --epochs 50 --n_tasks 10 --name buf_tkd
```

This command runs the SATCH method with the specified hyperparameters, including a buffer size of 5000, a learning rate of 0.03, and using a ResNet-18 backbone for both the model and the assistant teacher.

## Dependencies

Ensure you have the required Python libraries by installing them with:

```bash
pip install -r requirements.txt
```

