"""
Reddit evaluation implementation.

This package provides a PostgreSQL-based approach for validating Reddit intent templates
by directly querying the Postmill forum database, offering reliable and efficient evaluation.

Core modules:
- data_helper: Consolidated data access using docker exec
- validator: Framework-integrated validation class
- models: Pydantic models for type safety
- test_reddit_benchmark_templates: Comprehensive benchmark test suite

The database approach achieves 100% coverage of all 19 program_html Reddit intent templates.
"""

from .data_helper import RedditDataHelper
from .models import (
    CommentInfo,
    PostInfo,
    RedditConfig,
    SubredditInfo,
    SubscriptionInfo,
    UserInfo,
    ValidationResponse,
    VoteInfo,
)
from .validator import RedditValidator

__all__ = [
    "RedditDataHelper",
    "RedditValidator",
    "RedditConfig",
    "UserInfo",
    "SubredditInfo",
    "PostInfo",
    "CommentInfo",
    "ValidationResponse",
    "VoteInfo",
    "SubscriptionInfo",
]
