## This repository is the official implementation of Structuring Semantic Embeddings for Principle Evaluation: A Kernel-Guided Contrastive Learning Approach.

# Requirements

## You may use requirement.txt to install the packages:

pip install -r requirements.txt

## Required packages for the script

## Python version: 3.11.9

torch==2.3.0
numpy==1.26.4
scikit-learn==1.5.0
tqdm==4.66.4
pandas==2.2.2
xgboost==2.0.3
scipy==1.13.1

## For LLM few-shot

openai==1.35.7
google-generativeai==0.7.1
requests==2.32.3

## Notes:

### 1. The torch version listed is for the base package.

### If you require CUDA support, please install the appropriate PyTorch build

### for your CUDA version. For example, for CUDA 12.1, you might install:

### pip install torch==2.3.0+cu121 torchvision torchaudio --index-url https://download.pytorch.org/whl/cu121

### Refer to the official PyTorch website (pytorch.org) for the correct command.

# 

### 2. These versions are known to be compatible with Python 3.11.

### If you encounter issues, you might need to adjust versions based on your specific environment

### or the exact versions used during the original development of the script.


# Instructions for the training process (by default, the trained models will be placed in the current directory)

## 1. GoEmotions

python train_contrastive.py --data_prefix dataset/GoEmotions/

## 2. AmazonReviews

### 2.1 Classification

python train_contrastive.py --data_prefix dataset/AmazonReviews/

### 2.2 Ordinal Regression

python train_contrastive.py --data_prefix dataset/AmazonReviews/ --enable_magnitude_loss

## 3. ToxicComment

python train_contrastive.py --data_prefix dataset/ToxicComment/ --num_classes 2

## Please note: Due to attachment size limitations, the train_set has not been included. Therefore, the scripts for training the models cannot be executed successfully. We kindly ask for your understanding.

# Instructions to call the pre_trained models for evaluation

## 1. GoEmotions

python eval_contrastive.py --data_prefix dataset/GoEmotions/ --contrastive_model_path pre_trained_model/GoEmotions/contrastive_model.pth

## 2. AmazonReviews

### 2.1 Classification

python eval_contrastive.py --data_prefix dataset/AmazonReviews/ --contrastive_model_path pre_trained_model/AmazonReviews/contrastive_model.pth

### 2.2 Ordinal Regression

python eval_contrastive.py --data_prefix dataset/AmazonReviews/ --contrastive_model_path pre_trained_model/AmazonReviews/contrastive_model.pth --enable_magnitude_loss_metrics

## 3. ToxicComment

python eval_contrastive.py --data_prefix dataset/ToxicComment/ --contrastive_model_path pre_trained_model/ToxicComment/contrastive_model.pth --num_classes 2

# Instructions to call the few-shot LLM for evaluation

## 1. GoEmotions

python eval_llm_few_shot.py --task_type emotion --api_key sk-or-v1-your_open_router_api_key

## 2. AmazonReviews

python eval_llm_few_shot.py --task_type rating --api_key sk-or-v1-your_open_router_api_key

## 3. ToxicComment

python eval_llm_few_shot.py --task_type toxicity --api_key sk-or-v1-your_open_router_api_key
