import os
import sys
import numpy as np
import subprocess
import argparse

BASE_TRANSFORM_NAMES = ['rotation', 'permutation', 'split']

def friendly_err(err_msg):
    # add whitespace to error message to make it more readable
    return '\n\n' + err_msg + '\n\n'

def get_arg_list(args):
    if isinstance(args, argparse.Namespace):
        args = vars(args)
    elif isinstance(args, dict):
        pass
    else:
        raise ValueError("Wrong format for args")
    
    arg_list = []
    for key, value in args.items():
        if key is not 'transform':
            option = '--' + key
            arg_list += [str(option), str(value)]
        else:
            cmd = value
    return cmd, arg_list

def conver_to_argument(**kwargs):
    if not 'i' in kwargs.keys():
        kwargs['i'] = 'raw/'
    return kwargs


def build_dataset(args):
    """Interprets the method of data generation and cmd lin args"""
    cmd, args_list = get_arg_list(args)

    if cmd not in BASE_TRANSFORM_NAMES:
        raise ValueError(friendly_err("Wrong transformation"))
    else:
        runfile = os.path.join(os.path.abspath(os.path.dirname(__file__)),
            cmd+'.py')
        run_args = [sys.executable if sys.executable else 'python', runfile] + args_list
        subprocess.check_call(run_args, env=os.environ)


if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()

    parser.add_argument('--i', default='raw/', help='raw datasets for continual learning')
    parser.add_argument('--num_tasks', default=3, type=int, help='number of different tasks')
    parser.add_argument('--seed', default=0, type=int, help='random seed')
    parser.add_argument('--raw_data', default='mnist', help='raw dataset for using continual learning')
    parser.add_argument('--transform', default='rotation', help='transformation method')

    args = parser.parse_args()
    build_dataset(args)