import argparse

def parse_args():
    parser = argparse.ArgumentParser()

    parser.add_argument("--dataset", help='dataset',
                        required=True, type=str)
    parser.add_argument("--backbone", help='backbone network',
                        choices=['bert', 'roberta', 'roberta_large', 'albert'],
                        default='roberta', type=str)
    parser.add_argument("--seed", help='random seed',
                        default=0, type=int)

    # Common
    parser.add_argument("--train_type", help='training details',
                        default='base', type=str)
    parser.add_argument("--epochs", help='training epochs',
                        default=20, type=int)
    parser.add_argument("--batch_size", help='training bacth size',
                        default=16, type=int)
    parser.add_argument("--model_lr", help='learning rate for model update',
                        default=1e-5, type=float)
    parser.add_argument("--save_ckpt", help='save the best model checkpoint',
                        action='store_true')
    parser.add_argument("--pre_ckpt", help='path for the pre-trained model',
                        default=None, type=str)

    # P2C
    parser.add_argument("--pre_pref", help='pregenerated preference data',
                        default=None, type=str)
    parser.add_argument("--n_layers", help='number of layers for preference head',
                        default=2, type=int)
    parser.add_argument("--activation", help='tanh|sig|relu',
                        default='tanh', type=str)
    parser.add_argument("--lambda_cons", help='weight for consistency regularization',
                        default=1.0, type=float)
    parser.add_argument("--ensemble", help='using multi-heads preference module',
                        action='store_true')
    parser.add_argument("--sampling", help='None (random) | disagreement | inconsistency',
                        default=None, type=str)
    parser.add_argument("--cons_margin", help='using consistency regularization with margin',
                        action='store_true')
    parser.add_argument("--cons_order", help='using consistency regularization without margin',
                        action='store_true')
    return parser.parse_args()

