
from abc import ABC, abstractmethod
from typing import List, Tuple, Any, Dict

class BaseScoringMethod(ABC):
    def __init__(self, context_tokenizer: Any, max_example_length: int = 50):
        self.context_tokenizer = context_tokenizer
        self.max_example_length = max_example_length

    @abstractmethod
    def prepare_examples(
        self, 
        examples: List[Any], 
    ) -> Tuple[List[str], List[bool]]:
        pass

    @abstractmethod
    def create_prompt(self, interpretation: str, examples: List[str]) -> str:
        pass

    @abstractmethod
    def parse_response(self, response: str, batch_size: int) -> List[int]:
        pass

    @property
    @abstractmethod
    def system_prompt(self) -> str:
        pass
    
    @abstractmethod
    def compute_metrics(self, predictions: List[int], labels: List[bool]) -> Dict[str, float]:
        pass