
from typing import List, Any, Tuple
from src.scoring.classifier import ClassifierScoringMethod

class DetectionScoringMethod(ClassifierScoringMethod):
    @property
    def system_prompt(self) -> str:
        return """You are an intelligent and meticulous linguistics researcher.

You will be given a certain latent of text, such as "male pronouns" or "text with negative sentiment".

You will then be given several text examples. Your task is to determine which examples possess the latent.

For each example in turn, return 1 if the sentence possess this latent or 0 if not. You must return your response in a valid Python list of the same length as the number of presented examples. Do not return anything else besides a Python list.
"""

    def prepare_examples(
        self, examples: List[Any]
    ) -> Tuple[List[str], List[bool]]:
        prepared = []
        labels = []
        for ex in examples:
            tokens = ex.context[:self.max_example_length]
            prepared.append(self.context_tokenizer.decode(tokens))
            labels.append(ex.is_positive)
        return prepared, labels