#!/bin/bash

optimisers=(
    'SGD'
    'SGDmwd'
    'Adam'
    # 'AdamQLR_Damped_AdamDampedCurvature'
    # 'SGDQLR_Undamped_Hessian'
    # 'SGDQLR_Damped_Hessian'
    # 'AdamQLR_Undamped_Hessian'
    # 'AdamQLR_Damped_Hessian'
    # 'AdamQLR_Damped_Clipped'
    # 'AdamQLR_Undamped_Amplified'
    # 'AdamQLR_Damped_Amplified'
    'KFAC'
    # 'SGDQLR_Undamped'
    # 'SGDQLR_Damped'
    # 'AdamQLR_Undamped'
    # 'AdamQLR_Undamped_Clipped'
    'AdamQLR_Damped'
    # 'AdamQLR_Damped_Enveloped'
    # 'KFACwithDynamicKroneckerCorrections_Implicit_ApproxTrueGrad'
    # 'KFACwithDynamicKroneckerCorrections_Implicit_SeparateProducts'
    # 'KFACwithDynamicKroneckerCorrections_Implicit_TrueApproxGrad'
    # 'KFACwithDynamicKroneckerCorrections_Explicit_ApproxTrueGrad'
    # 'KFACwithDynamicKroneckerCorrections_Explicit_SeparateProducts'
    # 'KFACwithDynamicKroneckerCorrections_Explicit_TrueApproxGrad'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitOverride_ApproxTrueGrad'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitOverride_SeparateProducts'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitOverride_TrueApproxGrad'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitCholesky_ApproxTrueGrad'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitCholesky_SeparateProducts'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitCholesky_TrueApproxGrad'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitOverrideCholesky_ApproxTrueGrad'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitOverrideCholesky_SeparateProducts'
    # 'KFACwithDynamicKroneckerCorrections_ExplicitOverrideCholesky_TrueApproxGrad'
)

datasets=(
    'uci_energy'
    'uci_protein'
    'fashion_mnist'
    'svhn'
    'cifar-10'
    # 'penn_treebank_gpt2_reset'
)

for dataset in ${datasets[@]}
do
    for optimiser in ${optimisers[@]}
    do
        echo "================================================================================"
        echo "================================================================================"
        echo "================================================================================"
        echo "Starting ${dataset}, ${optimiser}..."
        XLA_PYTHON_CLIENT_PREALLOCATE=false python hyperparameter_optimisation.py -c "configs/${dataset}.yaml" "configs/${optimiser}.yaml" configs/ASHA_training.yaml --log_root "/path/to/runs/ASHA_Time_Training"
        echo "Finished ${dataset}, ${optimiser}."
    done
done
echo "================================================================================"
echo "================================================================================"
echo "================================================================================"
