# How to run:
1. Tested on Ubuntu20/22.
2. Assuming your home folder is: `/home/ubuntu` (if not, you'll have to edit the settings to the correct place)

## Traces:
In order to run experiments you'll need to run FCC traces and convert them into mahimahi format.
1. `cd traces`
2. run `install.sh` (download a csv file) or pick one of your own
3. make a virtualenv and install requirements: `python3.7 -m virtualenv venv & source venv/bin/activte & pip install -r requirements.txt`
4. run the parser over the downloaded csv: `python load_webget_data.py`
5. run the parser to mahimahi format: `python convert_to_mahimahi.py`
6. As an output you'll get a folder called 'mahimahi'. It contains two folders - 'train' and 'test' containing the dataset.

## Puffer 
Puffer is used to simulate mahimahi client shells connected to video server.
1. `cd puffer`
2. run `scripts/install_by_hand.sh`. It will install the required packages (c and python), install mahimahi shell, install chromium, create postgres database used to save experiments configs, install influxdb used to save logs, compile the project such that it will be ready for run.
3. Download from puffer page media videos (https://storage.googleapis.com/puffer-stanford-public/media-181230.tar.gz)

## Evaluation
1. Set traces folder in `/puffer/src/media-server/offline_test.py` (default to `/home/ubuntu/traces/mahimahi/`)
2. Edit `src/settings.yml` (watch for `log_dir`, `media_dir`, db connections, `ttp_model_dir`)
2. `cd puffer`
2. run the script: `scripts/eval_all.sh` (it will run all the five algorithms over mahimahi shells using the traces)

## Train Wolfi
1. `cd puffer`
2. Run `scripts/train_eval_ttp.sh` (in order to train TTP on the traces)
2. Run the script: `scripts/train_eval_rl.sh`

Note: We also attached the weights and traces we run the simulations on. you can use them in order to regenerate out results.

Link to the weights: https://drive.google.com/file/d/1cSH6bcGWErb9C8Bq5DUcHP6nk_Z7qamL/view?usp=sharing