#!/bin/bash

ALGO=PPO

mkdir -p logs

echo "#### RL find optimal weight ####\n" >> logs/results.log
date >> logs/results.log
for i in $(seq $1 $2); do
    influx -execute 'drop series from /.*/' -database="puffer"
    echo "./weights/models/$ALGO/checkpoint_000$i" > ./weights/models/$ALGO/last_checkpoint.out
    python3.7 ./src/scripts/train/rlserver.py --type=inference & 
    RL_PID=$!
    sleep 10
    python3.7 ./src/media-server/offline_test.py -t

    kill $RL_PID
    sleep 60

    echo "No.$i\n" >> logs/results.log
    python3.7 src/scripts/plot_ssim_rebuffer.py src/settings.yml -o plot.png >> logs/results.log
    echo "===========================================================" >> logs/results.log
done
