#!/bin/bash

# python requirements
sudo apt-get install python3.7 python3-pip -y
sudo python3.7 -m pip install --upgrade pip
python3.7 -m pip install virtualenv
python3.7 -m virtualenv venv
source venv/bin/activate
pip3 install -r requirements.txt

# puffer
sudo apt install unzip -y

# install postgres
sudo apt install postgresql -y
sudo -u postgres psql
sudo -u postgres psql -c "CREATE DATABASE puffer;"
sudo -u postgres psql -c "CREATE USER puffer WITH PASSWORD '123456';"
sudo -u postgres psql -c "GRANT ALL PRIVILEGES ON DATABASE puffer TO puffer;"

# install influx - https://docs.influxdata.com/influxdb/v1.7/introduction/installation/
wget -qO- https://repos.influxdata.com/influxdata-archive_compat.key | sudo apt-key add -
source /etc/lsb-release
echo "deb https://repos.influxdata.com/${DISTRIB_ID,,} ${DISTRIB_CODENAME} stable" | sudo tee /etc/apt/sources.list.d/influxdb.list
sudo apt-get update && sudo apt-get install influxdb
sudo systemctl unmask influxdb.service
sudo systemctl start influxdb
sudo systemctl enable influxdb

influx -execute "CREATE USER puffer WITH PASSWORD '123456' WITH ALL PRIVILEGES"

# install mahimahi
sudo apt-get install mahimahi -y
exec zsh # or bash

# install docker - for compiling
sudo apt-get update
sudo apt-get install \
    ca-certificates \
    curl \
    gnupg \
    lsb-release -y
sudo mkdir -m 0755 -p /etc/apt/keyrings
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /etc/apt/keyrings/docker.gpg
echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.gpg] https://download.docker.com/linux/ubuntu \
  $(lsb_release -cs) stable" | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
sudo apt-get update
sudo apt-get install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin -y

# compile with docker
sudo docker build . -t puffer/build

# setup puffer - files in dir and in the docker are the same
./fetch_submodules.py
docker run -it -v $(pwd):/home/user/puffer/ puffer/build ./autogen.sh
docker run -it -v $(pwd):/home/user/puffer/ puffer/build ./configure
docker run -it -v $(pwd):/home/user/puffer/ puffer/build make -j CXXFLAGS='-DNONSECURE'


docker run -it -v $(pwd):/home/user/puffer/ \
                -v /home/ubuntu/traces:/home/user/traces \
                -v /home/ubuntu/ubuntu/media-181230:/home/user/ubuntu/media-181230 \
                puffer/build /bin/bash -c "./fetch_submodules.py; ./autogen.sh; ./configure; make -j CXXFLAGS='-DNONSECURE'"

docker run -it -v $(pwd):/home/user/puffer/ -p 5432:5432 -p 8086:8086 puffer/build ./src/media-server/run_servers src/settings.yml 0
