#!/bin/bash

# puffer
sudo apt-get install -y -q gcc-7 g++-7 libmpeg2-4-dev libpq-dev \
                          libssl-dev libcrypto++-dev libyaml-cpp-dev \
                          libboost-dev liba52-dev opus-tools libopus-dev \
                          libsndfile-dev libavformat-dev libavutil-dev ffmpeg \
                          git automake libtool python python3 cmake wget \
                          libcurl4-openssl-dev libcurlpp-dev libcurl4-openssl-dev \
                          libcurlpp-dev unzip

sudo update-alternatives --install /usr/bin/gcc gcc /usr/bin/gcc-7 99
sudo update-alternatives --install /usr/bin/g++ g++ /usr/bin/g++-7 99

git clone https://github.com/jtv/libpqxx.git
cd libpqxx && git checkout 6.2.5 && ./configure --enable-documentation=no && sudo make -j3 install

# enable bbr
echo "net.core.default_qdisc=fq" | sudo tee --append /etc/sysctl.conf
echo "net.ipv4.tcp_congestion_control=bbr" | sudo tee --append /etc/sysctl.conf
sudo sysctl -p

# install postgres
sudo apt install postgresql -y
sudo -u postgres psql -c "CREATE DATABASE puffer;"
sudo -u postgres psql -c "CREATE USER puffer WITH PASSWORD '123456';"
sudo -u postgres psql -c "GRANT ALL PRIVILEGES ON DATABASE puffer TO puffer;"

# install influx - https://docs.influxdata.com/influxdb/v1.7/introduction/installation/
wget -qO- https://repos.influxdata.com/influxdata-archive_compat.key | sudo apt-key add -
source /etc/lsb-release
echo "deb https://repos.influxdata.com/${DISTRIB_ID,,} ${DISTRIB_CODENAME} stable" | sudo tee /etc/apt/sources.list.d/influxdb.list
sudo apt-get update && sudo apt-get install influxdb
sudo systemctl unmask influxdb.service
sudo systemctl start influxdb
sudo systemctl enable influxdb

influx -execute "CREATE USER puffer WITH PASSWORD '123456' WITH ALL PRIVILEGES"
influx -execute "CREATE DATABASE puffer"

sudo sysctl -w fs.inotify.max_user_instances=2000000
sudo sysctl -w fs.inotify.max_user_watches=2000000
# to make permanent change `vim /etc/sysctl.conf` then run `sysctl -p`


# install mahimahi
sudo apt-get install mahimahi -y
exec zsh # or bash

# install chrome-browser
sudo apt install -y chromium-browser

# python requirements
sudo apt-get install python3.7 python3-pip
sudo python3.7 -m pip install --upgrade pip
python3.7 -m pip install virtualenv
python3.7 -m virtualenv venv
source venv/bin/activate
pip3 install -r requirements.txt # might install `pip install gym==0.25.2`

cd ./puffer
git submodule update --recursive --init

sudo update-alternatives --install /usr/bin/python python /usr/bin/python3.7 7
sudo update-alternatives --install /usr/bin/python3 python3 /usr/bin/python3.7 7

./fetch_submodules.py
./autogen.sh
./configure
sudo make -j CXXFLAGS='-DNONSECURE'
./src/portal/manage.py migrate
ln -s ../../../../../third_party/dist-for-puffer/ src/portal/puffer/static/puffer/dist


# add wandb key