#!/bin/bash

while : ; do
	PORT=$((9361+$1))
	
	rm -r chrome-sessions
	mkdir chrome-sessions
	
	command="chromium-browser --headless --disable-gpu http://0.0.0.0:8080/player/?wsport=${PORT} --user-data-dir=chrome-sessions/${PORT}.profile --remote-debugging-port=10001"
	echo "$command"
	sleep 3s

	timeout -s SIGINT 20s sh -c "$command" &
	bgpid=$!
	sleep 10
	p=$(ps -o pid= --ppid "$bgpid")
	
	pkill --signal INT -P $p
	echo killed
done
