#!/bin/bash

INPUT_SETTINGS_FILE=settings/puffer_exp3_input.yml
TTP_SETTINGS_FILE=settings/puffer_exp3_ttp.yml
SETTINGS=$TTP_SETTINGS_FILE

echo $SETTINGS

collect_data() {
    python3.7 ./src/scripts/data_collect_server.py --yaml-settings src/settings.yml & 
    RL_PID=$!
    sleep 10
    python3.7 src/media-server/offline_test.py --yaml-settings $SETTINGS --epochs 4
    kill $RL_PID
    sleep 60
}

clustering() {
    python3.7 ./src/scripts/clustering.py >> logs/progress.log
}

train_exp3() {
    python3.7 ./src/scripts/train/mabserver.py --type=train & 
    RL_PID=$!
    sleep 10
    python3.7 ./src/media-server/offline_test.py -f --epochs 8
    kill $RL_PID
    sleep 60
}

test_exp3() {
    python3.7 ./src/scripts/train/mabserver.py --type=inference & 
    RL_PID=$!
    sleep 10
    python3.7 ./src/media-server/offline_test.py -t
    kill $RL_PID
    sleep 60
}

eval_exp3() {
    echo "######################" >> logs/results.log
    echo "#### EXP3 Staring ####" >> logs/results.log
    echo "######################" >> logs/results.log
    date >> logs/results.log

    for i in $(seq $1 $2); do
        influx -execute 'drop series from /.*/' -database="puffer"
        echo "./weights/models/Exp3/checkpoint_000$i" > ./weights/models/Exp3/last_checkpoint.out

        test_exp3

        echo "No.$i\n" >> logs/results.log
        python3.7 src/scripts/plot_ssim_rebuffer.py src/settings.yml -o plot.png >> logs/results.log
        echo "===========================================================" >> logs/results.log
    done

}

mkdir -p logs

echo "#############################" >> logs/progress.log
echo "####### EXP3 Staring ########" >> logs/progress.log
date >> logs/progress.log

echo "#### EXP3 - collect data ####" >> logs/progress.log
collect_data

echo "#### EXP3 - clustering ######" >> logs/progress.log
clustering

echo "#### EXP3 - training ########" >> logs/progress.log
train_exp3

echo "#### EXP3 - Evaluation ######" >> logs/progress.log
eval_exp3 200 210

echo "######### EXP3 Ended!  ######" >> logs/progress.log
echo "#############################" >> logs/progress.log

sudo shutdown -h now
