#!/bin/bash

# train ttp
mkdir -p logs

echo "\n#### TTP-all running ####\n" >> logs/progress.log
date >> logs/progress.log
influx -execute 'drop series from /.*/' -database="puffer"
python3.7 src/media-server/offline_test.py --yaml-settings settings/all_3.yml --epochs 1 --clients 15

rm -r weights/ttp/original/

echo "ttp_train" >> logs/progress.log
python3.7 src/scripts/ttp.py src/settings.yml --save-model weights/ttp/original/ --save-hidden weights/ttp/hidden --tune >> logs/progress.log

echo "train_evaluation" >> logs/progress.log
python3.7 src/scripts/plot_ssim_rebuffer.py src/settings.yml -o plot.png >> logs/progress.log

# evaluation
influx -execute 'drop series from /.*/' -database="puffer"

python3.7 src/media-server/offline_test.py -t --yaml-settings settings/puffer.yml
python3.7 src/media-server/offline_test.py -t --yaml-settings settings/robust_mpc.yml
python3.7 src/media-server/offline_test.py -t --yaml-settings settings/mpc.yml
python3.7 src/media-server/offline_test.py -t --yaml-settings settings/bba.yml

echo "test_evaluation" >> logs/progress.log
python3.7 src/scripts/plot_ssim_rebuffer.py src/settings.yml -o plot.png >> logs/progress.log
