"""
Django settings for portal project.

Generated by 'django-admin startproject' using Django 2.0.5.

For more information on this file, see
https://docs.djangoproject.com/en/2.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.0/ref/settings/
"""

import os
import yaml

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
PUFFER_BASE_DIR = os.path.dirname(os.path.dirname(BASE_DIR));

# Modify if needed: path of Puffer's YAML configuration file
yaml_config_path = os.path.join(PUFFER_BASE_DIR, 'src', 'settings.yml')

# load YAML configuration
with open(yaml_config_path, 'r') as fh:
    yaml_config = yaml.safe_load(fh)
portal_config = yaml_config['portal_settings']
LIVE = yaml_config['portal_settings']['live']
postgres_config = yaml_config['postgres_connection']

# INFLUXDB is used for error reporting
INFLUXDB = None
if yaml_config['enable_logging'] and 'influxdb_connection' in yaml_config:
    INFLUXDB = yaml_config['influxdb_connection']

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = os.environ[portal_config['secret_key']]

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = portal_config['debug']

ALLOWED_HOSTS = ['*']

# Application definition

INSTALLED_APPS = [
    'puffer.apps.PufferConfig',
    'accounts.apps.AccountsConfig',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'portal.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'portal.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.0/ref/settings/#databases

default_db = {
    'ENGINE': 'django.db.backends.postgresql',
    'NAME': postgres_config['dbname'],
    'USER': postgres_config['user'],
    'PASSWORD': os.environ[postgres_config['password']],
    'HOST': postgres_config['host'],
    'PORT': postgres_config['port'],
}

if 'sslmode' in postgres_config:
    default_db['OPTIONS'] = {
        'sslmode': postgres_config['sslmode'],
        'sslrootcert': postgres_config['sslrootcert'],
        'sslcert': postgres_config['sslcert'],
        'sslkey': postgres_config['sslkey'],
    }

DATABASES = {
    'default': default_db
}

# Password validation
# https://docs.djangoproject.com/en/2.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Password hashers
PASSWORD_HASHERS = [
    'django.contrib.auth.hashers.Argon2PasswordHasher',
    'django.contrib.auth.hashers.BCryptSHA256PasswordHasher',
    'django.contrib.auth.hashers.BCryptPasswordHasher',
    'django.contrib.auth.hashers.PBKDF2PasswordHasher',
    'django.contrib.auth.hashers.PBKDF2SHA1PasswordHasher',
]

# Internationalization
# https://docs.djangoproject.com/en/2.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = False


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.0/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, 'puffer', 'static')

# Redirect to homepage after login and logout
LOGIN_REDIRECT_URL = '/'
LOGOUT_REDIRECT_URL = '/'
