#!/usr/bin/env python3.7

import argparse
import json
import shutil
import numpy as np
from http.server import HTTPServer, BaseHTTPRequestHandler
import os

sessions = dict()

def calc_total_score():
    total_qoe = 0
    count = 0

    for v in sessions.values():
        for x in v:
            total_qoe += x
            count += 1

    return total_qoe/count


def get_handler_class(args):
    class HandlerClass(BaseHTTPRequestHandler):
        def do_GET(self):
            self.send_response(200)
            self.end_headers()

        def do_POST(self):
            try:
                content_len = int(self.headers.get('Content-Length'))
                data = self.rfile.read(content_len)
                parsed_data = json.loads(data)
                if parsed_data['command'] != 'LOG_RETURNS':
                    return

                init_id = '1' #parsed_data['init_id']
                reward = parsed_data['reward']
                curr_ack_round = parsed_data['curr_ack_round']

                if curr_ack_round < 2:
                    self.send_response(200, "ok")
                    self.end_headers()
                    return

                if init_id not in sessions:
                    sessions[init_id] = []

                sessions[init_id].append(reward)

                print(calc_total_score())

                self.send_response(200, "ok")
                self.end_headers()
            except Exception as e:
                print(e)
                self.send_response(400, "error occurred " + str(e))
                self.end_headers()

    return HandlerClass


def run_server(args):
    server_address = (args.addr, args.port)
    handler = get_handler_class(args)
    httpd = HTTPServer(server_address, handler)

    print(f"Starting httpd server on {args.addr}:{args.port}")
    httpd.serve_forever()


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Run a simple HTTP server")
    parser.add_argument(
        "--addr",
        default="localhost",
        help="Specify the IP address on which the server listens",
    )
    parser.add_argument(
        "--port",
        type=int,
        default=9900,
        help="Specify the port on which the server listens",
    )
    args = parser.parse_args()

    run_server(args)
