#include "context.hh"
#include "filesystem.hh"

#include <exception>
#include <iostream>
#include <fstream>
#include <math.h>
#include <iomanip>

Context::Context(std::vector<double> weights) : weights_(weights)
{
  std::random_device rd;
  gen_ = new std::mt19937(rd());
}

double Context::get_weight(std::size_t arm)
{
  return weights_[arm];
}

double Context::get_probability(std::size_t arm)
{
  double sum_of_weights = 0;
  for (double weight : weights_)
  {
    sum_of_weights += weight;
  }

  return weights_[arm] / sum_of_weights;
}

std::size_t Context::predict()
{
  std::vector<double> probs;

  double sum_of_weights = 0;
  for (double weight : weights_)
  {
    sum_of_weights += weight;
  }

  for (double weight : weights_)
  {
    probs.push_back(weight / sum_of_weights);
  }
  
  std::discrete_distribution<int> distribution(probs.begin(), probs.end());
  int arm = distribution(*gen_);

  // std::cout << "probs: ";
  // for (double elem : probs)
  // {
  //   std::cout << "," << elem;
  // }
  // std::cout << std::endl;

  return arm;
}
