#ifndef CONTEXT_HH
#define CONTEXT_HH

#include <string>
#include <vector>
#include <random>

class Context
{
public:
    Context() {}
    Context(std::vector<double> weights);
    std::size_t predict();
    double get_weight(std::size_t arm);
    double get_probability(std::size_t arm);

private:
    std::vector<double> weights_;
    std::mt19937 *gen_;

    static constexpr double MIN_PROBABILITY_WEIGHT = 0.01;
    static constexpr double MIN_PROBABILITY = 1e-10;

    double min_probability_weight_{MIN_PROBABILITY_WEIGHT};
    double min_probability_{MIN_PROBABILITY};
};

#endif /* CONTEXT_HH */
