#ifndef EXP3_HH
#define EXP3_HH

#include <string>
#include <vector>
#include <map>

#include "context.hh"

class Exp3
{
public:
    Exp3(std::string model_path);
    virtual void reload_model();
    std::size_t version_;
    bool should_reload();
    double get_weight(std::size_t context_idx, std::size_t arm);
    double get_probability(std::size_t context_idx, std::size_t arm);
protected:
    static constexpr size_t DISTRETIZE_BUF_SIZE = 30 + 1; // from 0 to 30 inclusive
    std::string model_path_;
    std::map<int, Context> contexts_;
    std::size_t num_of_arms_ = 0;
    std::size_t buf_size_ = 0;
};

#endif /* EXP3_HH */
