#ifndef EXP3_KMEANS_HH
#define EXP3_KMEANS_HH

#include <string>
#include <vector>
#include <map>
#include <fstream>

#include "exp3.hh"

class Kmeans
{
public:
    Kmeans(std::string kmeans_path);
    std::size_t find_optimal_cluster(std::vector<double> input);
    std::size_t calc_inner_index(std::size_t cluster, 
                                 std::size_t dis_buffer);

private:
    std::map<int, std::vector<double>> clusters_;
    std::vector<double> mean_;
    std::vector<double> std_;

    double delta_;
    void load_clusters(fs::path kmeans_path);
    double dist(std::vector<double> v1, std::vector<double> v2);
    std::vector<double> read_file(fs::path filename);
    void normalize_inplace(std::vector<double> &input);
};

#endif /* EXP3_KMEANS_HH */
