#include <sender.hh>

#include <curl/curl.h>
#include <curlpp/cURLpp.hpp>
#include <curlpp/Easy.hpp>
#include <curlpp/Options.hpp>
#include <curlpp/Infos.hpp>
#include <exception>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <unistd.h>

Sender::Sender(unsigned int port): port_(port)
{
  // constrcut socket
  if ((sock_ = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      std::cerr << "Socket creation error" << std::endl;
  }

  struct sockaddr_in serv_addr;
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(port);

  if (inet_pton(AF_INET, "127.0.0.1", &serv_addr.sin_addr)<= 0) {
      std::cerr << "Invalid address/ Address not supported" << std::endl;
  }

  // TODO: ignore error when using sender with HTTP and not socket
  if ((client_fd_ = connect(sock_, (struct sockaddr*)&serv_addr, sizeof(serv_addr))) < 0) {
      std::cerr << "sender socket Connection Failed: " << client_fd_ << std::endl;
  }
}

json Sender::post(json data)
{
  // ##################### Sockets server #####################
  char buffer[131072] = {0};
  strcpy(buffer, (data.dump() + "\n").c_str());
  
  write(sock_, buffer, 131072);

  char recv_buf[100] = {0};
  read(sock_, recv_buf, 100);
  std::string response(recv_buf);
  json res = json::parse(response.substr(0, response.find('\n')));
  return res;
}

void Sender::post(json data, std::string endpoint)
{
  post(data, 0, endpoint);
}

void Sender::post(json data, std::string server_id, std::string endpoint)
{
  // ##################### HTTP server #####################
  std::list<std::string> header;
  header.push_back("Content-Type: application/json");
  int port = 8000 + stoi(server_id) - 1;

  // std::ostringstream response;
  curlpp::Easy request;
  request.setOpt(new curlpp::options::Url("http://localhost:" + std::to_string(port) + '/' + endpoint));
  request.setOpt(new curlpp::options::HttpHeader(header));
  request.setOpt(new curlpp::options::PostFields(data.dump()));
  request.setOpt(new curlpp::options::PostFieldSize(data.dump().size()));
  // request.setOpt(new cURLpp::Options::WriteStream(&response));

  try {
    request.perform();

    long status = curlpp::infos::ResponseCode::get(request);

    // if (status == 200) {
    //   std::cout << "response: " << response.str() << std::endl;
    // }
  }
  catch (std::exception& e) {
    std::cout << "exception " << e.what() << std::endl;
  }
}