# nips2023_ood

## Description

This codebase provides the implementation and necessary files to reproduce the experiments and results presented in the paper. The repository consists of the following files:

- **data/**: This directory contains the predictions and scores of the Out-of-Distribution (OOD) methods used in the experiments.

- **utils.py**: This file includes functions that are used to load the data for the experiments from the **data/** directory.

- **metrics.py**: This file contains classes that compute various metrics used for evaluating the performance of the proposed method. The metrics and their usage are described in detail in the paper.

- **plot-curves-compute-tables.ipynb**: This Jupyter Notebook provides the code to compute the results shown in the experiments table in the paper. It also generates visualizations of the Receiver Operating Characteristic (ROC) curve, Precision-Recall (PR) curve, and Correct Classification Rate (CCR)-False Positive Rate (FPR) curve. Curves are visualized for both: the single score, and double score settings.

- **plot-scores-2D.ipynb**: This Jupyter Notebook visualizes the selective function of the double score method and the density of the In-Distribution (ID) data and Out-of-Distribution (OOD) data. It helps in understanding the behavior and performance of the proposed method.

- **example_synthetic_data.ipynb**: This Jupyter Notebook replicates experiments on the synthetic data.

## Requirements

To run the code and reproduce the results, make sure you have the following dependencies installed:

- Python 3.10+
- Jupyter Notebook
- Pandas
- Matplotlib
- Tqdm