% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.ltrccif.R
\name{tune.ltrccif}
\alias{tune.ltrccif}
\title{Tune \code{mtry} to the optimal value with respect to out-of-bag error for a LTRCCIF model}
\usage{
tune.ltrccif(
  formula,
  data,
  id,
  mtryStart = NULL,
  stepFactor = 2,
  time.eval = NULL,
  time.tau = NULL,
  ntreeTry = 100L,
  bootstrap = c("by.sub", "by.root", "none", "by.user"),
  samptype = c("swor", "swr"),
  sampfrac = 0.632,
  samp = NULL,
  na.action = "na.omit",
  trace = TRUE,
  doBest = FALSE,
  plot = FALSE,
  applyfun = NULL,
  cores = NULL,
  control = partykit::ctree_control(teststat = "quad", testtype = "Univ", mincriterion
    = 0, saveinfo = FALSE, minsplit = max(ceiling(sqrt(nrow(data))), 20), minbucket =
    max(ceiling(sqrt(nrow(data))), 7), minprob = 0.01)
)
}
\arguments{
\item{formula}{a formula object, with the response being a \code{\link[survival]{Surv}}
object, with form


\code{Surv(tleft, tright, event)}.}

\item{data}{a data frame containing \code{n} rows of
left-truncated right-censored observations.}

\item{id}{variable name of subject identifiers. If this is present, it will be
searched for in the \code{data} data frame. Each group of rows in \code{data}
with the same subject \code{id} represents the covariate path through time of
a single subject. If not specified, the algorithm then assumes \code{data}
contains left-truncated and right-censored survival data with time-invariant
covariates.}

\item{mtryStart}{starting value of \code{mtry}; default is \code{sqrt(nvar)}.}

\item{stepFactor}{at each iteration, \code{mtry} is inflated (or deflated)
by this value. The default value is \code{2}.}

\item{time.eval}{a vector of time points, at which the estimated survival probabilities
are evaluated.}

\item{time.tau}{an optional vector, with the \emph{i}-th entry giving the upper time limit for the
computed survival probabilities for the \emph{i}-th data (i.e., only computes
survival probabilies at \code{time.eval[time.eval <= time.tau[i]]} for the \emph{i}-th
data of interest).}

\item{ntreeTry}{number of trees used at the tuning step.}

\item{bootstrap}{bootstrap protocol.
(1) If \code{id} is present,
the choices are: \code{"by.sub"} (by default) which bootstraps subjects,
\code{"by.root"} which bootstraps pseudo-subjects.
Both can be with or without replacement (by default sampling is without
replacement; see the option \code{perturb} below);
(2) If \code{id} is not specified, it bootstraps the \code{data} by
sampling with or without replacement.
Regardless of the presence of \code{id}, if \code{"none"} is chosen,
\code{data} is not bootstrapped at all, and is used in
every individual tree. If \code{"by.user"} is choosen,
the bootstrap specified by \code{samp} is used.}

\item{samptype}{choices are \code{swor} (sampling without replacement) and
\code{swr} (sampling with replacement). The default action here is sampling
without replacement.}

\item{sampfrac}{a fraction, determining the proportion of subjects to draw
without replacement when \code{samptype = "swor"}. The default value is \code{0.632}.
To be more specific, if \code{id} is present, \code{0.632 * N} of subjects with their
pseudo-subject observations are drawn without replacement (\code{N} denotes the
number of subjects); otherwise, \code{0.632 * n} is the requested size
of the sample.}

\item{samp}{Bootstrap specification when \code{bootstype = "by.user"}.
Array of dim \code{n x ntree} specifying how many times each record appears
in each bootstrap sample.}

\item{na.action}{action taken if the data contains \code{NA}’s. The default
\code{"na.omit"} removes the entire record if any of its entries is
\code{NA} (for x-variables this applies only to those specifically listed
in \code{formula}). See function \code{\link[partykit]{cforest}} for
other available options.}

\item{trace}{whether to print the progress of the search. \code{trace = TRUE} is set by default.}

\item{doBest}{whether to run a \code{\link{ltrccif}} object using the optimal \code{mtry} found.
\code{doBest = FALSE} is set by default.}

\item{plot}{whether to plot the out-of-bag error as a function of \code{mtry}.
\code{plot = FALSE} is set by default.}

\item{applyfun}{an optional \code{lapply}-style function with arguments
\code{function(X, FUN, ...)}.
It is used for computing the variable selection criterion. The default is to use the
basic \code{lapply} function unless the \code{cores} argument is specified (see below).
See \code{\link[partykit]{ctree_control}}.}

\item{cores}{numeric. See \code{\link[partykit]{ctree_control}}.}

\item{control}{a list with control parameters, see \code{\link[partykit]{cforest}}.
The default values correspond to those of the default values used by \code{\link{ltrccif}}.}
}
\value{
If \code{doBest = FALSE} (default), this returns the optimal mtry value of those searched.

If \code{doBest = TRUE}, this returns the \code{\link{ltrccif}} object produced with the optimal \code{mtry}.
}
\description{
Starting with the default value of \code{mtry}, search for the optimal value
(with respect to out-of-bag error estimate) of \code{mtry} for \code{\link{ltrccif}}.
}
\examples{
### Example with data pbcsample
library(survival)
Formula = Surv(Start, Stop, Event) ~ age + alk.phos + ast + chol + edema
## mtry tuned by the OOB procedure with stepFactor 3, number of trees built 10.
mtryT = tune.ltrccif(formula = Formula, data = pbcsample, id = ID, stepFactor = 3,
                     ntreeTry = 10L)


}
\seealso{
\code{\link{sbrier_ltrc}} for evaluation of model fit when searching
for the optimal value of \code{mtry}.
}
