#import os
#os.environ['R_HOME'] = '/Library/Frameworks/R.framework/Resources'

from pylab import *
import numpy as np
import pandas as pd
import time, sys, dill
from statsmodels.stats.multicomp import pairwise_tukeyhsd

#models = ['cox', 'gbm', 'sf', 'spp']
models = ['cox','gbm','spp']
nsub = 1000
type = 'linear'
score_t = [0.3,0.5,0.7,0.9]
cpu_nint = [1,5,10,20,50]
colors = {'spp':'red', 'cox':'cyan', 'gbm':'lime', 'sf':'gold'}

linewidth = 1.0
boxwidth = 0.2
ylimm = {'tll': [-0.6,0.5], 'auc':[0.55,0.85]} # linear
#ylimm = {'tll': [-0.6,0.2], 'auc':[0.1,1.0]}

posit = {m: arange(0,len(score_t)) + p
         for m,p in zip(models,linspace(-0.35,0.35,len(models)))}

figure(figsize=(15,6))

scores = {m:dill.load(open('result/'+type+'/'+m+'_data_nsub'+str(nsub)+'nint5.dill','rb'))
          for m in models}

subplot(2,8,(1,3))
xlim(-0.6,len(score_t)-0.4)
sc = 'tll'; title(sc);ylim(ylimm[sc])
kentei = [pd.DataFrame(columns=['model','score']) for _ in score_t]
for m in models:
    z = array(scores[m][sc]).T
    s = [round(x,1) for x in scores[m]['t']]
    z = z[isin(s,score_t),:].T
    bp = boxplot(z,positions=posit[m], widths=[boxwidth]*len(posit[m]),
                 boxprops={'facecolor':colors[m], 'linewidth':linewidth},
                 flierprops={'markersize':4, 'markerfacecolor':colors[m]},
                 medianprops={'color':'k', 'linewidth':linewidth},
                 whiskerprops={'linewidth':linewidth,'linestyle':'--'},
                 capprops={'linewidth':linewidth},
                 patch_artist=True, notch=False)
    for i in range(len(score_t)):
        df = pd.DataFrame([[m,x] for x in z[:,i]], columns=['model','score'])
        kentei[i] = pd.concat([kentei[i],df],axis=0)
#show()
#sys.exit()
print('KENTEI:')
for df in kentei:
    print(pairwise_tukeyhsd(df.score, df.model))
    
subplot(2,8,(9,11))
xlim(-0.6,len(score_t)-0.4)
sc = 'auc'; title(sc);ylim(ylimm[sc])
kentei = [pd.DataFrame(columns=['model','score']) for _ in score_t]
for m in models:
    z = array(scores[m][sc]).T
    s = [round(x,1) for x in scores[m]['t']]
    z = z[isin(s,score_t),:].T
    bp = boxplot(z,positions=posit[m], widths=[boxwidth]*len(posit[m]),
                 boxprops={'facecolor':colors[m], 'linewidth':linewidth},
                 flierprops={'markersize':4, 'markerfacecolor':colors[m]},
                 medianprops={'color':'k', 'linewidth':linewidth},
                 whiskerprops={'linewidth':linewidth,'linestyle':'--'},
                 capprops={'linewidth':linewidth},
                 patch_artist=True, notch=False)
    for i in range(len(score_t)):
        df = pd.DataFrame([[m,x] for x in z[:,i]], columns=['model','score'])
        kentei[i] = pd.concat([kentei[i],df],axis=0)
print('KENTEI:')
for df in kentei:
    print(pairwise_tukeyhsd(df.score, df.model))

scores = {m:dill.load(open('result/'+type+'/'+m+'_data_nsub'+str(nsub)+'nint20.dill','rb'))
          for m in models}

subplot(2,8,(4,6))
xlim(-0.6,len(score_t)-0.4)
sc = 'tll'; title(sc);ylim(ylimm[sc])
kentei = [pd.DataFrame(columns=['model','score']) for _ in score_t]
for m in models:
    z = array(scores[m][sc]).T
    s = [round(x,1) for x in scores[m]['t']]
    z = z[isin(s,score_t),:].T
    bp = boxplot(z,positions=posit[m], widths=[boxwidth]*len(posit[m]),
                 boxprops={'facecolor':colors[m], 'linewidth':linewidth},
                 flierprops={'markersize':4, 'markerfacecolor':colors[m]},
                 medianprops={'color':'k', 'linewidth':linewidth},
                 whiskerprops={'linewidth':linewidth,'linestyle':'--'},
                 capprops={'linewidth':linewidth},
                 patch_artist=True, notch=False)
    for i in range(len(score_t)):
        df = pd.DataFrame([[m,x] for x in z[:,i]], columns=['model','score'])
        kentei[i] = pd.concat([kentei[i],df],axis=0)
print('KENTEI:')
for df in kentei:
    print(pairwise_tukeyhsd(df.score, df.model))
    
subplot(2,8,(12,14))
xlim(-0.6,len(score_t)-0.4)
sc = 'auc'; title(sc);ylim(ylimm[sc])
kentei = [pd.DataFrame(columns=['model','score']) for _ in score_t]
for m in models:
    z = array(scores[m][sc]).T
    s = [round(x,1) for x in scores[m]['t']]
    z = z[isin(s,score_t),:].T
    bp = boxplot(z,positions=posit[m], widths=[boxwidth]*len(posit[m]),
                 boxprops={'facecolor':colors[m], 'linewidth':linewidth},
                 flierprops={'markersize':4, 'markerfacecolor':colors[m]},
                 medianprops={'color':'k', 'linewidth':linewidth},
                 whiskerprops={'linewidth':linewidth, 'linestyle':'--'},
                 capprops={'linewidth':linewidth},
                 patch_artist=True, notch=False)
    for i in range(len(score_t)):
        df = pd.DataFrame([[m,x] for x in z[:,i]], columns=['model','score'])
        kentei[i] = pd.concat([kentei[i],df],axis=0)
print('KENTEI:')
for df in kentei:
    print(pairwise_tukeyhsd(df.score, df.model))

subplot(1,8,(7,8))
title('cpu')
yscale('log')
cpu = {m:[] for m in models}
for nint in cpu_nint:
    scores = {m:dill.load(open('result/'+type+'/'+m+'_data_nsub'+str(nsub)+'nint'+str(nint)+'.dill','rb'))
              for m in models}
    for m in models:
        if m in ['spp','gbm']:
            cpu[m].append(array(scores[m]['cpu'])/9.)
        else:
            cpu[m].append(array(scores[m]['cpu']))
for m in models:
    errorbar(cpu_nint, mean(cpu[m],1), yerr=std(cpu[m],1), capsize=5,
             fmt='o', markersize=5, ecolor=colors[m], markerfacecolor=colors[m],
             markeredgecolor=colors[m])
    plot(cpu_nint, mean(cpu[m],1),colors[m])


tight_layout()
savefig('result/'+type+'/figure_nonlinear.eps')
show()

